/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;

public final class DetailsPart
implements IFormPart,
IPartSelectionListener {
    private IManagedForm managedForm;
    private ScrolledPageBook pageBook;
    private IFormPart masterPart;
    private IStructuredSelection currentSelection;
    private Hashtable pages;
    private IDetailsPageProvider pageProvider;
    private int pageLimit = Integer.MAX_VALUE;

    public DetailsPart(IManagedForm iManagedForm, ScrolledPageBook scrolledPageBook) {
        this.pageBook = scrolledPageBook;
        this.pages = new Hashtable();
        this.initialize(iManagedForm);
    }

    public DetailsPart(IManagedForm iManagedForm, Composite composite, int n) {
        this(iManagedForm, iManagedForm.getToolkit().createPageBook(composite, n | 0x200 | 0x100));
    }

    public void registerPage(Object object, IDetailsPage iDetailsPage) {
        this.registerPage(object, iDetailsPage, true);
    }

    private void registerPage(Object object, IDetailsPage iDetailsPage, boolean bl) {
        this.pages.put(object, new PageBag(iDetailsPage, bl));
        iDetailsPage.initialize(this.managedForm);
    }

    public void setPageProvider(IDetailsPageProvider iDetailsPageProvider) {
        this.pageProvider = iDetailsPageProvider;
    }

    @Override
    public void commit(boolean bl) {
        IDetailsPage iDetailsPage = this.getCurrentPage();
        if (iDetailsPage != null) {
            iDetailsPage.commit(bl);
        }
    }

    public IDetailsPage getCurrentPage() {
        Object object;
        Control control = this.pageBook.getCurrentPage();
        if (control != null && (object = control.getData()) instanceof IDetailsPage) {
            return (IDetailsPage)object;
        }
        return null;
    }

    @Override
    public void dispose() {
        Enumeration enumeration = this.pages.elements();
        while (enumeration.hasMoreElements()) {
            PageBag pageBag = (PageBag)enumeration.nextElement();
            pageBag.dispose();
        }
    }

    @Override
    public void initialize(IManagedForm iManagedForm) {
        this.managedForm = iManagedForm;
    }

    @Override
    public boolean isDirty() {
        IDetailsPage iDetailsPage = this.getCurrentPage();
        if (iDetailsPage != null) {
            return iDetailsPage.isDirty();
        }
        return false;
    }

    @Override
    public boolean isStale() {
        IDetailsPage iDetailsPage = this.getCurrentPage();
        if (iDetailsPage != null) {
            return iDetailsPage.isStale();
        }
        return false;
    }

    @Override
    public void refresh() {
        IDetailsPage iDetailsPage = this.getCurrentPage();
        if (iDetailsPage != null) {
            iDetailsPage.refresh();
        }
    }

    @Override
    public void setFocus() {
        IDetailsPage iDetailsPage = this.getCurrentPage();
        if (iDetailsPage != null) {
            iDetailsPage.setFocus();
        }
    }

    @Override
    public boolean setFormInput(Object object) {
        return false;
    }

    @Override
    public void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
        this.masterPart = iFormPart;
        this.currentSelection = iSelection instanceof IStructuredSelection ? (IStructuredSelection)iSelection : null;
        this.update();
    }

    private void update() {
        Object object = null;
        if (this.currentSelection != null) {
            for (Object e : this.currentSelection) {
                if (object == null) {
                    object = this.getKey(e);
                    continue;
                }
                if (this.getKey(e).equals(object)) continue;
                object = null;
                break;
            }
        }
        this.showPage(object);
    }

    private Object getKey(Object object) {
        Object object2;
        if (this.pageProvider != null && (object2 = this.pageProvider.getPageKey(object)) != null) {
            return object2;
        }
        return object.getClass();
    }

    private void showPage(final Object object) {
        this.checkLimit();
        final IDetailsPage iDetailsPage = this.getCurrentPage();
        if (object != null) {
            IDetailsPage iDetailsPage2;
            PageBag pageBag = (PageBag)this.pages.get(object);
            IDetailsPage iDetailsPage3 = iDetailsPage2 = pageBag != null ? pageBag.getPage() : null;
            if (iDetailsPage2 == null && this.pageProvider != null && (iDetailsPage2 = this.pageProvider.getPage(object)) != null) {
                this.registerPage(object, iDetailsPage2, false);
            }
            if (iDetailsPage2 != null) {
                final IDetailsPage iDetailsPage4 = iDetailsPage2;
                BusyIndicator.showWhile((Display)this.pageBook.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!DetailsPart.this.pageBook.hasPage(object)) {
                            Composite composite = DetailsPart.this.pageBook.createPage(object);
                            iDetailsPage4.createContents(composite);
                            composite.setData((Object)iDetailsPage4);
                        }
                        if (iDetailsPage != null && iDetailsPage.isDirty()) {
                            iDetailsPage.commit(false);
                        }
                        if (iDetailsPage4.isStale()) {
                            iDetailsPage4.refresh();
                        }
                        iDetailsPage4.selectionChanged(DetailsPart.this.masterPart, (ISelection)DetailsPart.this.currentSelection);
                        DetailsPart.this.pageBook.showPage(object);
                    }
                });
                return;
            }
        }
        if (iDetailsPage != null && iDetailsPage.isDirty()) {
            iDetailsPage.commit(false);
        }
        this.pageBook.showEmptyPage();
    }

    private void checkLimit() {
        if (this.pages.size() <= this.getPageLimit()) {
            return;
        }
        int n = PageBag.getCurrentTicket();
        int n2 = n - this.getPageLimit();
        Enumeration enumeration = this.pages.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            PageBag pageBag = (PageBag)this.pages.get(k);
            if (pageBag.getTicket() > n2 || pageBag.isFixed() || pageBag.getPage().equals(this.getCurrentPage())) continue;
            pageBag.dispose();
            this.pages.remove(k);
            this.pageBook.removePage(k, false);
        }
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public void setPageLimit(int n) {
        this.pageLimit = n;
        this.checkLimit();
    }

    private static class PageBag {
        private static int counter;
        private int ticket;
        private IDetailsPage page;
        private boolean fixed;

        public PageBag(IDetailsPage iDetailsPage, boolean bl) {
            this.page = iDetailsPage;
            this.fixed = bl;
            this.ticket = ++counter;
        }

        public int getTicket() {
            return this.ticket;
        }

        public IDetailsPage getPage() {
            return this.page;
        }

        public void dispose() {
            this.page.dispose();
            this.page = null;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public static int getCurrentTicket() {
            return counter;
        }
    }
}

