/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;

public abstract class WizardSelectionPage
extends WizardPage {
    private IWizardNode selectedNode = null;
    private List selectedWizardNodes = new ArrayList();

    protected WizardSelectionPage(String string) {
        super(string);
        this.setPageComplete(false);
    }

    private void addSelectedNode(IWizardNode iWizardNode) {
        if (iWizardNode == null) {
            return;
        }
        if (this.selectedWizardNodes.contains(iWizardNode)) {
            return;
        }
        this.selectedWizardNodes.add(iWizardNode);
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.selectedNode != null;
    }

    @Override
    public void dispose() {
        super.dispose();
        int n = 0;
        while (n < this.selectedWizardNodes.size()) {
            ((IWizardNode)this.selectedWizardNodes.get(n)).dispose();
            ++n;
        }
    }

    @Override
    public IWizardPage getNextPage() {
        if (this.selectedNode == null) {
            return null;
        }
        boolean bl = this.selectedNode.isContentCreated();
        IWizard iWizard = this.selectedNode.getWizard();
        if (iWizard == null) {
            this.setSelectedNode(null);
            return null;
        }
        if (!bl) {
            iWizard.addPages();
        }
        return iWizard.getStartingPage();
    }

    public IWizardNode getSelectedNode() {
        return this.selectedNode;
    }

    protected void setSelectedNode(IWizardNode iWizardNode) {
        this.addSelectedNode(iWizardNode);
        this.selectedNode = iWizardNode;
        if (this.isCurrentPage()) {
            this.getContainer().updateButtons();
        }
    }
}

