/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.wizard;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public abstract class WizardPage
extends DialogPage
implements IWizardPage {
    private String name;
    private IWizard wizard = null;
    private boolean isPageComplete = true;
    private IWizardPage previousPage = null;

    protected WizardPage(String string) {
        this(string, null, null);
    }

    protected WizardPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string2, imageDescriptor);
        Assert.isNotNull((Object)string);
        this.name = string;
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null;
    }

    protected IWizardContainer getContainer() {
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getContainer();
    }

    protected IDialogSettings getDialogSettings() {
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getDialogSettings();
    }

    @Override
    public Image getImage() {
        Image image = super.getImage();
        if (image == null && this.wizard != null) {
            return this.wizard.getDefaultPageImage();
        }
        return image;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IWizardPage getNextPage() {
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getNextPage(this);
    }

    @Override
    public IWizardPage getPreviousPage() {
        if (this.previousPage != null) {
            return this.previousPage;
        }
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getPreviousPage(this);
    }

    @Override
    public Shell getShell() {
        IWizardContainer iWizardContainer = this.getContainer();
        if (iWizardContainer == null) {
            return null;
        }
        return iWizardContainer.getShell();
    }

    @Override
    public IWizard getWizard() {
        return this.wizard;
    }

    protected boolean isCurrentPage() {
        return this.getContainer() != null && this == this.getContainer().getCurrentPage();
    }

    @Override
    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    @Override
    public void setDescription(String string) {
        super.setDescription(string);
        if (this.isCurrentPage()) {
            this.getContainer().updateTitleBar();
        }
    }

    @Override
    public void setErrorMessage(String string) {
        super.setErrorMessage(string);
        if (this.isCurrentPage()) {
            this.getContainer().updateMessage();
        }
    }

    @Override
    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        super.setImageDescriptor(imageDescriptor);
        if (this.isCurrentPage()) {
            this.getContainer().updateTitleBar();
        }
    }

    @Override
    public void setMessage(String string, int n) {
        super.setMessage(string, n);
        if (this.isCurrentPage()) {
            this.getContainer().updateMessage();
        }
    }

    public void setPageComplete(boolean bl) {
        this.isPageComplete = bl;
        if (this.isCurrentPage()) {
            this.getContainer().updateButtons();
        }
    }

    @Override
    public void setPreviousPage(IWizardPage iWizardPage) {
        this.previousPage = iWizardPage;
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        if (this.isCurrentPage()) {
            this.getContainer().updateTitleBar();
        }
    }

    @Override
    public void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
    }

    public String toString() {
        return this.name;
    }
}

