/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class Wizard
implements IWizard {
    public static final String DEFAULT_IMAGE = "org.eclipse.jface.wizard.Wizard.pageImage";
    private IWizardContainer container = null;
    private List pages = new ArrayList();
    private boolean needsProgressMonitor = false;
    private boolean forcePreviousAndNextButtons = false;
    private boolean isHelpAvailable = false;
    private Image defaultImage = null;
    private ImageDescriptor defaultImageDescriptor = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.jface.wizard.Wizard.pageImage");
    private RGB titleBarColor = null;
    private String windowTitle = null;
    private IDialogSettings dialogSettings = null;

    protected Wizard() {
    }

    public void addPage(IWizardPage iWizardPage) {
        this.pages.add(iWizardPage);
        iWizardPage.setWizard(this);
    }

    @Override
    public void addPages() {
    }

    @Override
    public boolean canFinish() {
        int n = 0;
        while (n < this.pages.size()) {
            if (!((IWizardPage)this.pages.get(n)).isPageComplete()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public void createPageControls(Composite composite) {
        int n = 0;
        while (n < this.pages.size()) {
            IWizardPage iWizardPage = (IWizardPage)this.pages.get(n);
            iWizardPage.createControl(composite);
            Assert.isNotNull((Object)iWizardPage.getControl());
            ++n;
        }
    }

    @Override
    public void dispose() {
        int n = 0;
        while (n < this.pages.size()) {
            try {
                ((IWizardPage)this.pages.get(n)).dispose();
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.jface", 4, exception.getMessage(), (Throwable)exception);
                Policy.getLog().log((IStatus)status);
            }
            ++n;
        }
        if (this.defaultImage != null) {
            JFaceResources.getResources().destroyImage(this.defaultImageDescriptor);
            this.defaultImage = null;
        }
    }

    @Override
    public IWizardContainer getContainer() {
        return this.container;
    }

    @Override
    public Image getDefaultPageImage() {
        if (this.defaultImage == null) {
            this.defaultImage = JFaceResources.getResources().createImageWithDefault(this.defaultImageDescriptor);
        }
        return this.defaultImage;
    }

    @Override
    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        int n = this.pages.indexOf(iWizardPage);
        if (n == this.pages.size() - 1 || n == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(n + 1);
    }

    @Override
    public IWizardPage getPage(String string) {
        int n = 0;
        while (n < this.pages.size()) {
            IWizardPage iWizardPage = (IWizardPage)this.pages.get(n);
            String string2 = iWizardPage.getName();
            if (string2.equals(string)) {
                return iWizardPage;
            }
            ++n;
        }
        return null;
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    @Override
    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        int n = this.pages.indexOf(iWizardPage);
        if (n == 0 || n == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(n - 1);
    }

    public Shell getShell() {
        if (this.container == null) {
            return null;
        }
        return this.container.getShell();
    }

    @Override
    public IWizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return (IWizardPage)this.pages.get(0);
    }

    @Override
    public RGB getTitleBarColor() {
        return this.titleBarColor;
    }

    @Override
    public String getWindowTitle() {
        return this.windowTitle;
    }

    @Override
    public boolean isHelpAvailable() {
        return this.isHelpAvailable;
    }

    @Override
    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    @Override
    public boolean needsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public abstract boolean performFinish();

    @Override
    public void setContainer(IWizardContainer iWizardContainer) {
        this.container = iWizardContainer;
    }

    public void setDefaultPageImageDescriptor(ImageDescriptor imageDescriptor) {
        this.defaultImageDescriptor = imageDescriptor;
    }

    public void setDialogSettings(IDialogSettings iDialogSettings) {
        this.dialogSettings = iDialogSettings;
    }

    public void setForcePreviousAndNextButtons(boolean bl) {
        this.forcePreviousAndNextButtons = bl;
    }

    public void setHelpAvailable(boolean bl) {
        this.isHelpAvailable = bl;
    }

    public void setNeedsProgressMonitor(boolean bl) {
        this.needsProgressMonitor = bl;
    }

    public void setTitleBarColor(RGB rGB) {
        this.titleBarColor = rGB;
    }

    public void setWindowTitle(String string) {
        this.windowTitle = string;
        if (this.container != null) {
            this.container.updateWindowTitle();
        }
    }
}

