/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.wizard;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ProgressMonitorPart
extends Composite
implements IProgressMonitorWithBlocking {
    protected Label fLabel;
    protected String fTaskName;
    protected String fSubTaskName;
    protected ProgressIndicator fProgressIndicator;
    protected Control fCancelComponent;
    protected volatile boolean fIsCanceled;
    protected IStatus blockedStatus;
    protected Listener fCancelListener = new Listener(){

        public void handleEvent(Event event) {
            ProgressMonitorPart.this.setCanceled(true);
            if (ProgressMonitorPart.this.fCancelComponent != null) {
                ProgressMonitorPart.this.fCancelComponent.setEnabled(false);
            }
        }
    };
    private ToolBar fToolBar;
    private ToolItem fStopButton;
    private boolean fHasStopButton = false;

    public ProgressMonitorPart(Composite composite, Layout layout) {
        this(composite, layout, false);
    }

    public ProgressMonitorPart(Composite composite, Layout layout, int n) {
        super(composite, 0);
        this.initialize(layout, n);
    }

    public ProgressMonitorPart(Composite composite, Layout layout, boolean bl) {
        super(composite, 0);
        this.fHasStopButton = bl;
        this.initialize(layout, -1);
    }

    public void attachToCancelComponent(Control control) {
        if (this.fHasStopButton) {
            this.setCancelEnabled(true);
        } else {
            this.fCancelComponent = control;
            this.fCancelComponent.addListener(13, this.fCancelListener);
        }
    }

    public void beginTask(String string, int n) {
        this.fTaskName = string;
        this.fSubTaskName = "";
        this.updateLabel();
        if (n == -1 || n == 0) {
            this.fProgressIndicator.beginAnimatedTask();
        } else {
            this.fProgressIndicator.beginTask(n);
        }
        if (this.fToolBar != null && !this.fToolBar.isDisposed()) {
            this.fToolBar.setVisible(true);
            this.fToolBar.setFocus();
        }
    }

    public void done() {
        this.fLabel.setText("");
        this.fSubTaskName = "";
        this.fProgressIndicator.sendRemainingWork();
        this.fProgressIndicator.done();
        if (this.fToolBar != null && !this.fToolBar.isDisposed()) {
            this.fToolBar.setVisible(false);
        }
    }

    protected static String escapeMetaCharacters(String string) {
        if (string == null || string.indexOf(38) < 0) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '&') {
                stringBuffer.append("&&");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void initialize(Layout layout, int n) {
        FontMetrics fontMetrics;
        GC gC;
        if (layout == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            layout = gridLayout;
        }
        int n2 = 1;
        if (this.fHasStopButton) {
            ++n2;
        }
        this.setLayout(layout);
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).numColumns = n2;
        }
        this.fLabel = new Label((Composite)this, 16384);
        this.fLabel.setLayoutData((Object)new GridData(4, 2, true, false, n2, 1));
        if (n == -1) {
            gC = new GC((Drawable)this.fLabel);
            fontMetrics = gC.getFontMetrics();
            gC.dispose();
            n = fontMetrics.getHeight();
        }
        this.fProgressIndicator = new ProgressIndicator(this);
        gC = new GridData();
        gC.horizontalAlignment = 4;
        gC.grabExcessHorizontalSpace = true;
        gC.grabExcessVerticalSpace = false;
        gC.verticalAlignment = 2;
        gC.heightHint = n;
        this.fProgressIndicator.setLayoutData(gC);
        if (this.fHasStopButton) {
            this.fToolBar = new ToolBar((Composite)this, 0x800000);
            gC = new GridData();
            gC.grabExcessHorizontalSpace = false;
            gC.grabExcessVerticalSpace = false;
            gC.verticalAlignment = 2;
            this.fToolBar.setLayoutData((Object)gC);
            this.fStopButton = new ToolItem(this.fToolBar, 8);
            this.fStopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ProgressMonitorPart.this.setCanceled(true);
                    if (ProgressMonitorPart.this.fStopButton != null) {
                        ProgressMonitorPart.this.fStopButton.setEnabled(false);
                    }
                }
            });
            fontMetrics = ImageDescriptor.createFromFile(ProgressMonitorPart.class, "images/stop.gif").createImage((Device)this.getDisplay());
            Cursor cursor = new Cursor((Device)this.getDisplay(), 0);
            this.fToolBar.setCursor(cursor);
            this.fStopButton.setImage((Image)fontMetrics);
            this.fStopButton.addDisposeListener(new DisposeListener((Image)fontMetrics, cursor){
                private final /* synthetic */ Image val$stopImage;
                private final /* synthetic */ Cursor val$arrowCursor;
                {
                    this.val$stopImage = image;
                    this.val$arrowCursor = cursor;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    this.val$stopImage.dispose();
                    this.val$arrowCursor.dispose();
                }
            });
            this.fStopButton.setEnabled(false);
            this.fStopButton.setToolTipText(JFaceResources.getString("ProgressMonitorPart.cancelToolTip"));
        }
    }

    public void internalWorked(double d) {
        this.fProgressIndicator.worked(d);
    }

    public boolean isCanceled() {
        return this.fIsCanceled;
    }

    public void removeFromCancelComponent(Control control) {
        if (this.fHasStopButton) {
            this.setCancelEnabled(false);
        } else {
            Assert.isTrue((this.fCancelComponent == control && this.fCancelComponent != null ? 1 : 0) != 0);
            this.fCancelComponent.removeListener(13, this.fCancelListener);
            this.fCancelComponent = null;
        }
    }

    public void setCanceled(boolean bl) {
        this.fIsCanceled = bl;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fLabel.setFont(font);
        this.fProgressIndicator.setFont(font);
    }

    public void setTaskName(String string) {
        this.fTaskName = string;
        this.updateLabel();
    }

    public void subTask(String string) {
        this.fSubTaskName = string;
        this.updateLabel();
    }

    protected void updateLabel() {
        if (this.blockedStatus == null) {
            String string = this.taskLabel();
            this.fLabel.setText(string);
        } else {
            this.fLabel.setText(this.blockedStatus.getMessage());
        }
        this.fLabel.update();
    }

    private String taskLabel() {
        boolean bl;
        boolean bl2 = this.fTaskName != null && this.fTaskName.length() > 0;
        boolean bl3 = bl = this.fSubTaskName != null && this.fSubTaskName.length() > 0;
        if (bl2) {
            if (bl) {
                return ProgressMonitorPart.escapeMetaCharacters(JFaceResources.format("Set_SubTask", new Object[]{this.fTaskName, this.fSubTaskName}));
            }
            return ProgressMonitorPart.escapeMetaCharacters(this.fTaskName);
        }
        if (bl) {
            return ProgressMonitorPart.escapeMetaCharacters(this.fSubTaskName);
        }
        return "";
    }

    public void worked(int n) {
        this.internalWorked(n);
    }

    public void clearBlocked() {
        this.blockedStatus = null;
        this.updateLabel();
    }

    public void setBlocked(IStatus iStatus) {
        this.blockedStatus = iStatus;
        this.updateLabel();
    }

    private void setCancelEnabled(boolean bl) {
        if (this.fStopButton != null && !this.fStopButton.isDisposed()) {
            this.fStopButton.setEnabled(bl);
            if (bl) {
                this.fToolBar.setFocus();
            }
        }
    }
}

