/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.window;

import java.util.HashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public abstract class ToolTip {
    private Control control;
    private int xShift = 3;
    private int yShift = 0;
    private int popupDelay = 0;
    private int hideDelay = 0;
    private ToolTipOwnerControlListener listener;
    private HashMap data;
    private static Shell CURRENT_TOOLTIP;
    public static final int RECREATE = 1;
    public static final int NO_RECREATE = 2;
    private TooltipHideListener hideListener = new TooltipHideListener();
    private Listener shellListener;
    private boolean hideOnMouseDown = true;
    private boolean respectDisplayBounds = true;
    private boolean respectMonitorBounds = true;
    private int style;
    private Object currentArea;

    public ToolTip(Control control) {
        this(control, 1, false);
    }

    public ToolTip(Control control, int n, boolean bl) {
        this.control = control;
        this.style = n;
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ToolTip.this.data = null;
                ToolTip.this.deactivate();
            }
        });
        this.listener = new ToolTipOwnerControlListener();
        this.shellListener = new Listener(){

            public void handleEvent(final Event event) {
                if (ToolTip.this.control != null && !ToolTip.this.control.isDisposed()) {
                    ToolTip.this.control.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ToolTip.this.control.getDisplay().getActiveShell() != CURRENT_TOOLTIP) {
                                ToolTip.this.toolTipHide(CURRENT_TOOLTIP, event);
                            }
                        }
                    });
                }
            }
        };
        if (!bl) {
            this.activate();
        }
    }

    public void setData(String string, Object object) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(string, object);
    }

    public Object getData(String string) {
        if (this.data != null) {
            return this.data.get(string);
        }
        return null;
    }

    public void setShift(Point point) {
        this.xShift = point.x;
        this.yShift = point.y;
    }

    public void activate() {
        this.deactivate();
        this.control.addListener(12, (Listener)this.listener);
        this.control.addListener(32, (Listener)this.listener);
        this.control.addListener(5, (Listener)this.listener);
        this.control.addListener(7, (Listener)this.listener);
        this.control.addListener(3, (Listener)this.listener);
        this.control.addListener(37, (Listener)this.listener);
    }

    public void deactivate() {
        this.control.removeListener(12, (Listener)this.listener);
        this.control.removeListener(32, (Listener)this.listener);
        this.control.removeListener(5, (Listener)this.listener);
        this.control.removeListener(7, (Listener)this.listener);
        this.control.removeListener(3, (Listener)this.listener);
        this.control.removeListener(37, (Listener)this.listener);
    }

    public boolean isRespectDisplayBounds() {
        return this.respectDisplayBounds;
    }

    public void setRespectDisplayBounds(boolean bl) {
        this.respectDisplayBounds = bl;
    }

    public boolean isRespectMonitorBounds() {
        return this.respectMonitorBounds;
    }

    public void setRespectMonitorBounds(boolean bl) {
        this.respectMonitorBounds = bl;
    }

    protected boolean shouldCreateToolTip(Event event) {
        if ((this.style & 2) != 0) {
            Object object = this.getToolTipArea(event);
            if (object == null) {
                this.hide();
                return false;
            }
            boolean bl = !object.equals(this.currentArea);
            return bl;
        }
        return true;
    }

    private boolean shouldHideToolTip(Event event) {
        if (event != null && event.type == 5 && (this.style & 2) != 0) {
            Object object = this.getToolTipArea(event);
            if (object == null) {
                this.hide();
                return false;
            }
            boolean bl = !object.equals(this.currentArea);
            return bl;
        }
        return true;
    }

    protected Object getToolTipArea(Event event) {
        return this.control;
    }

    public void show(Point point) {
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        event.widget = this.control;
        this.toolTipCreate(event);
    }

    private Shell toolTipCreate(Event event) {
        if (this.shouldCreateToolTip(event)) {
            Shell shell = new Shell(this.control.getShell(), 540676);
            shell.setLayout((Layout)new FillLayout());
            this.toolTipOpen(shell, event);
            return shell;
        }
        return null;
    }

    private void toolTipShow(Shell shell, Event event) {
        if (!shell.isDisposed()) {
            this.currentArea = this.getToolTipArea(event);
            this.createToolTipContentArea(event, (Composite)shell);
            if (this.isHideOnMouseDown()) {
                this.toolTipHookBothRecursively((Control)shell);
            } else {
                this.toolTipHookByTypeRecursively((Control)shell, true, 7);
            }
            shell.pack();
            Point point = shell.getSize();
            Point point2 = this.fixupDisplayBounds(point, this.getLocation(point, event));
            Point point3 = shell.getDisplay().getCursorLocation();
            if (point3.y == point2.y && point2.x < point3.x && point2.x + point.x > point3.x) {
                point2.y -= 2;
            }
            shell.setLocation(point2);
            shell.setVisible(true);
        }
    }

    private Point fixupDisplayBounds(Point point, Point point2) {
        if (this.respectDisplayBounds || this.respectMonitorBounds) {
            Rectangle rectangle;
            Point point3 = new Point(point.x + point2.x, point.y + point2.y);
            Monitor[] monitorArray = this.control.getDisplay().getMonitors();
            if (this.respectMonitorBounds && monitorArray.length > 1) {
                rectangle = this.control.getMonitor().getBounds();
                Point point4 = new Point(point2.x, point2.y);
                int n = 0;
                while (n < monitorArray.length) {
                    Rectangle rectangle2 = monitorArray[n].getBounds();
                    if (rectangle2.contains(point4)) {
                        rectangle = rectangle2;
                        break;
                    }
                    ++n;
                }
            } else {
                rectangle = this.control.getDisplay().getBounds();
            }
            if (!rectangle.contains(point2) || !rectangle.contains(point3)) {
                if (point3.x > rectangle.x + rectangle.width) {
                    point2.x -= point3.x - (rectangle.x + rectangle.width);
                }
                if (point3.y > rectangle.y + rectangle.height) {
                    point2.y -= point3.y - (rectangle.y + rectangle.height);
                }
                if (point2.x < rectangle.x) {
                    point2.x = rectangle.x;
                }
                if (point2.y < rectangle.y) {
                    point2.y = rectangle.y;
                }
            }
        }
        return point2;
    }

    public Point getLocation(Point point, Event event) {
        return this.control.toDisplay(event.x + this.xShift, event.y + this.yShift);
    }

    private void toolTipHide(Shell shell, Event event) {
        if (shell != null && !shell.isDisposed() && this.shouldHideToolTip(event)) {
            this.control.getShell().removeListener(27, this.shellListener);
            this.currentArea = null;
            this.passOnEvent(shell, event);
            shell.dispose();
            CURRENT_TOOLTIP = null;
            this.afterHideToolTip(event);
        }
    }

    private void passOnEvent(Shell shell, Event event) {
        if (this.control != null && !this.control.isDisposed() && event != null && event.widget != this.control && event.type == 3) {
            shell.close();
        }
    }

    private void toolTipOpen(final Shell shell, final Event event) {
        if (CURRENT_TOOLTIP != null) {
            this.toolTipHide(CURRENT_TOOLTIP, null);
        }
        CURRENT_TOOLTIP = shell;
        this.control.getShell().addListener(27, this.shellListener);
        if (this.popupDelay > 0) {
            this.control.getDisplay().timerExec(this.popupDelay, new Runnable(){

                @Override
                public void run() {
                    ToolTip.this.toolTipShow(shell, event);
                }
            });
        } else {
            this.toolTipShow(CURRENT_TOOLTIP, event);
        }
        if (this.hideDelay > 0) {
            this.control.getDisplay().timerExec(this.popupDelay + this.hideDelay, new Runnable(){

                @Override
                public void run() {
                    ToolTip.this.toolTipHide(shell, null);
                }
            });
        }
    }

    private void toolTipHookByTypeRecursively(Control control, boolean bl, int n) {
        if (bl) {
            control.addListener(n, (Listener)this.hideListener);
        } else {
            control.removeListener(n, (Listener)this.hideListener);
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n2 = 0;
            while (n2 < controlArray.length) {
                this.toolTipHookByTypeRecursively(controlArray[n2], bl, n);
                ++n2;
            }
        }
    }

    private void toolTipHookBothRecursively(Control control) {
        control.addListener(3, (Listener)this.hideListener);
        control.addListener(7, (Listener)this.hideListener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = 0;
            while (n < controlArray.length) {
                this.toolTipHookBothRecursively(controlArray[n]);
                ++n;
            }
        }
    }

    protected abstract Composite createToolTipContentArea(Event var1, Composite var2);

    protected void afterHideToolTip(Event event) {
    }

    public void setHideDelay(int n) {
        this.hideDelay = n;
    }

    public void setPopupDelay(int n) {
        this.popupDelay = n;
    }

    public boolean isHideOnMouseDown() {
        return this.hideOnMouseDown;
    }

    public void setHideOnMouseDown(final boolean bl) {
        if (CURRENT_TOOLTIP != null && !CURRENT_TOOLTIP.isDisposed() && bl != this.hideOnMouseDown) {
            this.control.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (CURRENT_TOOLTIP != null && CURRENT_TOOLTIP.isDisposed()) {
                        ToolTip.this.toolTipHookByTypeRecursively((Control)CURRENT_TOOLTIP, bl, 3);
                    }
                }
            });
        }
        this.hideOnMouseDown = bl;
    }

    public void hide() {
        this.toolTipHide(CURRENT_TOOLTIP, null);
    }

    private class ToolTipOwnerControlListener
    implements Listener {
        private ToolTipOwnerControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: 
                case 3: 
                case 5: 
                case 12: 
                case 37: {
                    ToolTip.this.toolTipHide(CURRENT_TOOLTIP, event);
                    break;
                }
                case 32: {
                    ToolTip.this.toolTipCreate(event);
                    break;
                }
                case 7: {
                    if (CURRENT_TOOLTIP != null && !CURRENT_TOOLTIP.isDisposed() && CURRENT_TOOLTIP.getBounds().contains(ToolTip.this.control.toDisplay(event.x, event.y))) break;
                    ToolTip.this.toolTipHide(CURRENT_TOOLTIP, event);
                }
            }
        }
    }

    private class TooltipHideListener
    implements Listener {
        private TooltipHideListener() {
        }

        public void handleEvent(Event event) {
            if (event.widget instanceof Control) {
                Control control = (Control)event.widget;
                Shell shell = control.getShell();
                switch (event.type) {
                    case 3: {
                        if (!ToolTip.this.isHideOnMouseDown()) break;
                        ToolTip.this.toolTipHide(shell, event);
                        break;
                    }
                    case 7: {
                        Rectangle rectangle = shell.getBounds();
                        rectangle.x += 5;
                        rectangle.y += 5;
                        rectangle.width -= 10;
                        rectangle.height -= 10;
                        if (rectangle.contains(control.getDisplay().getCursorLocation())) break;
                        ToolTip.this.toolTipHide(shell, event);
                    }
                }
            }
        }
    }
}

