/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.window;

import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class DefaultToolTip
extends ToolTip {
    private String text;
    private Color backgroundColor;
    private Font font;
    private Image backgroundImage;
    private Color foregroundColor;
    private Image image;
    private int style = 32;

    public DefaultToolTip(Control control) {
        super(control);
    }

    public DefaultToolTip(Control control, int n, boolean bl) {
        super(control, n, bl);
    }

    @Override
    protected Composite createToolTipContentArea(Event event, Composite composite) {
        Image image = this.getImage(event);
        Image image2 = this.getBackgroundImage(event);
        String string = this.getText(event);
        Color color = this.getForegroundColor(event);
        Color color2 = this.getBackgroundColor(event);
        Font font = this.getFont(event);
        CLabel cLabel = new CLabel(composite, this.getStyle(event));
        if (string != null) {
            cLabel.setText(string);
        }
        if (image != null) {
            cLabel.setImage(image);
        }
        if (color != null) {
            cLabel.setForeground(color);
        }
        if (color2 != null) {
            cLabel.setBackground(color2);
        }
        if (image2 != null) {
            cLabel.setBackgroundImage(image);
        }
        if (font != null) {
            cLabel.setFont(font);
        }
        return cLabel;
    }

    protected int getStyle(Event event) {
        return this.style;
    }

    protected Image getImage(Event event) {
        return this.image;
    }

    protected Color getForegroundColor(Event event) {
        return this.foregroundColor == null ? event.widget.getDisplay().getSystemColor(28) : this.foregroundColor;
    }

    protected Color getBackgroundColor(Event event) {
        return this.backgroundColor == null ? event.widget.getDisplay().getSystemColor(29) : this.backgroundColor;
    }

    protected Image getBackgroundImage(Event event) {
        return this.backgroundImage;
    }

    protected Font getFont(Event event) {
        return this.font;
    }

    protected String getText(Event event) {
        return this.text;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public void setText(String string) {
        this.text = string;
    }
}

