/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.window;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class ApplicationWindow
extends Window
implements IRunnableContext {
    private MenuManager menuBarManager = null;
    private IToolBarManager toolBarManager = null;
    private StatusLineManager statusLineManager = null;
    private ICoolBarManager coolBarManager = null;
    protected Label seperator1;
    private boolean operationInProgress = false;

    protected Label getSeperator1() {
        return this.seperator1;
    }

    public ApplicationWindow(Shell shell) {
        super(shell);
    }

    protected void addMenuBar() {
        if (this.getShell() == null && this.menuBarManager == null) {
            this.menuBarManager = this.createMenuManager();
        }
    }

    protected void addStatusLine() {
        if (this.getShell() == null && this.statusLineManager == null) {
            this.statusLineManager = this.createStatusLineManager();
        }
    }

    protected void addToolBar(int n) {
        if (this.getShell() == null && this.toolBarManager == null && this.coolBarManager == null) {
            this.toolBarManager = this.createToolBarManager2(n);
        }
    }

    protected void addCoolBar(int n) {
        if (this.getShell() == null && this.toolBarManager == null && this.coolBarManager == null) {
            this.coolBarManager = this.createCoolBarManager2(n);
        }
    }

    @Override
    protected boolean canHandleShellCloseEvent() {
        return super.canHandleShellCloseEvent() && !this.operationInProgress;
    }

    @Override
    public boolean close() {
        if (this.operationInProgress) {
            return false;
        }
        if (super.close()) {
            if (this.menuBarManager != null) {
                this.menuBarManager.dispose();
                this.menuBarManager = null;
            }
            if (this.toolBarManager != null) {
                if (this.toolBarManager instanceof IToolBarManager2) {
                    ((IToolBarManager2)this.toolBarManager).dispose();
                } else if (this.toolBarManager instanceof ToolBarManager) {
                    ((ToolBarManager)this.toolBarManager).dispose();
                }
                this.toolBarManager = null;
            }
            if (this.statusLineManager != null) {
                this.statusLineManager.dispose();
                this.statusLineManager = null;
            }
            if (this.coolBarManager != null) {
                if (this.coolBarManager instanceof ICoolBarManager2) {
                    ((ICoolBarManager2)this.coolBarManager).dispose();
                } else if (this.coolBarManager instanceof CoolBarManager) {
                    ((CoolBarManager)this.coolBarManager).dispose();
                }
                this.coolBarManager = null;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.createTrimWidgets(shell);
    }

    protected void createTrimWidgets(Shell shell) {
        if (this.menuBarManager != null) {
            shell.setMenuBar(this.menuBarManager.createMenuBar((Decorations)shell));
            this.menuBarManager.updateAll(true);
        }
        if (this.showTopSeperator()) {
            this.seperator1 = new Label((Composite)shell, 258);
        }
        this.createToolBarControl((Composite)shell);
        this.createCoolBarControl((Composite)shell);
        this.createStatusLine(shell);
    }

    @Override
    protected Layout getLayout() {
        return new ApplicationWindowLayout();
    }

    protected boolean showTopSeperator() {
        return !Util.isMac();
    }

    protected void createStatusLine(Shell shell) {
        if (this.statusLineManager != null) {
            this.statusLineManager.createControl((Composite)shell, 0);
        }
    }

    protected MenuManager createMenuManager() {
        return new MenuManager();
    }

    protected StatusLineManager createStatusLineManager() {
        return new StatusLineManager();
    }

    protected ToolBarManager createToolBarManager(int n) {
        return new ToolBarManager(n);
    }

    protected IToolBarManager createToolBarManager2(int n) {
        return this.createToolBarManager(n);
    }

    protected CoolBarManager createCoolBarManager(int n) {
        return new CoolBarManager(n);
    }

    protected ICoolBarManager createCoolBarManager2(int n) {
        return this.createCoolBarManager(n);
    }

    protected Control createToolBarControl(Composite composite) {
        if (this.toolBarManager != null) {
            if (this.toolBarManager instanceof IToolBarManager2) {
                return ((IToolBarManager2)this.toolBarManager).createControl2(composite);
            }
            if (this.toolBarManager instanceof ToolBarManager) {
                return ((ToolBarManager)this.toolBarManager).createControl(composite);
            }
        }
        return null;
    }

    protected Control createCoolBarControl(Composite composite) {
        if (this.coolBarManager != null) {
            if (this.coolBarManager instanceof ICoolBarManager2) {
                return ((ICoolBarManager2)this.coolBarManager).createControl2(composite);
            }
            if (this.coolBarManager instanceof CoolBarManager) {
                return ((CoolBarManager)this.coolBarManager).createControl(composite);
            }
        }
        return null;
    }

    protected Font getFont() {
        return JFaceResources.getFont(this.getSymbolicFontName());
    }

    public MenuManager getMenuBarManager() {
        return this.menuBarManager;
    }

    protected StatusLineManager getStatusLineManager() {
        return this.statusLineManager;
    }

    public String getSymbolicFontName() {
        return "org.eclipse.jface.textfont";
    }

    public ToolBarManager getToolBarManager() {
        if (this.toolBarManager instanceof ToolBarManager) {
            return (ToolBarManager)this.toolBarManager;
        }
        return null;
    }

    public IToolBarManager getToolBarManager2() {
        return this.toolBarManager;
    }

    public CoolBarManager getCoolBarManager() {
        if (this.coolBarManager instanceof CoolBarManager) {
            return (CoolBarManager)this.coolBarManager;
        }
        return null;
    }

    public ICoolBarManager getCoolBarManager2() {
        return this.coolBarManager;
    }

    protected Control getToolBarControl() {
        if (this.toolBarManager != null) {
            if (this.toolBarManager instanceof IToolBarManager2) {
                return ((IToolBarManager2)this.toolBarManager).getControl2();
            }
            if (this.toolBarManager instanceof ToolBarManager) {
                return ((ToolBarManager)this.toolBarManager).getControl();
            }
        }
        return null;
    }

    protected Control getCoolBarControl() {
        if (this.coolBarManager != null) {
            if (this.coolBarManager instanceof ICoolBarManager2) {
                return ((ICoolBarManager2)this.coolBarManager).getControl2();
            }
            if (this.coolBarManager instanceof CoolBarManager) {
                return ((CoolBarManager)this.coolBarManager).getControl();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run(final boolean var1_1, boolean var2_2, final IRunnableWithProgress var3_3) throws InvocationTargetException, InterruptedException {
        try {
            this.operationInProgress = true;
            var4_4 = this.getStatusLineManager();
            if (var4_4 == null) {
                var3_3.run((IProgressMonitor)new NullProgressMonitor());
                return;
            }
            var5_5 = var4_4.isCancelEnabled();
            var6_6 = this.getContents();
            var7_7 = var6_6.getDisplay();
            var8_8 = this.getShell();
            var9_9 = var6_6.getEnabled();
            var10_10 = this.getMenuBarManager();
            var11_11 = null;
            if (var10_10 != null) {
                var11_11 = var10_10.getMenu();
                var10_10 = null;
            }
            var12_12 = false;
            if (var11_11 != null) {
                var12_12 = var11_11.getEnabled();
            }
            var13_13 = this.getToolBarControl();
            var14_14 = false;
            if (var13_13 != null) {
                var14_14 = var13_13.getEnabled();
            }
            var15_15 = this.getCoolBarControl();
            var16_16 = false;
            if (var15_15 != null) {
                var16_16 = var15_15.getEnabled();
            }
            var17_17 = var7_7.getShells();
            var18_18 = new boolean[var17_17.length];
            var19_19 = 0;
            while (var19_19 < var17_17.length) {
                var20_21 = var17_17[var19_19];
                if (var20_21 != var8_8 && var20_21 != null && !var20_21.isDisposed()) {
                    var18_18[var19_19] = var20_21.getEnabled();
                    var20_21.setEnabled(false);
                }
                ++var19_19;
            }
            var19_20 = var7_7.getFocusControl();
            try {
                var6_6.setEnabled(false);
                if (var11_11 != null) {
                    var11_11.setEnabled(false);
                }
                if (var13_13 != null) {
                    var13_13.setEnabled(false);
                }
                if (var15_15 != null) {
                    var15_15.setEnabled(false);
                }
                var4_4.setCancelEnabled(var2_2);
                var20_21 = new Exception[1];
                BusyIndicator.showWhile((Display)var7_7, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ModalContext.run(var3_3, var1_1, var4_4.getProgressMonitor(), var7_7);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            var20_21[0] = invocationTargetException;
                        }
                        catch (InterruptedException interruptedException) {
                            var20_21[0] = interruptedException;
                        }
                    }
                });
                if (var20_21[0] == null) ** break block27
                if (var20_21[0] instanceof InvocationTargetException) {
                    throw (InvocationTargetException)var20_21[0];
                }
                if (var20_21[0] instanceof InterruptedException) {
                    throw (InterruptedException)var20_21[0];
                }
                break block28;
            }
            finally {
                this.operationInProgress = false;
                var22_24 = 0;
                if (true) ** GOTO lbl68
            }
            {
                block28: {
                }
            }
            do {
                if ((var23_26 = var17_17[var22_24]) != var8_8 && var23_26 != null && !var23_26.isDisposed()) {
                    var23_26.setEnabled(var18_18[var22_24]);
                }
                ++var22_24;
lbl68:
                // 2 sources

            } while (var22_24 < var17_17.length);
            if (!var6_6.isDisposed()) {
                var6_6.setEnabled(var9_9);
            }
            if (var11_11 != null && !var11_11.isDisposed()) {
                var11_11.setEnabled(var12_12);
            }
            if (var13_13 != null && !var13_13.isDisposed()) {
                var13_13.setEnabled(var14_14);
            }
            if (var15_15 != null && !var15_15.isDisposed()) {
                var15_15.setEnabled(var16_16);
            }
            var4_4.setCancelEnabled(var5_5);
            if (var19_20 != null && !var19_20.isDisposed()) {
                var19_20.forceFocus();
            }
        }
        finally {
            this.operationInProgress = false;
        }
    }

    public void setStatus(String string) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(string);
        }
    }

    protected boolean toolBarChildrenExist() {
        Control control = this.getToolBarControl();
        if (control instanceof ToolBar) {
            return ((ToolBar)control).getItemCount() > 0;
        }
        return false;
    }

    protected boolean coolBarChildrenExist() {
        Control control = this.getCoolBarControl();
        if (control instanceof CoolBar) {
            return ((CoolBar)control).getItemCount() > 0;
        }
        return false;
    }

    class ApplicationWindowLayout
    extends Layout {
        static final int VGAP = 2;
        static final int BAR_SIZE = 23;

        ApplicationWindowLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Point point = new Point(0, 0);
            Control[] controlArray = composite.getChildren();
            int n3 = 0;
            while (n3 < controlArray.length) {
                Control control = controlArray[n3];
                boolean bl2 = false;
                if (ApplicationWindow.this.getToolBarControl() == control) {
                    if (!ApplicationWindow.this.toolBarChildrenExist()) {
                        bl2 = true;
                        point.y += 23;
                    }
                } else if (ApplicationWindow.this.getCoolBarControl() == control) {
                    if (!ApplicationWindow.this.coolBarChildrenExist()) {
                        bl2 = true;
                        point.y += 23;
                    }
                } else if ((ApplicationWindow.this.statusLineManager == null || ApplicationWindow.this.statusLineManager.getControl() != control) && n3 > 0) {
                    bl2 = false;
                }
                if (!bl2) {
                    Point point2 = control.computeSize(n, n2, bl);
                    point.x = Math.max(point.x, point2.x);
                    point.y += point2.y + 2;
                }
                ++n3;
            }
            if (n != -1) {
                point.x = n;
            }
            if (n2 != -1) {
                point.y = n2;
            }
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Point point;
                Control control = controlArray[n];
                if (control == ApplicationWindow.this.seperator1) {
                    point = control.computeSize(-1, -1, bl);
                    control.setBounds(rectangle.x, rectangle.y, rectangle.width, point.y);
                    rectangle.y += point.y;
                    rectangle.height -= point.y;
                } else if (ApplicationWindow.this.getToolBarControl() == control) {
                    if (ApplicationWindow.this.toolBarChildrenExist()) {
                        point = control.computeSize(-1, -1, bl);
                        control.setBounds(rectangle.x, rectangle.y, rectangle.width, point.y);
                        rectangle.y += point.y + 2;
                        rectangle.height -= point.y + 2;
                    }
                } else if (ApplicationWindow.this.getCoolBarControl() == control) {
                    if (ApplicationWindow.this.coolBarChildrenExist()) {
                        point = control.computeSize(rectangle.width, -1, bl);
                        control.setBounds(rectangle.x, rectangle.y, rectangle.width, point.y);
                        rectangle.y += point.y + 2;
                        rectangle.height -= point.y + 2;
                    }
                } else if (ApplicationWindow.this.statusLineManager != null && ApplicationWindow.this.statusLineManager.getControl() == control) {
                    point = control.computeSize(-1, -1, bl);
                    control.setBounds(rectangle.x, rectangle.y + rectangle.height - point.y, rectangle.width, point.y);
                    rectangle.height -= point.y + 2;
                } else {
                    control.setBounds(rectangle.x, rectangle.y + 2, rectangle.width, rectangle.height - 2);
                }
                ++n;
            }
        }
    }
}

