/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers.deferred;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.deferred.FastProgressReporter;
import org.eclipse.jface.viewers.deferred.IntHashMap;

public class LazySortedCollection {
    private final int MIN_CAPACITY = 8;
    private Object[] contents = new Object[8];
    private int[] leftSubTree = new int[8];
    private int[] rightSubTree = new int[8];
    private int[] nextUnsorted = new int[8];
    private int[] treeSize = new int[8];
    private int[] parentTree = new int[8];
    private int root = -1;
    private int lastNode = 0;
    private int firstUnusedNode = -1;
    private static final float loadFactor = 0.75f;
    private IntHashMap objectIndices;
    private Comparator comparator;
    private static int counter = 0;
    public boolean enableDebug = false;
    private Object lazyRemovalFlag = new Object(){

        public String toString() {
            return "Lazy removal flag";
        }
    };
    private static final int DIR_LEFT = 0;
    private static final int DIR_RIGHT = 1;
    private static final int DIR_UNSORTED = 2;
    private static final int DIR_ROOT = 3;
    private static final int DIR_UNUSED = 4;

    private void setRootNode(int n) {
        this.root = n;
        if (n != -1) {
            this.parentTree[n] = -1;
        }
    }

    public LazySortedCollection(Comparator comparator) {
        this.comparator = comparator;
    }

    public void testInvariants() {
        if (!this.enableDebug) {
            return;
        }
        this.testInvariants(this.root);
    }

    private void testInvariants(int n) {
        if (n == -1) {
            return;
        }
        int n2 = this.getSubtreeSize(n);
        int n3 = this.leftSubTree[n];
        int n4 = this.rightSubTree[n];
        int n5 = this.nextUnsorted[n];
        if (this.isUnsorted(n)) {
            Assert.isTrue((n3 == -1 ? 1 : 0) != 0, (String)"unsorted nodes shouldn't have a left subtree");
            Assert.isTrue((n4 == -1 ? 1 : 0) != 0, (String)"unsorted nodes shouldn't have a right subtree");
        }
        if (n3 != -1) {
            this.testInvariants(n3);
            Assert.isTrue((this.parentTree[n3] == n ? 1 : 0) != 0, (String)"left node has invalid parent pointer");
        }
        if (n4 != -1) {
            this.testInvariants(n4);
            Assert.isTrue((this.parentTree[n4] == n ? 1 : 0) != 0, (String)"right node has invalid parent pointer");
        }
        int n6 = n;
        while (n5 != -1) {
            int n7 = this.treeSize[n5];
            this.recomputeTreeSize(n5);
            Assert.isTrue((this.treeSize[n5] == n7 ? 1 : 0) != 0, (String)"Invalid node size for unsorted node");
            Assert.isTrue((this.leftSubTree[n5] == -1 ? 1 : 0) != 0, (String)"unsorted nodes shouldn't have left subtrees");
            Assert.isTrue((this.rightSubTree[n5] == -1 ? 1 : 0) != 0, (String)"unsorted nodes shouldn't have right subtrees");
            Assert.isTrue((this.parentTree[n5] == n6 ? 1 : 0) != 0, (String)"unsorted node has invalid parent pointer");
            Assert.isTrue((this.contents[n5] != this.lazyRemovalFlag ? 1 : 0) != 0, (String)"unsorted nodes should not be lazily removed");
            n6 = n5;
            n5 = this.nextUnsorted[n5];
        }
        this.recomputeTreeSize(n);
        Assert.isTrue((n2 == this.getSubtreeSize(n) ? 1 : 0) != 0, (String)"invalid tree size");
    }

    private boolean isUnsorted(int n) {
        int n2 = this.parentTree[n];
        if (n2 != -1) {
            return this.nextUnsorted[n2] == n;
        }
        return false;
    }

    private final boolean isLess(int n, int n2) {
        return this.comparator.compare(this.contents[n], this.contents[n2]) < 0;
    }

    private final int addUnsorted(int n, int n2) {
        int n3;
        if (n2 == -1) {
            return n;
        }
        if (n == -1) {
            this.nextUnsorted[n2] = -1;
            this.treeSize[n2] = 1;
            return n2;
        }
        if (this.treeSize[n] == 0) {
            this.removeSubTree(n);
            this.nextUnsorted[n2] = -1;
            this.treeSize[n2] = 1;
            return n2;
        }
        if (!this.enableDebug && this.leftSubTree[n] == -1 && this.rightSubTree[n] == -1 && this.leftSubTree[n2] == -1 && this.rightSubTree[n2] == -1 && --counter % this.treeSize[n] == 0) {
            this.nextUnsorted[n2] = n;
            this.parentTree[n2] = this.parentTree[n];
            this.parentTree[n] = n2;
            this.treeSize[n2] = this.treeSize[n] + 1;
            return n2;
        }
        this.nextUnsorted[n2] = n3 = this.nextUnsorted[n];
        if (n3 == -1) {
            this.treeSize[n2] = 1;
        } else {
            this.treeSize[n2] = this.treeSize[n3] + 1;
            this.parentTree[n3] = n2;
        }
        this.parentTree[n2] = n;
        this.nextUnsorted[n] = n2;
        int n4 = n;
        this.treeSize[n4] = this.treeSize[n4] + 1;
        return n;
    }

    public int size() {
        int n = this.getSubtreeSize(this.root);
        this.testInvariants();
        return n;
    }

    private final int partition(int n, int n2) {
        int n3 = this.nextUnsorted[n2];
        if (this.isLess(n2, n)) {
            int n4;
            this.leftSubTree[n] = n4 = this.addUnsorted(this.leftSubTree[n], n2);
            this.parentTree[n4] = n;
        } else {
            int n5;
            this.rightSubTree[n] = n5 = this.addUnsorted(this.rightSubTree[n], n2);
            this.parentTree[n5] = n;
        }
        return n3;
    }

    private final int partition(int n, FastProgressReporter fastProgressReporter) throws InterruptedException {
        if (n == -1) {
            return -1;
        }
        if (this.contents[n] == this.lazyRemovalFlag && (n = this.removeNode(n)) == -1) {
            return -1;
        }
        int n2 = this.nextUnsorted[n];
        while (n2 != -1) {
            this.nextUnsorted[n] = n2 = this.partition(n, n2);
            if (n2 != -1) {
                this.parentTree[n2] = n;
            }
            if (!fastProgressReporter.isCanceled()) continue;
            throw new InterruptedException();
        }
        this.nextUnsorted[n] = -1;
        return n;
    }

    private final int getSubtreeSize(int n) {
        if (n == -1) {
            return 0;
        }
        return this.treeSize[n];
    }

    public final void setCapacity(int n) {
        if (n > this.contents.length) {
            this.setArraySize(n);
        }
    }

    private final void setArraySize(int n) {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.contents, 0, objectArray, 0, this.lastNode);
        this.contents = objectArray;
        int[] nArray = new int[n];
        System.arraycopy(this.leftSubTree, 0, nArray, 0, this.lastNode);
        this.leftSubTree = nArray;
        int[] nArray2 = new int[n];
        System.arraycopy(this.rightSubTree, 0, nArray2, 0, this.lastNode);
        this.rightSubTree = nArray2;
        int[] nArray3 = new int[n];
        System.arraycopy(this.nextUnsorted, 0, nArray3, 0, this.lastNode);
        this.nextUnsorted = nArray3;
        int[] nArray4 = new int[n];
        System.arraycopy(this.treeSize, 0, nArray4, 0, this.lastNode);
        this.treeSize = nArray4;
        int[] nArray5 = new int[n];
        System.arraycopy(this.parentTree, 0, nArray5, 0, this.lastNode);
        this.parentTree = nArray5;
    }

    private final int createNode(Object object) {
        int n = -1;
        if (this.firstUnusedNode == -1) {
            n = this.lastNode;
            if (this.contents.length <= this.lastNode) {
                this.setCapacity(this.lastNode * 2);
            }
            ++this.lastNode;
        } else {
            n = this.firstUnusedNode;
            this.firstUnusedNode = this.nextUnsorted[n];
        }
        this.contents[n] = object;
        this.treeSize[n] = 1;
        this.leftSubTree[n] = -1;
        this.rightSubTree[n] = -1;
        this.nextUnsorted[n] = -1;
        if (this.objectIndices != null) {
            this.objectIndices.put(object, n);
        }
        return n;
    }

    private int getObjectIndex(Object object) {
        if (this.objectIndices == null) {
            int n = -1;
            this.objectIndices = new IntHashMap((int)((float)this.contents.length / 0.75f) + 1, 0.75f);
            int n2 = 0;
            while (n2 < this.lastNode) {
                Object object2 = this.contents[n2];
                if (object2 != null && object2 != this.lazyRemovalFlag) {
                    this.objectIndices.put(object2, n2);
                    if (object == object2) {
                        n = n2;
                    }
                }
                ++n2;
            }
            return n;
        }
        return this.objectIndices.get(object, -1);
    }

    private void replaceNode(int n, int n2) {
        int n3 = this.parentTree[n];
        if (n3 == -1) {
            if (this.root == n) {
                this.setRootNode(n2);
            }
        } else {
            if (this.leftSubTree[n3] == n) {
                this.leftSubTree[n3] = n2;
            } else if (this.rightSubTree[n3] == n) {
                this.rightSubTree[n3] = n2;
            } else if (this.nextUnsorted[n3] == n) {
                this.nextUnsorted[n3] = n2;
            }
            if (n2 != -1) {
                this.parentTree[n2] = n3;
            }
        }
    }

    private void recomputeAncestorTreeSizes(int n) {
        while (n != -1) {
            int n2 = this.treeSize[n];
            this.recomputeTreeSize(n);
            if (this.treeSize[n] == n2) break;
            n = this.parentTree[n];
        }
    }

    private void recomputeTreeSize(int n) {
        if (n == -1) {
            return;
        }
        this.treeSize[n] = this.getSubtreeSize(this.leftSubTree[n]) + this.getSubtreeSize(this.rightSubTree[n]) + this.getSubtreeSize(this.nextUnsorted[n]) + (this.contents[n] == this.lazyRemovalFlag ? 0 : 1);
    }

    private void forceRecomputeTreeSize(int n, int n2) {
        while (n != -1 && n != n2) {
            this.recomputeTreeSize(n);
            n = this.parentTree[n];
        }
    }

    private void destroyNode(int n) {
        Object object;
        if (this.objectIndices != null && (object = this.contents[n]) != this.lazyRemovalFlag) {
            this.objectIndices.remove(object);
        }
        this.contents[n] = null;
        this.leftSubTree[n] = -1;
        this.rightSubTree[n] = -1;
        if (this.firstUnusedNode == -1) {
            this.treeSize[n] = 1;
        } else {
            this.treeSize[n] = this.treeSize[this.firstUnusedNode] + 1;
            this.parentTree[this.firstUnusedNode] = n;
        }
        this.nextUnsorted[n] = this.firstUnusedNode;
        this.firstUnusedNode = n;
    }

    private final void pack() {
        if (this.firstUnusedNode == -1) {
            return;
        }
        int n = this.getSubtreeSize(this.firstUnusedNode);
        int n2 = this.lastNode - n;
        if (this.contents.length < 8 || n2 > this.contents.length / 4) {
            return;
        }
        this.objectIndices = null;
        int[] nArray = new int[this.contents.length];
        int[] nArray2 = new int[this.contents.length];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.lastNode) {
            if (this.contents[n4] != null) {
                nArray2[n4] = n3;
                nArray[n3] = n4;
                ++n3;
            } else {
                nArray2[n4] = -1;
            }
            ++n4;
        }
        n4 = n3;
        int n5 = Math.max(n4 * 2, 8);
        Object[] objectArray = new Object[n5];
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        int[] nArray5 = new int[n5];
        int[] nArray6 = new int[n5];
        int[] nArray7 = new int[n5];
        int n6 = 0;
        while (n6 < n4) {
            int n7 = nArray[n6];
            objectArray[n6] = this.contents[n7];
            nArray3[n6] = this.treeSize[n7];
            int n8 = this.leftSubTree[n7];
            nArray5[n6] = n8 == -1 ? -1 : nArray2[n8];
            int n9 = this.rightSubTree[n7];
            nArray6[n6] = n9 == -1 ? -1 : nArray2[n9];
            int n10 = this.nextUnsorted[n7];
            nArray4[n6] = n10 == -1 ? -1 : nArray2[n10];
            int n11 = this.parentTree[n7];
            nArray7[n6] = n11 == -1 ? -1 : nArray2[n11];
            ++n6;
        }
        this.contents = objectArray;
        this.nextUnsorted = nArray4;
        this.treeSize = nArray3;
        this.leftSubTree = nArray5;
        this.rightSubTree = nArray6;
        this.parentTree = nArray7;
        if (this.root != -1) {
            this.root = nArray2[this.root];
        }
        this.firstUnusedNode = -1;
        this.lastNode = n4;
    }

    public final void add(Object object) {
        Assert.isNotNull((Object)object);
        int n = this.createNode(object);
        this.setRootNode(this.addUnsorted(this.root, n));
        this.testInvariants();
    }

    public final void addAll(Collection collection) {
        Assert.isNotNull((Object)collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        this.testInvariants();
    }

    public final void addAll(Object[] objectArray) {
        Assert.isNotNull((Object)objectArray);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.add(object);
            ++n;
        }
        this.testInvariants();
    }

    public final boolean isEmpty() {
        boolean bl = this.root == -1;
        this.testInvariants();
        return bl;
    }

    public final void remove(Object object) {
        this.internalRemove(object);
        this.pack();
        this.testInvariants();
    }

    private void internalRemove(Object object) {
        int n = this.getObjectIndex(object);
        if (n != -1) {
            int n2 = this.parentTree[n];
            this.lazyRemoveNode(n);
            this.recomputeAncestorTreeSizes(n2);
        }
    }

    public final void removeAll(Object[] objectArray) {
        Assert.isNotNull((Object)objectArray);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.internalRemove(object);
            ++n;
        }
        this.pack();
    }

    final void retainFirst(int n, FastProgressReporter fastProgressReporter) throws InterruptedException {
        int n2 = this.size();
        if (n >= n2) {
            return;
        }
        this.removeRange(n, n2 - n, fastProgressReporter);
        this.testInvariants();
    }

    public final void retainFirst(int n) {
        try {
            this.retainFirst(n, new FastProgressReporter());
        }
        catch (InterruptedException interruptedException) {}
        this.testInvariants();
    }

    public final void removeRange(int n, int n2) {
        try {
            this.removeRange(n, n2, new FastProgressReporter());
        }
        catch (InterruptedException interruptedException) {}
        this.testInvariants();
    }

    final void removeRange(int n, int n2, FastProgressReporter fastProgressReporter) throws InterruptedException {
        this.removeRange(this.root, n, n2, fastProgressReporter);
        this.pack();
        this.testInvariants();
    }

    private final void removeRange(int n, int n2, int n3, FastProgressReporter fastProgressReporter) throws InterruptedException {
        if (n3 == 0) {
            return;
        }
        int n4 = this.getSubtreeSize(n);
        if (n4 <= n2) {
            return;
        }
        if (n2 == 0 && n3 >= n4) {
            this.removeSubTree(n);
            return;
        }
        try {
            n = this.partition(n, fastProgressReporter);
            int n5 = this.leftSubTree[n];
            int n6 = this.getSubtreeSize(n5);
            int n7 = Math.min(n6 - n2, n3);
            if (n7 >= 0) {
                this.removeRange(this.leftSubTree[n], n2, n7, fastProgressReporter);
                int n8 = n2 + n3 - n6 - 1;
                if (n8 >= 0) {
                    this.removeRange(this.rightSubTree[n], 0, n8, fastProgressReporter);
                    this.removeNode(n);
                    return;
                }
            } else {
                this.removeRange(this.rightSubTree[n], n2 - n6 - 1, n3, fastProgressReporter);
            }
        }
        finally {
            this.recomputeTreeSize(n);
        }
    }

    private final void removeSubTree(int n) {
        if (n == -1) {
            return;
        }
        int n2 = this.nextUnsorted[n];
        while (n2 != -1) {
            int n3 = n2;
            n2 = this.nextUnsorted[n2];
            this.destroyNode(n3);
        }
        this.removeSubTree(this.leftSubTree[n]);
        this.removeSubTree(this.rightSubTree[n]);
        this.replaceNode(n, -1);
        this.destroyNode(n);
    }

    private final int lazyRemoveNode(int n) {
        int n2 = this.leftSubTree[n];
        int n3 = this.rightSubTree[n];
        if (n2 == -1 && n3 == -1) {
            int n4 = this.nextUnsorted[n];
            this.replaceNode(n, n4);
            this.destroyNode(n);
            return n4;
        }
        Object object = this.contents[n];
        this.contents[n] = this.lazyRemovalFlag;
        int n5 = n;
        this.treeSize[n5] = this.treeSize[n5] - 1;
        if (this.objectIndices != null) {
            this.objectIndices.remove(object);
        }
        return n;
    }

    private final int removeNode(int n) {
        int n2;
        Object object;
        int n3;
        int n4 = this.leftSubTree[n];
        int n5 = this.rightSubTree[n];
        if (n4 == -1 || n5 == -1) {
            int n6 = -1;
            if (n4 == -1 && n5 == -1) {
                n6 = this.nextUnsorted[n];
            } else {
                n6 = n4 == -1 ? n5 : n4;
                try {
                    n6 = this.partition(n6, new FastProgressReporter());
                }
                catch (InterruptedException interruptedException) {}
                if (n6 == -1) {
                    n6 = this.nextUnsorted[n];
                } else {
                    int n7;
                    this.nextUnsorted[n6] = n7 = this.nextUnsorted[n];
                    int n8 = 0;
                    if (n7 != -1) {
                        this.parentTree[n7] = n6;
                        n8 = this.treeSize[n7];
                    }
                    int n9 = n6;
                    this.treeSize[n9] = this.treeSize[n9] + n8;
                }
            }
            this.replaceNode(n, n6);
            this.destroyNode(n);
            return n6;
        }
        Edge edge = new Edge(n, 0);
        while (!edge.isNull()) {
            edge.advance(1);
        }
        Edge edge2 = new Edge(n, 1);
        while (!edge2.isNull()) {
            edge2.advance(0);
        }
        int n10 = -1;
        int n11 = this.getSubtreeSize(n4);
        if (n11 > (n3 = this.getSubtreeSize(n5))) {
            n10 = edge.getStart();
            object = new Edge(n10, 2);
            while (!((Edge)object).isNull()) {
                n2 = ((Edge)object).getTarget();
                if (!this.isLess(n2, n10)) {
                    ((Edge)object).setTarget(this.nextUnsorted[n2]);
                    edge2.setTarget(this.addUnsorted(edge2.getTarget(), n2));
                    continue;
                }
                ((Edge)object).advance(2);
            }
            this.forceRecomputeTreeSize(((Edge)object).getStart(), n10);
            this.forceRecomputeTreeSize(edge2.getStart(), n);
        } else {
            n10 = edge2.getStart();
            object = new Edge(n10, 2);
            while (!((Edge)object).isNull()) {
                n2 = ((Edge)object).getTarget();
                if (this.isLess(n2, n10)) {
                    ((Edge)object).setTarget(this.nextUnsorted[n2]);
                    edge.setTarget(this.addUnsorted(edge.getTarget(), n2));
                    continue;
                }
                ((Edge)object).advance(2);
            }
            this.forceRecomputeTreeSize(((Edge)object).getStart(), n10);
            this.forceRecomputeTreeSize(edge.getStart(), n);
        }
        object = this.contents[n10];
        this.contents[n10] = this.contents[n];
        this.contents[n] = object;
        if (this.objectIndices != null) {
            this.objectIndices.put(object, n);
        }
        n2 = this.parentTree[n10];
        this.replaceNode(n10, this.removeNode(n10));
        this.forceRecomputeTreeSize(n2, n);
        this.recomputeTreeSize(n);
        return n;
    }

    public final void clear() {
        this.lastNode = 0;
        this.setArraySize(8);
        this.root = -1;
        this.firstUnusedNode = -1;
        this.objectIndices = null;
        this.testInvariants();
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    final int getFirst(Object[] objectArray, boolean bl, FastProgressReporter fastProgressReporter) throws InterruptedException {
        int n = this.getRange(objectArray, 0, bl, fastProgressReporter);
        this.testInvariants();
        return n;
    }

    public final int getFirst(Object[] objectArray, boolean bl) {
        int n = 0;
        try {
            n = this.getFirst(objectArray, bl, new FastProgressReporter());
        }
        catch (InterruptedException interruptedException) {}
        this.testInvariants();
        return n;
    }

    final int getRange(Object[] objectArray, int n, boolean bl, FastProgressReporter fastProgressReporter) throws InterruptedException {
        return this.getRange(objectArray, 0, n, this.root, bl, fastProgressReporter);
    }

    public final int getRange(Object[] objectArray, int n, boolean bl) {
        int n2 = 0;
        try {
            n2 = this.getRange(objectArray, n, bl, new FastProgressReporter());
        }
        catch (InterruptedException interruptedException) {}
        this.testInvariants();
        return n2;
    }

    public final Object getItem(int n) {
        Object[] objectArray = new Object[1];
        try {
            this.getRange(objectArray, n, false, new FastProgressReporter());
        }
        catch (InterruptedException interruptedException) {}
        Object object = objectArray[0];
        this.testInvariants();
        return object;
    }

    public final Object[] getItems(boolean bl) {
        Object[] objectArray = new Object[this.size()];
        this.getRange(objectArray, 0, bl);
        return objectArray;
    }

    private final int getRange(Object[] objectArray, int n, int n2, int n3, boolean bl, FastProgressReporter fastProgressReporter) throws InterruptedException {
        if (n3 == -1) {
            return 0;
        }
        int n4 = objectArray.length - n;
        if (n2 == 0 && this.treeSize[n3] <= n4) {
            return this.getChildren(objectArray, n, n3, bl, fastProgressReporter);
        }
        if ((n3 = this.partition(n3, fastProgressReporter)) == -1) {
            return 0;
        }
        int n5 = 0;
        int n6 = this.getSubtreeSize(this.leftSubTree[n3]);
        if (n2 < n6 && n5 < n4) {
            n5 += this.getRange(objectArray, n, n2, this.leftSubTree[n3], bl, fastProgressReporter);
        }
        if (n2 <= n6 && n5 < n4) {
            objectArray[n + n5] = this.contents[n3];
            ++n5;
        }
        if (n5 < n4) {
            n5 += this.getRange(objectArray, n + n5, Math.max(n2 - n6 - 1, 0), this.rightSubTree[n3], bl, fastProgressReporter);
        }
        return n5;
    }

    private final int getChildren(Object[] objectArray, int n, int n2, boolean bl, FastProgressReporter fastProgressReporter) throws InterruptedException {
        Object object;
        if (n2 == -1) {
            return 0;
        }
        int n3 = n;
        if (bl && (n2 = this.partition(n2, fastProgressReporter)) == -1) {
            return 0;
        }
        if (n3 < objectArray.length) {
            n3 += this.getChildren(objectArray, n3, this.leftSubTree[n2], bl, fastProgressReporter);
        }
        if (n3 < objectArray.length && (object = this.contents[n2]) != this.lazyRemovalFlag) {
            objectArray[n3++] = object;
        }
        if (n3 < objectArray.length) {
            n3 += this.getChildren(objectArray, n3, this.rightSubTree[n2], bl, fastProgressReporter);
        }
        int n4 = this.nextUnsorted[n2];
        while (n4 != -1 && n3 < objectArray.length) {
            objectArray[n3++] = this.contents[n4];
            n4 = this.nextUnsorted[n4];
        }
        return n3 - n;
    }

    public boolean contains(Object object) {
        Assert.isNotNull((Object)object);
        boolean bl = this.getObjectIndex(object) != -1;
        this.testInvariants();
        return bl;
    }

    private final class Edge {
        private int startNode;
        private int direction;

        private Edge() {
            this.startNode = -1;
            this.direction = -1;
        }

        private Edge(int n, int n2) {
            this.startNode = n;
            this.direction = n2;
        }

        private int getStart() {
            return this.startNode;
        }

        private int getTarget() {
            if (this.startNode == -1) {
                if (this.direction == 2) {
                    return LazySortedCollection.this.firstUnusedNode;
                }
                if (this.direction == 3) {
                    return LazySortedCollection.this.root;
                }
                return -1;
            }
            if (this.direction == 0) {
                return LazySortedCollection.this.leftSubTree[this.startNode];
            }
            if (this.direction == 1) {
                return LazySortedCollection.this.rightSubTree[this.startNode];
            }
            return LazySortedCollection.this.nextUnsorted[this.startNode];
        }

        private boolean isNull() {
            return this.getTarget() == -1;
        }

        private void setTarget(int n) {
            if (this.direction == 0) {
                ((LazySortedCollection)LazySortedCollection.this).leftSubTree[this.startNode] = n;
            } else if (this.direction == 1) {
                ((LazySortedCollection)LazySortedCollection.this).rightSubTree[this.startNode] = n;
            } else if (this.direction == 2) {
                ((LazySortedCollection)LazySortedCollection.this).nextUnsorted[this.startNode] = n;
            } else if (this.direction == 3) {
                LazySortedCollection.this.root = n;
            } else if (this.direction == 4) {
                LazySortedCollection.this.firstUnusedNode = n;
            }
            if (n != -1) {
                ((LazySortedCollection)LazySortedCollection.this).parentTree[n] = this.startNode;
            }
        }

        private void advance(int n) {
            this.startNode = this.getTarget();
            this.direction = n;
        }
    }
}

