/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers.deferred;

import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.deferred.AbstractVirtualTable;
import org.eclipse.jface.viewers.deferred.BackgroundContentProvider;
import org.eclipse.jface.viewers.deferred.IConcurrentModel;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class DeferredContentProvider
implements ILazyContentProvider {
    private int limit = -1;
    private BackgroundContentProvider provider;
    private Comparator sortOrder;
    private IFilter filter = AcceptAllFilter.getInstance();
    private AbstractVirtualTable table;

    public DeferredContentProvider(Comparator comparator) {
        this.sortOrder = comparator;
    }

    @Override
    public void dispose() {
        this.setProvider(null);
    }

    @Override
    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object2 == null) {
            this.setProvider(null);
            return;
        }
        Assert.isTrue((boolean)(object2 instanceof IConcurrentModel));
        Assert.isTrue((boolean)(viewer instanceof TableViewer));
        IConcurrentModel iConcurrentModel = (IConcurrentModel)object2;
        this.table = new TableViewerAdapter((TableViewer)viewer);
        BackgroundContentProvider backgroundContentProvider = new BackgroundContentProvider(this.table, iConcurrentModel, this.sortOrder);
        this.setProvider(backgroundContentProvider);
        backgroundContentProvider.setLimit(this.limit);
        backgroundContentProvider.setFilter(this.filter);
    }

    public void setSortOrder(Comparator comparator) {
        Assert.isNotNull((Object)comparator);
        this.sortOrder = comparator;
        if (this.provider != null) {
            this.provider.setSortOrder(comparator);
        }
    }

    public void setFilter(IFilter iFilter) {
        this.filter = iFilter;
        if (this.provider != null) {
            this.provider.setFilter(iFilter);
        }
    }

    public void setLimit(int n) {
        this.limit = n;
        if (this.provider != null) {
            this.provider.setLimit(n);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public void updateElement(int n) {
        if (this.provider != null) {
            this.provider.checkVisibleRange(n);
        }
    }

    private void setProvider(BackgroundContentProvider backgroundContentProvider) {
        if (this.provider != null) {
            this.provider.dispose();
        }
        this.provider = backgroundContentProvider;
    }

    private static final class TableViewerAdapter
    extends AbstractVirtualTable {
        private TableViewer viewer;

        public TableViewerAdapter(TableViewer tableViewer) {
            this.viewer = tableViewer;
        }

        @Override
        public void clear(int n) {
            this.viewer.clear(n);
        }

        @Override
        public void replace(Object object, int n) {
            this.viewer.replace(object, n);
        }

        @Override
        public void setItemCount(int n) {
            this.viewer.setItemCount(n);
        }

        @Override
        public int getItemCount() {
            return this.viewer.getTable().getItemCount();
        }

        @Override
        public int getTopIndex() {
            return Math.max(this.viewer.getTable().getTopIndex() - 1, 0);
        }

        @Override
        public int getVisibleItemCount() {
            Table table = this.viewer.getTable();
            Rectangle rectangle = table.getClientArea();
            int n = table.getItemHeight();
            int n2 = table.getHeaderHeight();
            return (rectangle.height - n2 + n - 1) / (n + table.getGridLineWidth());
        }

        @Override
        public Control getControl() {
            return this.viewer.getControl();
        }
    }
}

