/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers.deferred;

import org.eclipse.jface.viewers.deferred.AbstractVirtualTable;
import org.eclipse.jface.viewers.deferred.IntHashMap;

final class ConcurrentTableUpdator {
    private AbstractVirtualTable table;
    private Object[] sentObjects = new Object[0];
    private IntHashMap knownIndices = new IntHashMap();
    private Object[] knownObjects = new Object[0];
    private static final int MIN_FLUSHLENGTH = 64;
    private int[] pendingClears = new int[64];
    private int lastClear = 0;
    private volatile Range lastRange = new Range(0, 0);
    private volatile boolean updateScheduled;
    private volatile boolean disposed = false;
    Runnable uiRunnable = new Runnable(){

        @Override
        public void run() {
            ConcurrentTableUpdator.this.updateScheduled = false;
            if (!ConcurrentTableUpdator.this.table.getControl().isDisposed()) {
                ConcurrentTableUpdator.this.updateTable();
            }
        }
    };

    public ConcurrentTableUpdator(AbstractVirtualTable abstractVirtualTable) {
        this.table = abstractVirtualTable;
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Range getVisibleRange() {
        return this.lastRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Object object) {
        ConcurrentTableUpdator concurrentTableUpdator = this;
        synchronized (concurrentTableUpdator) {
            int n = this.knownIndices.get(object, -1);
            if (n == -1) {
                return;
            }
            this.pushClear(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalItems(int n) {
        ConcurrentTableUpdator concurrentTableUpdator = this;
        synchronized (concurrentTableUpdator) {
            if (n != this.knownObjects.length) {
                Object object;
                int n2;
                if (n < this.knownObjects.length) {
                    n2 = n;
                    while (n2 < this.knownObjects.length) {
                        object = this.knownObjects[n2];
                        if (object != null) {
                            this.knownIndices.remove(object);
                        }
                        ++n2;
                    }
                }
                n2 = Math.min(this.knownObjects.length, n);
                object = new Object[n];
                System.arraycopy(this.knownObjects, 0, object, 0, n2);
                this.knownObjects = object;
                this.scheduleUIUpdate();
            }
        }
    }

    private void pushClear(int n) {
        if (n >= this.sentObjects.length) {
            return;
        }
        if (this.sentObjects[n] == null) {
            return;
        }
        this.sentObjects[n] = null;
        if (this.lastClear >= this.pendingClears.length) {
            int n2 = Math.min(64, this.lastClear * 2);
            int[] nArray = new int[n2];
            System.arraycopy(this.pendingClears, 0, nArray, 0, this.lastClear);
            this.pendingClears = nArray;
        }
        this.pendingClears[this.lastClear++] = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Object object, int n) {
        ConcurrentTableUpdator concurrentTableUpdator = this;
        synchronized (concurrentTableUpdator) {
            Object object2 = this.knownObjects[n];
            if (object2 != object) {
                if (object2 != null) {
                    this.knownIndices.remove(object2);
                }
                this.knownObjects[n] = object;
                if (object != null) {
                    int n2 = this.knownIndices.get(object, -1);
                    if (n2 != -1) {
                        this.knownObjects[n2] = null;
                        this.pushClear(n2);
                    }
                    this.knownIndices.put(object, n);
                }
                this.pushClear(n);
                this.scheduleUIUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUIUpdate() {
        ConcurrentTableUpdator concurrentTableUpdator = this;
        synchronized (concurrentTableUpdator) {
            if (!this.updateScheduled) {
                this.updateScheduled = true;
                if (!this.table.getControl().isDisposed()) {
                    this.table.getControl().getDisplay().asyncExec(this.uiRunnable);
                }
            }
        }
    }

    public void checkVisibleRange(int n) {
        int n2 = Math.min(this.table.getTopIndex() - 1, n);
        int n3 = Math.max(this.table.getVisibleItemCount(), n - n2);
        Range range = this.lastRange;
        if (n2 != range.start || n3 != range.length) {
            this.updateTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable() {
        ConcurrentTableUpdator concurrentTableUpdator = this;
        synchronized (concurrentTableUpdator) {
            int n;
            if (this.sentObjects.length != this.knownObjects.length) {
                Object[] objectArray = new Object[this.knownObjects.length];
                System.arraycopy(objectArray, 0, this.sentObjects, 0, Math.min(objectArray.length, this.sentObjects.length));
                this.sentObjects = objectArray;
                this.table.setItemCount(objectArray.length);
            }
            int n2 = Math.min(this.table.getTopIndex(), this.knownObjects.length);
            int n3 = Math.min(this.table.getVisibleItemCount(), this.knownObjects.length - n2);
            int n4 = this.table.getItemCount();
            int n5 = this.lastRange.start;
            int n6 = this.lastRange.length;
            this.lastRange = new Range(n2, n3);
            int n7 = 0;
            while (n7 < n6) {
                n = n7 + n5;
                if (n < n4 && (n < n2 || n >= n2 + n3) && this.sentObjects[n] == null) {
                    this.table.clear(n);
                }
                ++n7;
            }
            if (this.lastClear > 0) {
                n7 = 0;
                while (n7 < this.lastClear) {
                    n = this.pendingClears[n7];
                    if (n < this.sentObjects.length) {
                        this.table.clear(n);
                    }
                    ++n7;
                }
                if (this.pendingClears.length > 64) {
                    this.pendingClears = new int[64];
                }
                this.lastClear = 0;
            }
            n7 = 0;
            while (n7 < n3) {
                n = n7 + n2;
                Object object = this.knownObjects[n];
                if (object != null && object != this.sentObjects[n7]) {
                    this.table.replace(object, n);
                    this.sentObjects[n7] = object;
                }
                ++n7;
            }
        }
    }

    public Object[] getKnownObjects() {
        return this.knownObjects;
    }

    public static final class Range {
        int start = 0;
        int length = 0;

        public Range(int n, int n2) {
            this.start = n;
            this.length = n2;
        }
    }
}

