/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers.deferred;

import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.deferred.AbstractVirtualTable;
import org.eclipse.jface.viewers.deferred.ChangeQueue;
import org.eclipse.jface.viewers.deferred.ConcurrentTableUpdator;
import org.eclipse.jface.viewers.deferred.FastProgressReporter;
import org.eclipse.jface.viewers.deferred.IConcurrentModel;
import org.eclipse.jface.viewers.deferred.IConcurrentModelListener;
import org.eclipse.jface.viewers.deferred.LazySortedCollection;

final class BackgroundContentProvider {
    private static final String SORTING = JFaceResources.getString("Sorting");
    private int limit = -1;
    private IConcurrentModel model;
    private volatile Comparator sortOrder;
    private volatile IFilter filter = AcceptAllFilter.getInstance();
    private ChangeQueue changeQueue = new ChangeQueue();
    private IConcurrentModelListener listener = new IConcurrentModelListener(){

        @Override
        public void add(Object[] objectArray) {
            BackgroundContentProvider.this.add(objectArray);
        }

        @Override
        public void remove(Object[] objectArray) {
            BackgroundContentProvider.this.remove(objectArray);
        }

        @Override
        public void setContents(Object[] objectArray) {
            BackgroundContentProvider.this.setContents(objectArray);
        }

        @Override
        public void update(Object[] objectArray) {
            BackgroundContentProvider.this.update(objectArray);
        }
    };
    private ConcurrentTableUpdator updator;
    private IProgressMonitor sortingProgressMonitor = new NullProgressMonitor();
    private Thread sortThread = null;
    private volatile FastProgressReporter sortMon = new FastProgressReporter();
    private volatile ConcurrentTableUpdator.Range range = new ConcurrentTableUpdator.Range(0, 0);
    private Object lock = new Object();
    private boolean sortThreadStarted = false;
    private boolean sortScheduled = false;

    public BackgroundContentProvider(AbstractVirtualTable abstractVirtualTable, IConcurrentModel iConcurrentModel, Comparator comparator) {
        this.updator = new ConcurrentTableUpdator(abstractVirtualTable);
        this.model = iConcurrentModel;
        this.sortOrder = comparator;
        iConcurrentModel.addListener(this.listener);
    }

    public void dispose() {
        this.cancelSortJob();
        this.updator.dispose();
        this.model.removeListener(this.listener);
    }

    public void refresh() {
        if (this.updator.isDisposed()) {
            return;
        }
        this.model.requestUpdate(this.listener);
    }

    private void doSort(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.setCanceled(false);
        iProgressMonitor.beginTask(SORTING, 100);
        Comparator comparator = this.sortOrder;
        IFilter iFilter = this.filter;
        Object object = new LazySortedCollection(comparator);
        Object[] objectArray = this.updator.getKnownObjects();
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (object2 != null) {
                ((LazySortedCollection)object).add(object2);
            }
            ++n;
        }
        n = 0;
        int n2 = objectArray.length;
        this.updator.setTotalItems(n2);
        block9: while (true) {
            Object[] objectArray2;
            Object object3;
            if (comparator != this.sortOrder) {
                n = 1;
                comparator = this.sortOrder;
                object3 = new LazySortedCollection(comparator);
                objectArray2 = ((LazySortedCollection)object).getItems(false);
                int n3 = 0;
                while (n3 < objectArray2.length && comparator == this.sortOrder) {
                    Object object4 = objectArray2[n3];
                    ((LazySortedCollection)object3).add(object4);
                    ++n3;
                }
                if (comparator != this.sortOrder) continue;
                object = object3;
                continue;
            }
            if (iFilter != this.filter) {
                n = 1;
                iFilter = this.filter;
                object3 = ((LazySortedCollection)object).getItems(false);
                int n4 = 0;
                while (true) {
                    if (n4 >= ((Object)object3).length || iFilter != this.filter) continue block9;
                    Object object5 = object3[n4];
                    if (!iFilter.select(object5)) {
                        ((LazySortedCollection)object).remove(object5);
                    }
                    ++n4;
                }
            }
            if (!this.changeQueue.isEmpty()) {
                n = 1;
                object3 = this.changeQueue.dequeue();
                switch (((ChangeQueue.Change)object3).getType()) {
                    case 0: {
                        BackgroundContentProvider.filteredAdd((LazySortedCollection)object, ((ChangeQueue.Change)object3).getElements(), iFilter);
                        break;
                    }
                    case 1: {
                        objectArray2 = ((ChangeQueue.Change)object3).getElements();
                        this.flush(objectArray2, (LazySortedCollection)object);
                        ((LazySortedCollection)object).removeAll(objectArray2);
                        break;
                    }
                    case 3: {
                        objectArray2 = ((ChangeQueue.Change)object3).getElements();
                        int n5 = 0;
                        while (n5 < objectArray2.length) {
                            Object object6 = objectArray2[n5];
                            if (((LazySortedCollection)object).contains(object6)) {
                                ((LazySortedCollection)object).remove(object6);
                                ((LazySortedCollection)object).add(object6);
                                this.updator.clear(object6);
                            }
                            ++n5;
                        }
                        break;
                    }
                    case 2: {
                        objectArray2 = ((ChangeQueue.Change)object3).getElements();
                        ((LazySortedCollection)object).clear();
                        BackgroundContentProvider.filteredAdd((LazySortedCollection)object, objectArray2, iFilter);
                    }
                }
                continue;
            }
            int n6 = ((LazySortedCollection)object).size();
            if (this.limit != -1 && n6 > this.limit) {
                n6 = this.limit;
            }
            if (n6 != n2) {
                n2 = n6;
                this.updator.setTotalItems(n6);
                n = 1;
            }
            if (n == 0) break;
            try {
                Object object7;
                objectArray2 = this.updator.getVisibleRange();
                this.sortMon = new FastProgressReporter();
                this.range = objectArray2;
                int n7 = objectArray2.start;
                int n8 = objectArray2.length;
                if (this.limit != -1) {
                    ((LazySortedCollection)object).retainFirst(this.limit, this.sortMon);
                }
                n8 = Math.min(n8, n6 - n7);
                n8 = Math.max(n8, 0);
                Object[] objectArray3 = new Object[n8];
                ((LazySortedCollection)object).getRange(objectArray3, n7, true, this.sortMon);
                int n9 = 0;
                while (n9 < n8) {
                    object7 = objectArray3[n9];
                    this.updator.replace(object7, n7 + n9);
                    ++n9;
                }
                objectArray3 = new Object[((LazySortedCollection)object).size()];
                ((LazySortedCollection)object).getFirst(objectArray3, true, this.sortMon);
                n9 = 0;
                while (n9 < n6) {
                    object7 = objectArray3[n9];
                    this.updator.replace(object7, n9);
                    ++n9;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            n = 0;
        }
        iProgressMonitor.done();
    }

    private static void filteredAdd(LazySortedCollection lazySortedCollection, Object[] objectArray, IFilter iFilter) {
        if (iFilter != AcceptAllFilter.getInstance()) {
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (iFilter.select(object)) {
                    lazySortedCollection.add(object);
                }
                ++n;
            }
        } else {
            lazySortedCollection.addAll(objectArray);
        }
    }

    public void setSortOrder(Comparator comparator) {
        Assert.isNotNull((Object)comparator);
        this.sortOrder = comparator;
        this.sortMon.cancel();
        this.refresh();
    }

    public void setFilter(IFilter iFilter) {
        Assert.isNotNull((Object)iFilter);
        this.filter = iFilter;
        this.sortMon.cancel();
        this.refresh();
    }

    public void setLimit(int n) {
        this.limit = n;
        this.refresh();
    }

    public int getLimit() {
        return this.limit;
    }

    public void checkVisibleRange(int n) {
        this.updator.checkVisibleRange(n);
        ConcurrentTableUpdator.Range range = this.updator.getVisibleRange();
        ConcurrentTableUpdator.Range range2 = this.range;
        if (range.start != range2.start || range.length != range2.length) {
            this.sortMon.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDirty() {
        Object object = this.lock;
        synchronized (object) {
            this.sortMon.cancel();
            this.sortScheduled = true;
            if (!this.sortThreadStarted) {
                this.sortThreadStarted = true;
                this.sortThread = new SortThread(SORTING);
                this.sortThread.setDaemon(true);
                this.sortThread.setPriority(4);
                this.sortThread.start();
            }
        }
    }

    private void cancelSortJob() {
        this.sortMon.cancel();
        this.sortingProgressMonitor.setCanceled(true);
    }

    private void add(Object[] objectArray) {
        this.changeQueue.enqueue(0, objectArray);
        this.makeDirty();
    }

    private void setContents(Object[] objectArray) {
        this.changeQueue.enqueue(2, objectArray);
        this.makeDirty();
    }

    private void remove(Object[] objectArray) {
        this.changeQueue.enqueue(1, objectArray);
        this.makeDirty();
        this.refresh();
    }

    private void flush(Object[] objectArray, LazySortedCollection lazySortedCollection) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (lazySortedCollection.contains(object)) {
                this.updator.clear(object);
            }
            ++n;
        }
    }

    private void update(Object[] objectArray) {
        this.changeQueue.enqueue(3, objectArray);
        this.makeDirty();
    }

    private final class SortThread
    extends Thread {
        private SortThread(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                Object object = BackgroundContentProvider.this.lock;
                synchronized (object) {
                    BackgroundContentProvider.this.sortScheduled = false;
                }
                try {
                    BackgroundContentProvider.this.doSort(BackgroundContentProvider.this.sortingProgressMonitor);
                }
                catch (Exception exception) {}
                object = BackgroundContentProvider.this.lock;
                synchronized (object) {
                    if (!BackgroundContentProvider.this.sortScheduled) {
                        BackgroundContentProvider.this.sortThreadStarted = false;
                        return;
                    }
                }
            }
        }
    }
}

