/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class ViewerRow
implements Cloneable {
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    private static final String KEY_TEXT_LAYOUT = "org.eclipse.jfacestyled_label_key_";
    private static final String KEY_TEXT_LAYOUT_0 = "org.eclipse.jfacestyled_label_key_0";
    private static String[] cachedDataKeys;

    public abstract Rectangle getBounds(int var1);

    public abstract Rectangle getBounds();

    public abstract Widget getItem();

    public abstract int getColumnCount();

    public abstract Image getImage(int var1);

    public abstract void setImage(int var1, Image var2);

    public abstract String getText(int var1);

    public abstract void setText(int var1, String var2);

    public abstract Color getBackground(int var1);

    public abstract void setBackground(int var1, Color var2);

    public abstract Color getForeground(int var1);

    public abstract void setForeground(int var1, Color var2);

    public abstract Font getFont(int var1);

    public abstract void setFont(int var1, Font var2);

    public ViewerCell getCell(Point point) {
        int n = this.getColumnIndex(point);
        return this.getCell(n);
    }

    public int getColumnIndex(Point point) {
        int n = this.getColumnCount();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.getBounds(n2).contains(point)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public ViewerCell getCell(int n) {
        if (n >= 0) {
            return new ViewerCell((ViewerRow)this.clone(), n, this.getElement());
        }
        return null;
    }

    public abstract Control getControl();

    public abstract ViewerRow getNeighbor(int var1, boolean var2);

    public abstract TreePath getTreePath();

    public abstract Object clone();

    public abstract Object getElement();

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getItem() == null ? 0 : this.getItem().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewerRow viewerRow = (ViewerRow)object;
        return !(this.getItem() == null ? viewerRow.getItem() != null : !this.getItem().equals(viewerRow.getItem()));
    }

    ViewerCell getCellAtVisualIndex(int n) {
        return this.getCell(this.getCreationIndex(n));
    }

    protected int getVisualIndex(int n) {
        return n;
    }

    protected int getCreationIndex(int n) {
        return n;
    }

    public Rectangle getTextBounds(int n) {
        return null;
    }

    public Rectangle getImageBounds(int n) {
        return null;
    }

    public void setStyleRanges(int n, StyleRange[] styleRangeArray) {
        this.getItem().setData(this.getStyleRangesDataKey(n), (Object)styleRangeArray);
    }

    private String getStyleRangesDataKey(int n) {
        if (n == 0) {
            return KEY_TEXT_LAYOUT_0;
        }
        if (cachedDataKeys == null) {
            int n2 = Math.max(10, n + 1);
            cachedDataKeys = new String[n2];
            int n3 = 1;
            while (n3 < cachedDataKeys.length) {
                ViewerRow.cachedDataKeys[n3] = KEY_TEXT_LAYOUT + n3;
                ++n3;
            }
        } else if (n >= cachedDataKeys.length) {
            String[] stringArray = new String[n + 1];
            System.arraycopy(cachedDataKeys, 0, stringArray, 0, cachedDataKeys.length);
            int n4 = cachedDataKeys.length;
            while (n4 < stringArray.length) {
                stringArray[n4] = KEY_TEXT_LAYOUT + n4;
                ++n4;
            }
            cachedDataKeys = stringArray;
        }
        return cachedDataKeys[n];
    }

    public StyleRange[] getStyleRanges(int n) {
        return (StyleRange[])this.getItem().getData(this.getStyleRangesDataKey(n));
    }

    int getWidth(int n) {
        return this.getBounds((int)n).width;
    }

    protected boolean scrollCellIntoView(int n) {
        return false;
    }

    protected boolean isColumnVisible(int n) {
        return this.getWidth(n) > 0;
    }
}

