/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ViewerDropAdapter
extends DropTargetAdapter {
    public static final int LOCATION_BEFORE = 1;
    public static final int LOCATION_AFTER = 2;
    public static final int LOCATION_ON = 3;
    public static final int LOCATION_NONE = 4;
    private Viewer viewer;
    private int currentOperation = 0;
    private int lastValidOperation;
    private int overrideOperation = -1;
    private DropTargetEvent currentEvent;
    private Object currentTarget;
    private int currentLocation;
    private boolean feedbackEnabled = true;
    private boolean scrollEnabled = true;
    private boolean expandEnabled = true;
    private boolean selectFeedbackEnabled = true;

    protected ViewerDropAdapter(Viewer viewer) {
        this.viewer = viewer;
    }

    protected void clearState() {
        this.currentTarget = null;
    }

    protected int determineLocation(DropTargetEvent dropTargetEvent) {
        if (!(dropTargetEvent.item instanceof Item)) {
            return 4;
        }
        Item item = (Item)dropTargetEvent.item;
        Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
        point = this.viewer.getControl().toControl(point);
        if (item != null) {
            Rectangle rectangle = this.getBounds(item);
            if (rectangle == null) {
                return 4;
            }
            if (point.y - rectangle.y < 5) {
                return 1;
            }
            if (rectangle.y + rectangle.height - point.y < 5) {
                return 2;
            }
        }
        return 3;
    }

    protected Object determineTarget(DropTargetEvent dropTargetEvent) {
        return dropTargetEvent.item == null ? null : dropTargetEvent.item.getData();
    }

    private void doDropValidation(DropTargetEvent dropTargetEvent) {
        if (dropTargetEvent.detail != 0 && this.overrideOperation == -1) {
            this.lastValidOperation = dropTargetEvent.detail;
        }
        this.currentOperation = this.lastValidOperation;
        this.currentEvent = dropTargetEvent;
        this.overrideOperation = -1;
        if (!this.validateDrop(this.currentTarget, this.currentOperation, dropTargetEvent.currentDataType)) {
            this.currentOperation = 0;
        }
        dropTargetEvent.detail = this.overrideOperation != -1 ? this.overrideOperation : this.currentOperation;
        this.currentEvent = null;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.currentTarget = this.determineTarget(dropTargetEvent);
        this.doDropValidation(dropTargetEvent);
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        this.currentTarget = this.determineTarget(dropTargetEvent);
        this.doDropValidation(dropTargetEvent);
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        Object object = this.determineTarget(dropTargetEvent);
        int n = this.currentLocation;
        this.currentLocation = this.determineLocation(dropTargetEvent);
        this.setFeedback(dropTargetEvent, this.currentLocation);
        if (object != this.currentTarget || this.currentLocation != n) {
            this.currentTarget = object;
            this.doDropValidation(dropTargetEvent);
        }
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        this.currentLocation = this.determineLocation(dropTargetEvent);
        this.currentEvent = dropTargetEvent;
        if (this.overrideOperation != -1) {
            this.currentOperation = this.overrideOperation;
        }
        if (!this.performDrop(dropTargetEvent.data)) {
            dropTargetEvent.detail = 0;
        }
        this.currentOperation = 0;
        this.currentEvent = null;
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        this.currentEvent = dropTargetEvent;
        if (!this.validateDrop(this.currentTarget, dropTargetEvent.detail, dropTargetEvent.currentDataType)) {
            dropTargetEvent.detail = 0;
            this.currentOperation = 0;
        }
        this.currentEvent = null;
    }

    protected Rectangle getBounds(Item item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBounds();
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(0);
        }
        return null;
    }

    protected int getCurrentLocation() {
        return this.currentLocation;
    }

    protected int getCurrentOperation() {
        return this.currentOperation;
    }

    protected Object getCurrentTarget() {
        return this.currentTarget;
    }

    protected DropTargetEvent getCurrentEvent() {
        Assert.isTrue((this.currentEvent != null ? 1 : 0) != 0);
        return this.currentEvent;
    }

    public boolean getFeedbackEnabled() {
        return this.feedbackEnabled;
    }

    protected Object getSelectedObject() {
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            return iStructuredSelection.getFirstElement();
        }
        return null;
    }

    protected Viewer getViewer() {
        return this.viewer;
    }

    protected void handleException(Throwable throwable, DropTargetEvent dropTargetEvent) {
        throwable.printStackTrace();
        dropTargetEvent.detail = 0;
    }

    public abstract boolean performDrop(Object var1);

    protected void overrideOperation(int n) {
        this.overrideOperation = n;
    }

    private void setFeedback(DropTargetEvent dropTargetEvent, int n) {
        if (this.feedbackEnabled) {
            switch (n) {
                case 1: {
                    dropTargetEvent.feedback = 2;
                    break;
                }
                case 2: {
                    dropTargetEvent.feedback = 4;
                    break;
                }
                default: {
                    dropTargetEvent.feedback = 1;
                }
            }
        }
        if (!this.selectFeedbackEnabled) {
            dropTargetEvent.feedback &= 0xFFFFFFFE;
        }
        if (this.expandEnabled) {
            dropTargetEvent.feedback |= 0x10;
        }
        if (this.scrollEnabled) {
            dropTargetEvent.feedback |= 8;
        }
    }

    public void setFeedbackEnabled(boolean bl) {
        this.feedbackEnabled = bl;
    }

    public void setSelectionFeedbackEnabled(boolean bl) {
        this.selectFeedbackEnabled = bl;
    }

    public void setScrollExpandEnabled(boolean bl) {
        this.expandEnabled = bl;
        this.scrollEnabled = bl;
    }

    public void setExpandEnabled(boolean bl) {
        this.expandEnabled = bl;
    }

    public void setScrollEnabled(boolean bl) {
        this.scrollEnabled = bl;
    }

    public abstract boolean validateDrop(Object var1, int var2, TransferData var3);
}

