/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ViewerCell {
    private int columnIndex;
    private ViewerRow row;
    private Object element;
    public static int ABOVE = 1;
    public static int BELOW = 2;
    public static int LEFT = 4;
    public static int RIGHT = 8;

    ViewerCell(ViewerRow viewerRow, int n, Object object) {
        this.row = viewerRow;
        this.columnIndex = n;
        this.element = object;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Rectangle getBounds() {
        return this.row.getBounds(this.columnIndex);
    }

    public Object getElement() {
        if (this.element != null) {
            return this.element;
        }
        if (this.row != null) {
            return this.row.getElement();
        }
        return null;
    }

    public String getText() {
        return this.row.getText(this.columnIndex);
    }

    public Image getImage() {
        return this.row.getImage(this.columnIndex);
    }

    public void setBackground(Color color) {
        this.row.setBackground(this.columnIndex, color);
    }

    public void setForeground(Color color) {
        this.row.setForeground(this.columnIndex, color);
    }

    public void setFont(Font font) {
        this.row.setFont(this.columnIndex, font);
    }

    public void setText(String string) {
        this.row.setText(this.columnIndex, string);
    }

    public void setImage(Image image) {
        this.row.setImage(this.columnIndex, image);
    }

    public void setStyleRanges(StyleRange[] styleRangeArray) {
        this.row.setStyleRanges(this.columnIndex, styleRangeArray);
    }

    public StyleRange[] getStyleRanges() {
        return this.row.getStyleRanges(this.columnIndex);
    }

    void setColumn(int n) {
        this.columnIndex = n;
    }

    void update(ViewerRow viewerRow, int n, Object object) {
        this.row = viewerRow;
        this.columnIndex = n;
        this.element = object;
    }

    public Widget getItem() {
        return this.row.getItem();
    }

    public Control getControl() {
        return this.row.getControl();
    }

    public int getVisualIndex() {
        return this.row.getVisualIndex(this.getColumnIndex());
    }

    public ViewerCell getNeighbor(int n, boolean bl) {
        ViewerRow viewerRow = (n & ABOVE) == ABOVE ? this.row.getNeighbor(1, bl) : ((n & BELOW) == BELOW ? this.row.getNeighbor(2, bl) : this.row);
        if (viewerRow != null) {
            int n2 = this.getVisualIndex();
            int n3 = 0;
            if ((n & LEFT) == LEFT) {
                n3 = -1;
            } else if ((n & RIGHT) == RIGHT) {
                n3 = 1;
            }
            if ((n2 += n3) >= 0 && n2 < viewerRow.getColumnCount()) {
                ViewerCell viewerCell = viewerRow.getCellAtVisualIndex(n2);
                if (viewerCell != null) {
                    while (viewerCell != null && n2 < viewerRow.getColumnCount() - 1 && n2 > 0) {
                        if (viewerCell.isVisible() || (viewerCell = viewerRow.getCellAtVisualIndex(n2 += n3)) == null) break;
                    }
                }
                return viewerCell;
            }
        }
        return null;
    }

    public ViewerRow getViewerRow() {
        return this.row;
    }

    public Rectangle getTextBounds() {
        return this.row.getTextBounds(this.columnIndex);
    }

    public Rectangle getImageBounds() {
        return this.row.getImageBounds(this.columnIndex);
    }

    public Color getForeground() {
        return this.row.getForeground(this.columnIndex);
    }

    public Color getBackground() {
        return this.row.getBackground(this.columnIndex);
    }

    public Font getFont() {
        return this.row.getFont(this.columnIndex);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.columnIndex;
        n = 31 * n + (this.row == null ? 0 : this.row.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewerCell viewerCell = (ViewerCell)object;
        if (this.columnIndex != viewerCell.columnIndex) {
            return false;
        }
        return !(this.row == null ? viewerCell.row != null : !this.row.equals(viewerCell.row));
    }

    private boolean isVisible() {
        return this.row.isColumnVisible(this.columnIndex);
    }

    public boolean scrollIntoView() {
        return this.row.scrollCellIntoView(this.columnIndex);
    }
}

