/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewerRow
extends ViewerRow {
    private TreeItem item;

    TreeViewerRow(TreeItem treeItem) {
        this.item = treeItem;
    }

    @Override
    public Rectangle getBounds(int n) {
        return this.item.getBounds(n);
    }

    @Override
    public Rectangle getBounds() {
        return this.item.getBounds();
    }

    @Override
    public int getColumnCount() {
        return this.item.getParent().getColumnCount();
    }

    @Override
    public Widget getItem() {
        return this.item;
    }

    @Override
    public Color getBackground(int n) {
        return this.item.getBackground(n);
    }

    @Override
    public Font getFont(int n) {
        return this.item.getFont(n);
    }

    @Override
    public Color getForeground(int n) {
        return this.item.getForeground(n);
    }

    @Override
    public Image getImage(int n) {
        return this.item.getImage(n);
    }

    @Override
    public String getText(int n) {
        return this.item.getText(n);
    }

    @Override
    public void setBackground(int n, Color color) {
        this.item.setBackground(n, color);
    }

    @Override
    public void setFont(int n, Font font) {
        this.item.setFont(n, font);
    }

    @Override
    public void setForeground(int n, Color color) {
        this.item.setForeground(n, color);
    }

    @Override
    public void setImage(int n, Image image) {
        Image image2 = this.item.getImage(n);
        if (image != image2) {
            this.item.setImage(n, image);
        }
    }

    @Override
    public void setText(int n, String string) {
        this.item.setText(n, string == null ? "" : string);
    }

    @Override
    public Control getControl() {
        return this.item.getParent();
    }

    @Override
    public ViewerRow getNeighbor(int n, boolean bl) {
        if (n == 1) {
            return this.getRowAbove(bl);
        }
        if (n == 2) {
            return this.getRowBelow(bl);
        }
        throw new IllegalArgumentException("Illegal value of direction argument.");
    }

    private ViewerRow getRowBelow(boolean bl) {
        Tree tree = this.item.getParent();
        if (this.item.getParentItem() == null) {
            if (bl || !this.item.getExpanded()) {
                int n = tree.indexOf(this.item) + 1;
                if (n < tree.getItemCount()) {
                    return new TreeViewerRow(tree.getItem(n));
                }
            } else if (this.item.getExpanded() && this.item.getItemCount() > 0) {
                return new TreeViewerRow(this.item.getItem(0));
            }
        } else if (bl || !this.item.getExpanded()) {
            int n;
            TreeItem treeItem = this.item.getParentItem();
            int n2 = treeItem.indexOf(this.item) + 1;
            TreeItem treeItem2 = n2 == (n = treeItem.getItemCount()) ? this.findNextItem(treeItem) : treeItem.getItem(n2);
            if (treeItem2 != null) {
                return new TreeViewerRow(treeItem2);
            }
        } else if (this.item.getExpanded() && this.item.getItemCount() > 0) {
            return new TreeViewerRow(this.item.getItem(0));
        }
        return null;
    }

    private ViewerRow getRowAbove(boolean bl) {
        Tree tree = this.item.getParent();
        if (this.item.getParentItem() == null) {
            int n = tree.indexOf(this.item) - 1;
            TreeItem treeItem = null;
            if (n >= 0) {
                treeItem = tree.getItem(n);
            }
            if (treeItem != null) {
                if (bl) {
                    return new TreeViewerRow(treeItem);
                }
                return new TreeViewerRow(this.findLastVisibleItem(treeItem));
            }
        } else {
            TreeItem treeItem = this.item.getParentItem();
            int n = treeItem.indexOf(this.item) - 1;
            TreeItem treeItem2 = n >= 0 ? (bl ? treeItem.getItem(n) : this.findLastVisibleItem(treeItem.getItem(n))) : treeItem;
            if (treeItem2 != null) {
                return new TreeViewerRow(treeItem2);
            }
        }
        return null;
    }

    private TreeItem findLastVisibleItem(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem;
        while (treeItem2.getExpanded() && treeItem2.getItemCount() > 0) {
            treeItem2 = treeItem2.getItem(treeItem2.getItemCount() - 1);
        }
        return treeItem2;
    }

    private TreeItem findNextItem(TreeItem treeItem) {
        int n;
        int n2;
        TreeItem treeItem2 = null;
        Tree tree = treeItem.getParent();
        TreeItem treeItem3 = treeItem.getParentItem();
        if (treeItem3 == null) {
            n2 = tree.indexOf(treeItem) + 1;
            n = tree.getItemCount();
        } else {
            n2 = treeItem3.indexOf(treeItem) + 1;
            n = treeItem3.getItemCount();
        }
        if (n2 == n) {
            if (treeItem.getParentItem() != null) {
                treeItem2 = this.findNextItem(treeItem.getParentItem());
            }
        } else {
            treeItem2 = treeItem3 == null ? tree.getItem(n2) : treeItem3.getItem(n2);
        }
        return treeItem2;
    }

    @Override
    public TreePath getTreePath() {
        TreeItem treeItem = this.item;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (treeItem != null) {
            Object object = treeItem.getData();
            Assert.isNotNull((Object)object);
            linkedList.addFirst(object);
            treeItem = treeItem.getParentItem();
        }
        return new TreePath(linkedList.toArray());
    }

    void setItem(TreeItem treeItem) {
        this.item = treeItem;
    }

    @Override
    public Object clone() {
        return new TreeViewerRow(this.item);
    }

    @Override
    public Object getElement() {
        return this.item.getData();
    }

    @Override
    public int getVisualIndex(int n) {
        int[] nArray = this.item.getParent().getColumnOrder();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return super.getVisualIndex(n);
    }

    @Override
    public int getCreationIndex(int n) {
        if (this.item != null && !this.item.isDisposed() && this.hasColumns() && this.isValidOrderIndex(n)) {
            return this.item.getParent().getColumnOrder()[n];
        }
        return super.getCreationIndex(n);
    }

    @Override
    public Rectangle getTextBounds(int n) {
        return this.item.getTextBounds(n);
    }

    @Override
    public Rectangle getImageBounds(int n) {
        return this.item.getImageBounds(n);
    }

    private boolean hasColumns() {
        return this.item.getParent().getColumnCount() != 0;
    }

    private boolean isValidOrderIndex(int n) {
        return n < this.item.getParent().getColumnOrder().length;
    }

    @Override
    int getWidth(int n) {
        return this.item.getParent().getColumn(n).getWidth();
    }

    @Override
    protected boolean scrollCellIntoView(int n) {
        this.item.getParent().showItem(this.item);
        if (this.hasColumns()) {
            this.item.getParent().showColumn(this.item.getParent().getColumn(n));
        }
        return true;
    }
}

