/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewerFocusCellManager
extends SWTFocusCellManager {
    private static final CellNavigationStrategy TREE_NAVIGATE = new CellNavigationStrategy(){

        @Override
        public void collapse(ColumnViewer columnViewer, ViewerCell viewerCell, Event event) {
            if (viewerCell != null) {
                ((TreeItem)viewerCell.getItem()).setExpanded(false);
            }
        }

        @Override
        public void expand(ColumnViewer columnViewer, ViewerCell viewerCell, Event event) {
            if (viewerCell != null) {
                TreeViewer treeViewer = (TreeViewer)columnViewer;
                treeViewer.setExpandedState(treeViewer.getTreePathFromItem((Item)viewerCell.getItem()), true);
            }
        }

        @Override
        public boolean isCollapseEvent(ColumnViewer columnViewer, ViewerCell viewerCell, Event event) {
            if (viewerCell == null) {
                return false;
            }
            return viewerCell != null && ((TreeItem)viewerCell.getItem()).getExpanded() && event.keyCode == 0x1000003 && this.isFirstColumnCell(viewerCell);
        }

        @Override
        public boolean isExpandEvent(ColumnViewer columnViewer, ViewerCell viewerCell, Event event) {
            if (viewerCell == null) {
                return false;
            }
            return viewerCell != null && ((TreeItem)viewerCell.getItem()).getItemCount() > 0 && !((TreeItem)viewerCell.getItem()).getExpanded() && event.keyCode == 0x1000004 && this.isFirstColumnCell(viewerCell);
        }

        private boolean isFirstColumnCell(ViewerCell viewerCell) {
            return viewerCell.getViewerRow().getVisualIndex(viewerCell.getColumnIndex()) == 0;
        }
    };

    public TreeViewerFocusCellManager(TreeViewer treeViewer, FocusCellHighlighter focusCellHighlighter) {
        this(treeViewer, focusCellHighlighter, TREE_NAVIGATE);
    }

    public TreeViewerFocusCellManager(TreeViewer treeViewer, FocusCellHighlighter focusCellHighlighter, CellNavigationStrategy cellNavigationStrategy) {
        super(treeViewer, focusCellHighlighter, cellNavigationStrategy);
    }

    @Override
    ViewerCell getInitialFocusCell() {
        Tree tree = (Tree)this.getViewer().getControl();
        if (!tree.isDisposed() && tree.getItemCount() > 0 && !tree.getTopItem().isDisposed()) {
            ViewerRow viewerRow = this.getViewer().getViewerRowFromItem((Widget)tree.getTopItem());
            if (tree.getColumnCount() == 0) {
                return viewerRow.getCell(0);
            }
            Rectangle rectangle = tree.getClientArea();
            int n = 0;
            while (n < tree.getColumnCount()) {
                if (viewerRow.getWidth(n) > 0 && this.columnInVisibleArea(rectangle, viewerRow, n)) {
                    return viewerRow.getCell(n);
                }
                ++n;
            }
        }
        return null;
    }

    private boolean columnInVisibleArea(Rectangle rectangle, ViewerRow viewerRow, int n) {
        return viewerRow.getBounds((int)n).x >= rectangle.x;
    }

    @Override
    public ViewerCell getFocusCell() {
        ViewerCell viewerCell = super.getFocusCell();
        Tree tree = (Tree)this.getViewer().getControl();
        if (viewerCell != null && tree.getSelection().length == 1 && tree.getSelection()[0] != viewerCell.getItem()) {
            this.setFocusCell(this.getViewer().getViewerRowFromItem((Widget)tree.getSelection()[0]).getCell(viewerCell.getColumnIndex()));
        }
        return super.getFocusCell();
    }
}

