/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerEditor
extends ColumnViewerEditor {
    private TreeEditor treeEditor;
    private SWTFocusCellManager focusCellManager;

    TreeViewerEditor(TreeViewer treeViewer, SWTFocusCellManager sWTFocusCellManager, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n) {
        super(treeViewer, columnViewerEditorActivationStrategy, n);
        this.treeEditor = new TreeEditor(treeViewer.getTree());
        this.focusCellManager = sWTFocusCellManager;
    }

    public static void create(TreeViewer treeViewer, SWTFocusCellManager sWTFocusCellManager, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n) {
        TreeViewerEditor treeViewerEditor = new TreeViewerEditor(treeViewer, sWTFocusCellManager, columnViewerEditorActivationStrategy, n);
        treeViewer.setColumnViewerEditor(treeViewerEditor);
        if (sWTFocusCellManager != null) {
            sWTFocusCellManager.init();
        }
    }

    public static void create(TreeViewer treeViewer, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n) {
        TreeViewerEditor.create(treeViewer, null, columnViewerEditorActivationStrategy, n);
    }

    @Override
    protected void setEditor(Control control, Item item, int n) {
        this.treeEditor.setEditor(control, (TreeItem)item, n);
    }

    @Override
    protected void setLayoutData(CellEditor.LayoutData layoutData) {
        this.treeEditor.grabHorizontal = layoutData.grabHorizontal;
        this.treeEditor.horizontalAlignment = layoutData.horizontalAlignment;
        this.treeEditor.minimumWidth = layoutData.minimumWidth;
        this.treeEditor.verticalAlignment = layoutData.verticalAlignment;
        if (layoutData.minimumHeight != -1) {
            this.treeEditor.minimumHeight = layoutData.minimumHeight;
        }
    }

    @Override
    public ViewerCell getFocusCell() {
        if (this.focusCellManager != null) {
            return this.focusCellManager.getFocusCell();
        }
        return super.getFocusCell();
    }

    @Override
    protected void updateFocusCell(ViewerCell viewerCell, ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        if (columnViewerEditorActivationEvent.eventType == 4 || columnViewerEditorActivationEvent.eventType == 5) {
            List list = this.getViewer().getSelectionFromWidget();
            if (!list.contains(viewerCell.getElement())) {
                this.getViewer().setSelection(new TreeSelection(viewerCell.getViewerRow().getTreePath()), true);
            }
            if (this.focusCellManager != null) {
                this.focusCellManager.setFocusCell(viewerCell);
            }
        }
    }
}

