/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ILazyTreePathContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerRow;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewer
extends AbstractTreeViewer {
    private static final String VIRTUAL_DISPOSE_KEY = "org.eclipse.jface.DISPOSE_LISTENER";
    private Tree tree;
    private boolean treeIsDisposed = false;
    private boolean contentProviderIsLazy;
    private boolean contentProviderIsTreeBased;
    private TreeViewerRow cachedRow;
    private boolean insidePreservingSelection;

    public TreeViewer(Composite composite) {
        this(composite, 2818);
    }

    public TreeViewer(Composite composite, int n) {
        this(new Tree(composite, n));
    }

    public TreeViewer(Tree tree) {
        this.tree = tree;
        this.hookControl((Control)tree);
    }

    @Override
    protected void addTreeListener(Control control, TreeListener treeListener) {
        ((Tree)control).addTreeListener(treeListener);
    }

    @Override
    protected Widget getColumnViewerOwner(int n) {
        if (n < 0 || n > 0 && n >= this.getTree().getColumnCount()) {
            return null;
        }
        if (this.getTree().getColumnCount() == 0) {
            return this.getTree();
        }
        return this.getTree().getColumn(n);
    }

    @Override
    protected Item[] getChildren(Widget widget) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItems();
        }
        if (widget instanceof Tree) {
            return ((Tree)widget).getItems();
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.tree;
    }

    @Override
    protected boolean getExpanded(Item item) {
        return ((TreeItem)item).getExpanded();
    }

    @Override
    protected Item getItemAt(Point point) {
        TreeItem[] treeItemArray = this.tree.getSelection();
        if (treeItemArray.length == 1) {
            int n = this.tree.getColumnCount();
            int n2 = 0;
            while (n2 < n) {
                if (treeItemArray[0].getBounds(n2).contains(point)) {
                    return treeItemArray[0];
                }
                ++n2;
            }
        }
        return this.getTree().getItem(point);
    }

    @Override
    protected int getItemCount(Control control) {
        return ((Tree)control).getItemCount();
    }

    @Override
    protected int getItemCount(Item item) {
        return ((TreeItem)item).getItemCount();
    }

    @Override
    protected Item[] getItems(Item item) {
        return ((TreeItem)item).getItems();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    @Override
    protected Item getParentItem(Item item) {
        return ((TreeItem)item).getParentItem();
    }

    @Override
    protected Item[] getSelection(Control control) {
        return ((Tree)control).getSelection();
    }

    public Tree getTree() {
        return this.tree;
    }

    @Override
    protected void hookControl(Control control) {
        super.hookControl(control);
        Tree tree = (Tree)control;
        if ((tree.getStyle() & 0x10000000) != 0) {
            tree.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    TreeViewer.this.treeIsDisposed = true;
                    TreeViewer.this.unmapAllElements();
                }
            });
            tree.addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    if (TreeViewer.this.contentProviderIsLazy) {
                        TreeItem treeItem = (TreeItem)event.item;
                        TreeItem treeItem2 = treeItem.getParentItem();
                        int n = event.index;
                        TreeViewer.this.virtualLazyUpdateWidget((Widget)(treeItem2 == null ? TreeViewer.this.getTree() : treeItem2), n);
                    }
                }
            });
        }
    }

    @Override
    protected ColumnViewerEditor createViewerEditor() {
        return new TreeViewerEditor(this, null, new ColumnViewerEditorActivationStrategy(this), 1);
    }

    @Override
    protected Item newItem(Widget widget, int n, int n2) {
        TreeItem treeItem = widget instanceof TreeItem ? (TreeItem)this.createNewRowPart(this.getViewerRowFromItem(widget), n, n2).getItem() : (TreeItem)this.createNewRowPart(null, n, n2).getItem();
        return treeItem;
    }

    @Override
    protected void removeAll(Control control) {
        ((Tree)control).removeAll();
    }

    @Override
    protected void setExpanded(Item item, boolean bl) {
        ((TreeItem)item).setExpanded(bl);
        if (this.contentProviderIsLazy) {
            this.getControl().update();
        }
    }

    @Override
    protected void setSelection(List list) {
        Item[] itemArray = this.getSelection((Control)this.getTree());
        if (this.isSameSelection(list, itemArray)) {
            return;
        }
        TreeItem[] treeItemArray = new TreeItem[list.size()];
        list.toArray(treeItemArray);
        this.getTree().setSelection(treeItemArray);
    }

    @Override
    protected void showItem(Item item) {
        this.getTree().showItem((TreeItem)item);
    }

    @Override
    protected Item getChild(Widget widget, int n) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItem(n);
        }
        if (widget instanceof Tree) {
            return ((Tree)widget).getItem(n);
        }
        return null;
    }

    @Override
    protected void assertContentProviderType(IContentProvider iContentProvider) {
        if (iContentProvider instanceof ILazyTreeContentProvider || iContentProvider instanceof ILazyTreePathContentProvider) {
            return;
        }
        super.assertContentProviderType(iContentProvider);
    }

    @Override
    protected Object[] getRawChildren(Object object) {
        if (this.contentProviderIsLazy) {
            return new Object[0];
        }
        return super.getRawChildren(object);
    }

    @Override
    void preservingSelection(Runnable runnable, boolean bl) {
        if (this.insidePreservingSelection || !this.getPreserveSelection()) {
            runnable.run();
            return;
        }
        this.insidePreservingSelection = true;
        try {
            super.preservingSelection(runnable, bl);
        }
        finally {
            this.insidePreservingSelection = false;
        }
    }

    public void setChildCount(final Object object, final int n) {
        if (this.checkBusy()) {
            return;
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                if (TreeViewer.this.internalIsInputOrEmptyPath(object)) {
                    TreeViewer.this.getTree().setItemCount(n);
                    return;
                }
                Widget[] widgetArray = TreeViewer.this.internalFindItems(object);
                int n2 = 0;
                while (n2 < widgetArray.length) {
                    TreeItem treeItem = (TreeItem)widgetArray[n2];
                    treeItem.setItemCount(n);
                    ++n2;
                }
            }
        });
    }

    public void replace(Object object, int n, Object object2) {
        Object object3;
        TreeSelection treeSelection;
        block13: {
            Widget[] widgetArray;
            Item[] itemArray;
            block12: {
                if (this.checkBusy()) {
                    return;
                }
                itemArray = this.getSelection(this.getControl());
                treeSelection = (TreeSelection)this.getSelection();
                if (object instanceof TreePath) {
                    object3 = ((TreePath)object).createChildPath(object2);
                    widgetArray = this.internalFindItems(object3);
                } else {
                    widgetArray = this.internalFindItems(object2);
                }
                if (!this.internalIsInputOrEmptyPath(object)) break block12;
                if (n >= this.tree.getItemCount()) break block13;
                object3 = this.tree.getItem(n);
                treeSelection = this.adjustSelectionForReplace(itemArray, treeSelection, (TreeItem)object3, object2, this.getRoot());
                int n2 = 0;
                while (n2 < widgetArray.length) {
                    TreeItem treeItem;
                    if (widgetArray[n2] instanceof TreeItem && (treeItem = (TreeItem)widgetArray[n2]) != object3 && treeItem.getParentItem() == null) {
                        int n3 = this.getTree().indexOf(treeItem);
                        this.disassociate((Item)treeItem);
                        this.getTree().clear(n3, true);
                    }
                    ++n2;
                }
                Object object4 = object3.getData();
                this.updateItem((Widget)object3, object2);
                if (this.equals(object4, object2)) break block13;
                object3.clearAll(true);
                break block13;
            }
            object3 = this.internalFindItems(object);
            int n4 = 0;
            while (n4 < ((TreeItem)object3).length) {
                TreeItem treeItem = object3[n4];
                if (n < treeItem.getItemCount()) {
                    TreeItem treeItem2 = treeItem.getItem(n);
                    treeSelection = this.adjustSelectionForReplace(itemArray, treeSelection, treeItem2, object2, treeItem.getData());
                    int n5 = 0;
                    while (n5 < widgetArray.length) {
                        TreeItem treeItem3;
                        if (widgetArray[n5] instanceof TreeItem && (treeItem3 = (TreeItem)widgetArray[n5]) != treeItem2 && treeItem3.getParentItem() == treeItem) {
                            int n6 = treeItem.indexOf(treeItem3);
                            this.disassociate((Item)treeItem3);
                            treeItem.clear(n6, true);
                        }
                        ++n5;
                    }
                    Object object5 = treeItem2.getData();
                    this.updateItem((Widget)treeItem2, object2);
                    if (!this.equals(object5, object2)) {
                        treeItem2.clearAll(true);
                    }
                }
                ++n4;
            }
        }
        if (!this.insidePreservingSelection) {
            this.setSelectionToWidget(treeSelection, false);
            object3 = this.getSelection();
            if (!object3.equals(treeSelection)) {
                this.handleInvalidSelection(treeSelection, (ISelection)object3);
            }
        }
    }

    private TreeSelection adjustSelectionForReplace(Item[] itemArray, TreeSelection treeSelection, TreeItem treeItem, Object object, Object object2) {
        if (treeItem.getData() != null || itemArray.length == treeSelection.size() || object2 == null) {
            return treeSelection;
        }
        int n = 0;
        while (n < itemArray.length) {
            if (treeItem == itemArray[n]) {
                TreePath[] treePathArray = treeSelection.getPaths();
                int n2 = treePathArray.length;
                TreePath[] treePathArray2 = new TreePath[n2 + 1];
                System.arraycopy(treePathArray, 0, treePathArray2, 0, n2);
                treeItem.setData(object);
                treePathArray2[n2] = this.getTreePathFromItem((Item)treeItem);
                treeItem.setData(null);
                return new TreeSelection(treePathArray2, treeSelection.getElementComparer());
            }
            ++n;
        }
        return treeSelection;
    }

    @Override
    public boolean isExpandable(Object object) {
        if (this.contentProviderIsLazy) {
            TreeItem treeItem = (TreeItem)this.internalExpand(object, false);
            if (treeItem == null) {
                return false;
            }
            this.virtualMaterializeItem(treeItem);
            return treeItem.getItemCount() > 0;
        }
        return super.isExpandable(object);
    }

    @Override
    protected Object getParentElement(Object object) {
        boolean bl = this.isBusy();
        this.setBusy(true);
        try {
            ILazyTreePathContentProvider iLazyTreePathContentProvider;
            TreePath[] treePathArray;
            if (this.contentProviderIsLazy && !this.contentProviderIsTreeBased && !(object instanceof TreePath)) {
                ILazyTreeContentProvider iLazyTreeContentProvider = (ILazyTreeContentProvider)this.getContentProvider();
                Object object2 = iLazyTreeContentProvider.getParent(object);
                return object2;
            }
            if (this.contentProviderIsLazy && this.contentProviderIsTreeBased && !(object instanceof TreePath) && (treePathArray = (iLazyTreePathContentProvider = (ILazyTreePathContentProvider)this.getContentProvider()).getParents(object)) != null && treePathArray.length > 0) {
                TreePath treePath = treePathArray[0];
                return treePath;
            }
            Object object3 = super.getParentElement(object);
            return object3;
        }
        finally {
            this.setBusy(bl);
        }
    }

    @Override
    void createChildren(Widget widget, boolean bl) {
        if (this.contentProviderIsLazy) {
            Object object = widget.getData();
            if (object == null && widget instanceof TreeItem) {
                this.virtualMaterializeItem((TreeItem)widget);
                object = widget.getData();
            }
            if (object == null) {
                return;
            }
            Item[] itemArray = this.getChildren(widget);
            if (itemArray.length == 1 && itemArray[0].getData() == null) {
                this.virtualLazyUpdateChildCount(widget, itemArray.length);
                itemArray = this.getChildren(widget);
            }
            int n = 0;
            while (n < itemArray.length) {
                if (itemArray[n].getData() == null) {
                    if (bl) {
                        this.virtualLazyUpdateWidget(widget, n);
                    } else {
                        ((TreeItem)itemArray[n]).clearAll(true);
                    }
                }
                ++n;
            }
            return;
        }
        super.createChildren(widget, bl);
    }

    @Override
    protected void internalAdd(Widget widget, Object object, Object[] objectArray) {
        if (this.contentProviderIsLazy) {
            if (widget instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)widget;
                int n = treeItem.getItemCount() + objectArray.length;
                treeItem.setItemCount(n);
                treeItem.clearAll(false);
            } else {
                Tree tree = (Tree)widget;
                tree.setItemCount(tree.getItemCount() + objectArray.length);
                tree.clearAll(false);
            }
            return;
        }
        super.internalAdd(widget, object, objectArray);
    }

    private void virtualMaterializeItem(TreeItem treeItem) {
        Object object;
        if (treeItem.getData() != null) {
            return;
        }
        if (!this.contentProviderIsLazy) {
            return;
        }
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 == null) {
            treeItem2 = treeItem.getParent();
        }
        if ((object = treeItem2.getData()) != null) {
            int n = treeItem2 instanceof Tree ? ((Tree)treeItem2).indexOf(treeItem) : treeItem2.indexOf(treeItem);
            this.virtualLazyUpdateWidget((Widget)treeItem2, n);
        }
    }

    @Override
    protected void internalRefreshStruct(Widget widget, Object object, boolean bl) {
        if (this.contentProviderIsLazy) {
            if (widget instanceof Tree) {
                ((Tree)widget).clearAll(true);
            } else if (widget instanceof TreeItem) {
                ((TreeItem)widget).clearAll(true);
            }
            int n = 0;
            TreeItem treeItem = null;
            if (widget instanceof TreeItem) {
                TreeItem treeItem2 = (TreeItem)widget;
                treeItem = treeItem2.getParentItem();
                if (treeItem == null) {
                    treeItem = treeItem2.getParent();
                }
                n = treeItem instanceof Tree ? ((Tree)treeItem).indexOf(treeItem2) : treeItem.indexOf(treeItem2);
            }
            this.virtualRefreshExpandedItems((Widget)treeItem, widget, object, n);
            return;
        }
        super.internalRefreshStruct(widget, object, bl);
    }

    private void virtualRefreshExpandedItems(Widget widget, Widget widget2, Object object, int n) {
        if (widget2 instanceof Tree) {
            if (object == null) {
                ((Tree)widget2).setItemCount(0);
                return;
            }
            this.virtualLazyUpdateChildCount(widget2, this.getChildren(widget2).length);
        } else if (((TreeItem)widget2).getExpanded()) {
            ((TreeItem)widget2).setText(" ");
            this.virtualLazyUpdateWidget(widget, n);
        } else {
            return;
        }
        Item[] itemArray = this.getChildren(widget2);
        int n2 = 0;
        while (n2 < itemArray.length) {
            Item item = itemArray[n2];
            Object object2 = item.getData();
            this.virtualRefreshExpandedItems(widget2, (Widget)item, object2, n2);
            ++n2;
        }
    }

    @Override
    protected void mapElement(Object object, final Widget widget) {
        super.mapElement(object, widget);
        if ((this.getTree().getStyle() & 0x10000000) != 0 && widget.getData(VIRTUAL_DISPOSE_KEY) == null) {
            widget.setData(VIRTUAL_DISPOSE_KEY, (Object)Boolean.TRUE);
            widget.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (!TreeViewer.this.treeIsDisposed) {
                        Object object = widget.getData();
                        if (TreeViewer.this.usingElementMap() && object != null) {
                            TreeViewer.this.unmapElement(object, widget);
                        }
                    }
                }
            });
        }
    }

    @Override
    protected ViewerRow getViewerRowFromItem(Widget widget) {
        if (this.cachedRow == null) {
            this.cachedRow = new TreeViewerRow((TreeItem)widget);
        } else {
            this.cachedRow.setItem((TreeItem)widget);
        }
        return this.cachedRow;
    }

    private ViewerRow createNewRowPart(ViewerRow viewerRow, int n, int n2) {
        if (viewerRow == null) {
            if (n2 >= 0) {
                return this.getViewerRowFromItem((Widget)new TreeItem(this.tree, n, n2));
            }
            return this.getViewerRowFromItem((Widget)new TreeItem(this.tree, n));
        }
        if (n2 >= 0) {
            return this.getViewerRowFromItem((Widget)new TreeItem((TreeItem)viewerRow.getItem(), 0, n2));
        }
        return this.getViewerRowFromItem((Widget)new TreeItem((TreeItem)viewerRow.getItem(), 0));
    }

    @Override
    protected void internalInitializeTree(Control control) {
        if (this.contentProviderIsLazy && control instanceof Tree && control.getData() != null) {
            this.virtualLazyUpdateChildCount((Widget)control, 0);
            return;
        }
        super.internalInitializeTree((Control)this.tree);
    }

    @Override
    protected void updatePlus(Item item, Object object) {
        if (this.contentProviderIsLazy) {
            Object object2 = item.getData();
            int n = 0;
            if (object2 != null) {
                n = ((TreeItem)item).getItemCount();
            }
            this.virtualLazyUpdateHasChildren(item, n);
        } else {
            super.updatePlus(item, object);
        }
    }

    public void remove(final Object object, final int n) {
        if (this.checkBusy()) {
            return;
        }
        final LinkedList<TreePath> linkedList = new LinkedList<TreePath>(Arrays.asList(((TreeSelection)this.getSelection()).getPaths()));
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                Object object3;
                Object object2;
                Widget[] widgetArray;
                TreePath treePath = null;
                if (TreeViewer.this.internalIsInputOrEmptyPath(object)) {
                    widgetArray = (Widget[])TreeViewer.this.getControl();
                    if (n < widgetArray.getItemCount()) {
                        object2 = widgetArray.getItem(n);
                        if (object2.getData() != null) {
                            treePath = TreeViewer.this.getTreePathFromItem((Item)object2);
                            TreeViewer.this.disassociate((Item)object2);
                        }
                        object2.dispose();
                    }
                } else {
                    widgetArray = TreeViewer.this.internalFindItems(object);
                    int n2 = 0;
                    while (n2 < widgetArray.length) {
                        object3 = (TreeItem)widgetArray[n2];
                        if (!object3.isDisposed() && n < object3.getItemCount()) {
                            TreeItem treeItem = object3.getItem(n);
                            if (treeItem.getData() == null) {
                                if (n > 0 || object3.getExpanded()) {
                                    treeItem.dispose();
                                }
                            } else {
                                treePath = TreeViewer.this.getTreePathFromItem((Item)treeItem);
                                TreeViewer.this.disassociate((Item)treeItem);
                                treeItem.dispose();
                            }
                        }
                        ++n2;
                    }
                }
                if (treePath != null) {
                    boolean bl = false;
                    object2 = linkedList.iterator();
                    while (object2.hasNext()) {
                        object3 = (TreePath)object2.next();
                        if (!((TreePath)object3).startsWith(treePath, TreeViewer.this.getComparer())) continue;
                        object2.remove();
                        bl = true;
                    }
                    if (bl) {
                        TreeViewer.this.setSelection(new TreeSelection(linkedList.toArray(new TreePath[linkedList.size()]), TreeViewer.this.getComparer()), false);
                    }
                }
            }
        });
    }

    @Override
    protected void handleTreeExpand(TreeEvent treeEvent) {
        if (this.isCellEditorActive()) {
            this.applyEditorValue();
        }
        if (this.contentProviderIsLazy) {
            if (treeEvent.item.getData() != null) {
                Item[] itemArray = this.getChildren(treeEvent.item);
                if (itemArray.length == 1 && itemArray[0].getData() == null) {
                    this.virtualLazyUpdateChildCount(treeEvent.item, itemArray.length);
                }
                this.fireTreeExpanded(new TreeExpansionEvent(this, treeEvent.item.getData()));
            }
            return;
        }
        super.handleTreeExpand(treeEvent);
    }

    @Override
    protected void handleTreeCollapse(TreeEvent treeEvent) {
        if (this.isCellEditorActive()) {
            this.applyEditorValue();
        }
        super.handleTreeCollapse(treeEvent);
    }

    @Override
    public void setContentProvider(IContentProvider iContentProvider) {
        this.contentProviderIsLazy = iContentProvider instanceof ILazyTreeContentProvider || iContentProvider instanceof ILazyTreePathContentProvider;
        this.contentProviderIsTreeBased = iContentProvider instanceof ILazyTreePathContentProvider;
        super.setContentProvider(iContentProvider);
    }

    public void setHasChildren(final Object object, final boolean bl) {
        if (this.checkBusy()) {
            return;
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                if (TreeViewer.this.internalIsInputOrEmptyPath(object)) {
                    if (bl) {
                        TreeViewer.this.virtualLazyUpdateChildCount((Widget)TreeViewer.this.getTree(), TreeViewer.this.getChildren((Widget)TreeViewer.this.getTree()).length);
                    } else {
                        TreeViewer.this.setChildCount(object, 0);
                    }
                    return;
                }
                Widget[] widgetArray = TreeViewer.this.internalFindItems(object);
                int n = 0;
                while (n < widgetArray.length) {
                    TreeItem treeItem = (TreeItem)widgetArray[n];
                    if (!bl) {
                        treeItem.setItemCount(0);
                    } else if (!treeItem.getExpanded()) {
                        treeItem.setItemCount(1);
                        TreeItem treeItem2 = treeItem.getItem(0);
                        if (treeItem2.getData() != null) {
                            TreeViewer.this.disassociate((Item)treeItem2);
                        }
                        treeItem.clear(0, true);
                    } else {
                        TreeViewer.this.virtualLazyUpdateChildCount((Widget)treeItem, treeItem.getItemCount());
                    }
                    ++n;
                }
            }
        });
    }

    private void virtualLazyUpdateWidget(Widget widget, int n) {
        boolean bl = this.isBusy();
        this.setBusy(false);
        try {
            if (this.contentProviderIsTreeBased) {
                TreePath treePath;
                if (widget instanceof Item) {
                    if (widget.getData() == null) {
                        return;
                    }
                    treePath = this.getTreePathFromItem((Item)widget);
                } else {
                    treePath = TreePath.EMPTY;
                }
                ((ILazyTreePathContentProvider)this.getContentProvider()).updateElement(treePath, n);
            } else {
                ((ILazyTreeContentProvider)this.getContentProvider()).updateElement(widget.getData(), n);
            }
        }
        finally {
            this.setBusy(bl);
        }
    }

    private void virtualLazyUpdateChildCount(Widget widget, int n) {
        boolean bl = this.isBusy();
        this.setBusy(false);
        try {
            if (this.contentProviderIsTreeBased) {
                TreePath treePath = widget instanceof Item ? this.getTreePathFromItem((Item)widget) : TreePath.EMPTY;
                ((ILazyTreePathContentProvider)this.getContentProvider()).updateChildCount(treePath, n);
            } else {
                ((ILazyTreeContentProvider)this.getContentProvider()).updateChildCount(widget.getData(), n);
            }
        }
        finally {
            this.setBusy(bl);
        }
    }

    private void virtualLazyUpdateHasChildren(Item item, int n) {
        boolean bl = this.isBusy();
        this.setBusy(false);
        try {
            if (this.contentProviderIsTreeBased) {
                TreePath treePath = this.getTreePathFromItem(item);
                if (n == 0 || !((TreeItem)item).getExpanded()) {
                    ((ILazyTreePathContentProvider)this.getContentProvider()).updateHasChildren(treePath);
                } else {
                    ((ILazyTreePathContentProvider)this.getContentProvider()).updateChildCount(treePath, n);
                }
            } else {
                ((ILazyTreeContentProvider)this.getContentProvider()).updateChildCount(item.getData(), n);
            }
        }
        finally {
            this.setBusy(bl);
        }
    }

    @Override
    protected void disassociate(Item item) {
        if (this.contentProviderIsLazy) {
            item.setText(" ");
        }
        super.disassociate(item);
    }

    @Override
    protected int doGetColumnCount() {
        return this.tree.getColumnCount();
    }

    @Override
    public void setSelection(ISelection iSelection, boolean bl) {
        super.setSelection(iSelection, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void editElement(Object object, int n) {
        if (object instanceof TreePath) {
            try {
                ViewerCell viewerCell;
                ViewerRow viewerRow;
                this.getControl().setRedraw(false);
                this.setSelection(new TreeSelection((TreePath)object));
                TreeItem[] treeItemArray = this.tree.getSelection();
                if (treeItemArray.length != 1 || (viewerRow = this.getViewerRowFromItem((Widget)treeItemArray[0])) == null || (viewerCell = viewerRow.getCell(n)) == null) return;
                this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(viewerCell));
                return;
            }
            finally {
                this.getControl().setRedraw(true);
            }
        } else {
            super.editElement(object, n);
        }
    }
}

