/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;

public class TreeSelection
extends StructuredSelection
implements ITreeSelection {
    private TreePath[] paths;
    private CustomHashtable element2TreePaths;
    public static final TreeSelection EMPTY = new TreeSelection();
    private static final TreePath[] EMPTY_TREE_PATHS = new TreePath[0];

    public TreeSelection(TreePath[] treePathArray) {
        this(new InitializeData(treePathArray, null));
    }

    public TreeSelection(TreePath[] treePathArray, IElementComparer iElementComparer) {
        this(new InitializeData(treePathArray, iElementComparer));
    }

    public TreeSelection(TreePath treePath) {
        TreePath[] treePathArray;
        if (treePath != null) {
            TreePath[] treePathArray2 = new TreePath[1];
            treePathArray = treePathArray2;
            treePathArray2[0] = treePath;
        } else {
            treePathArray = EMPTY_TREE_PATHS;
        }
        this(treePathArray, null);
    }

    public TreeSelection(TreePath treePath, IElementComparer iElementComparer) {
        TreePath[] treePathArray;
        if (treePath != null) {
            TreePath[] treePathArray2 = new TreePath[1];
            treePathArray = treePathArray2;
            treePathArray2[0] = treePath;
        } else {
            treePathArray = EMPTY_TREE_PATHS;
        }
        this(treePathArray, iElementComparer);
    }

    private TreeSelection(InitializeData initializeData) {
        super(initializeData.selection);
        this.paths = null;
        this.element2TreePaths = null;
        this.paths = initializeData.paths;
        this.element2TreePaths = initializeData.element2TreePaths;
    }

    public TreeSelection() {
        this.paths = null;
        this.element2TreePaths = null;
    }

    public IElementComparer getElementComparer() {
        if (this.element2TreePaths == null) {
            return null;
        }
        return this.element2TreePaths.getComparer();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TreeSelection)) {
            return super.equals(object);
        }
        TreeSelection treeSelection = (TreeSelection)object;
        int n = this.getPaths().length;
        if (treeSelection.getPaths().length == n) {
            IElementComparer iElementComparer;
            IElementComparer iElementComparer2 = iElementComparer = this.getElementComparer() == treeSelection.getElementComparer() ? this.getElementComparer() : null;
            if (n > 0) {
                int n2 = 0;
                while (n2 < this.paths.length) {
                    if (!this.paths[n2].equals(treeSelection.paths[n2], iElementComparer)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = this.getClass().hashCode();
        if (this.paths != null) {
            int n2 = 0;
            while (n2 < this.paths.length) {
                n = n * 17 + this.paths[n2].hashCode(this.getElementComparer());
                ++n2;
            }
        }
        return n;
    }

    @Override
    public TreePath[] getPaths() {
        return this.paths == null ? EMPTY_TREE_PATHS : (TreePath[])this.paths.clone();
    }

    @Override
    public TreePath[] getPathsFor(Object object) {
        Object object2;
        Object object3 = object2 = this.element2TreePaths == null ? null : this.element2TreePaths.get(object);
        if (object2 == null) {
            return EMPTY_TREE_PATHS;
        }
        if (object2 instanceof TreePath) {
            return new TreePath[]{(TreePath)object2};
        }
        if (object2 instanceof List) {
            List list = (List)object2;
            return list.toArray(new TreePath[list.size()]);
        }
        Assert.isTrue((boolean)false, (String)"Unhandled case");
        return null;
    }

    private static class InitializeData {
        List selection;
        TreePath[] paths;
        CustomHashtable element2TreePaths;

        private InitializeData(TreePath[] treePathArray, IElementComparer iElementComparer) {
            this.paths = new TreePath[treePathArray.length];
            System.arraycopy(treePathArray, 0, this.paths, 0, treePathArray.length);
            this.element2TreePaths = new CustomHashtable(iElementComparer);
            int n = treePathArray.length;
            this.selection = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                Object object = treePathArray[n2].getLastSegment();
                Object object2 = this.element2TreePaths.get(object);
                if (object2 == null) {
                    this.selection.add(object);
                    this.element2TreePaths.put(object, treePathArray[n2]);
                } else if (object2 instanceof List) {
                    ((List)object2).add(treePathArray[n2]);
                } else {
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(object2);
                    arrayList.add(treePathArray[n2]);
                    this.element2TreePaths.put(object, arrayList);
                }
                ++n2;
            }
        }
    }
}

