/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IElementComparer;

public final class TreePath {
    public static final TreePath EMPTY = new TreePath(new Object[0]);
    private Object[] segments;
    private int hash;

    public TreePath(Object[] objectArray) {
        Assert.isNotNull((Object)objectArray);
        int n = 0;
        while (n < objectArray.length) {
            Assert.isNotNull((Object)objectArray[n]);
            ++n;
        }
        this.segments = objectArray;
    }

    public Object getSegment(int n) {
        return this.segments[n];
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public Object getFirstSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[0];
    }

    public Object getLastSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public boolean equals(Object object) {
        if (!(object instanceof TreePath)) {
            return false;
        }
        return this.equals((TreePath)object, null);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hashCode(null);
        }
        return this.hash;
    }

    public int hashCode(IElementComparer iElementComparer) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.segments.length) {
            n = iElementComparer == null ? (n += this.segments[n2].hashCode()) : (n += iElementComparer.hashCode(this.segments[n2]));
            ++n2;
        }
        return n;
    }

    public boolean equals(TreePath treePath, IElementComparer iElementComparer) {
        if (treePath == null) {
            return false;
        }
        if (this.segments.length != treePath.segments.length) {
            return false;
        }
        int n = 0;
        while (n < this.segments.length) {
            if (iElementComparer == null ? !this.segments[n].equals(treePath.segments[n]) : !iElementComparer.equals(this.segments[n], treePath.segments[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean startsWith(TreePath treePath, IElementComparer iElementComparer) {
        int n = this.getSegmentCount();
        int n2 = treePath.getSegmentCount();
        if (n2 == n) {
            return this.equals(treePath, iElementComparer);
        }
        if (n2 > n) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            Object object = treePath.getSegment(n3);
            if (iElementComparer == null ? !object.equals(this.segments[n3]) : !iElementComparer.equals(object, this.segments[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public TreePath getParentPath() {
        int n = this.getSegmentCount();
        if (n < 1) {
            return null;
        }
        if (n == 1) {
            return EMPTY;
        }
        Object[] objectArray = new Object[n - 1];
        System.arraycopy(this.segments, 0, objectArray, 0, n - 1);
        return new TreePath(objectArray);
    }

    public TreePath createChildPath(Object object) {
        int n = this.getSegmentCount();
        Object[] objectArray = new Object[n + 1];
        if (n > 0) {
            System.arraycopy(this.segments, 0, objectArray, 0, n);
        }
        objectArray[n] = object;
        return new TreePath(objectArray);
    }
}

