/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableViewerRow
extends ViewerRow {
    private TableItem item;

    TableViewerRow(TableItem tableItem) {
        this.item = tableItem;
    }

    @Override
    public Rectangle getBounds(int n) {
        return this.item.getBounds(n);
    }

    @Override
    public Rectangle getBounds() {
        return this.item.getBounds();
    }

    @Override
    public Widget getItem() {
        return this.item;
    }

    void setItem(TableItem tableItem) {
        this.item = tableItem;
    }

    @Override
    public int getColumnCount() {
        return this.item.getParent().getColumnCount();
    }

    @Override
    public Color getBackground(int n) {
        return this.item.getBackground(n);
    }

    @Override
    public Font getFont(int n) {
        return this.item.getFont(n);
    }

    @Override
    public Color getForeground(int n) {
        return this.item.getForeground(n);
    }

    @Override
    public Image getImage(int n) {
        return this.item.getImage(n);
    }

    @Override
    public String getText(int n) {
        return this.item.getText(n);
    }

    @Override
    public void setBackground(int n, Color color) {
        this.item.setBackground(n, color);
    }

    @Override
    public void setFont(int n, Font font) {
        this.item.setFont(n, font);
    }

    @Override
    public void setForeground(int n, Color color) {
        this.item.setForeground(n, color);
    }

    @Override
    public void setImage(int n, Image image) {
        Image image2 = this.item.getImage(n);
        if (image2 != image) {
            this.item.setImage(n, image);
        }
    }

    @Override
    public void setText(int n, String string) {
        this.item.setText(n, string == null ? "" : string);
    }

    @Override
    public Control getControl() {
        return this.item.getParent();
    }

    @Override
    public ViewerRow getNeighbor(int n, boolean bl) {
        if (n == 1) {
            return this.getRowAbove();
        }
        if (n == 2) {
            return this.getRowBelow();
        }
        throw new IllegalArgumentException("Illegal value of direction argument.");
    }

    private ViewerRow getRowAbove() {
        int n = this.item.getParent().indexOf(this.item) - 1;
        if (n >= 0) {
            return new TableViewerRow(this.item.getParent().getItem(n));
        }
        return null;
    }

    private ViewerRow getRowBelow() {
        TableItem tableItem;
        int n = this.item.getParent().indexOf(this.item) + 1;
        if (n < this.item.getParent().getItemCount() && (tableItem = this.item.getParent().getItem(n)) != null) {
            return new TableViewerRow(tableItem);
        }
        return null;
    }

    @Override
    public TreePath getTreePath() {
        return new TreePath(new Object[]{this.item.getData()});
    }

    @Override
    public Object clone() {
        return new TableViewerRow(this.item);
    }

    @Override
    public Object getElement() {
        return this.item.getData();
    }

    @Override
    public int getVisualIndex(int n) {
        int[] nArray = this.item.getParent().getColumnOrder();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return super.getVisualIndex(n);
    }

    @Override
    public int getCreationIndex(int n) {
        if (this.item != null && !this.item.isDisposed() && this.hasColumns() && this.isValidOrderIndex(n)) {
            return this.item.getParent().getColumnOrder()[n];
        }
        return super.getCreationIndex(n);
    }

    @Override
    public Rectangle getTextBounds(int n) {
        return this.item.getTextBounds(n);
    }

    @Override
    public Rectangle getImageBounds(int n) {
        return this.item.getImageBounds(n);
    }

    private boolean hasColumns() {
        return this.item.getParent().getColumnCount() != 0;
    }

    private boolean isValidOrderIndex(int n) {
        return n < this.item.getParent().getColumnOrder().length;
    }

    @Override
    int getWidth(int n) {
        return this.item.getParent().getColumn(n).getWidth();
    }

    @Override
    protected boolean scrollCellIntoView(int n) {
        this.item.getParent().showItem(this.item);
        if (this.hasColumns()) {
            this.item.getParent().showColumn(this.item.getParent().getColumn(n));
        }
        return true;
    }
}

