/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class TableViewerFocusCellManager
extends SWTFocusCellManager {
    private static final CellNavigationStrategy TABLE_NAVIGATE = new CellNavigationStrategy();

    public TableViewerFocusCellManager(TableViewer tableViewer, FocusCellHighlighter focusCellHighlighter) {
        this(tableViewer, focusCellHighlighter, TABLE_NAVIGATE);
    }

    public TableViewerFocusCellManager(TableViewer tableViewer, FocusCellHighlighter focusCellHighlighter, CellNavigationStrategy cellNavigationStrategy) {
        super(tableViewer, focusCellHighlighter, cellNavigationStrategy);
    }

    @Override
    ViewerCell getInitialFocusCell() {
        Table table = (Table)this.getViewer().getControl();
        if (!table.isDisposed() && table.getItemCount() > 0 && !table.getItem(table.getTopIndex()).isDisposed()) {
            ViewerRow viewerRow = this.getViewer().getViewerRowFromItem((Widget)table.getItem(table.getTopIndex()));
            if (table.getColumnCount() == 0) {
                return viewerRow.getCell(0);
            }
            Rectangle rectangle = table.getClientArea();
            int n = 0;
            while (n < table.getColumnCount()) {
                if (viewerRow.getWidth(n) > 0 && this.columnInVisibleArea(rectangle, viewerRow, n)) {
                    return viewerRow.getCell(n);
                }
                ++n;
            }
        }
        return null;
    }

    private boolean columnInVisibleArea(Rectangle rectangle, ViewerRow viewerRow, int n) {
        return viewerRow.getBounds((int)n).x >= rectangle.x;
    }

    @Override
    public ViewerCell getFocusCell() {
        ViewerCell viewerCell = super.getFocusCell();
        Table table = (Table)this.getViewer().getControl();
        if (viewerCell != null && table.getSelection().length == 1 && table.getSelection()[0] != viewerCell.getItem()) {
            this.setFocusCell(this.getViewer().getViewerRowFromItem((Widget)table.getSelection()[0]).getCell(viewerCell.getColumnIndex()));
        }
        return super.getFocusCell();
    }
}

