/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IIndexableLazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerRow;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableViewer
extends AbstractTableViewer {
    private Table table;
    private TableViewerRow cachedRow;

    public TableViewer(Composite composite) {
        this(composite, 2818);
    }

    public TableViewer(Composite composite, int n) {
        this(new Table(composite, n));
    }

    public TableViewer(Table table) {
        this.table = table;
        this.hookControl((Control)table);
    }

    @Override
    public Control getControl() {
        return this.table;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    protected ColumnViewerEditor createViewerEditor() {
        return new TableViewerEditor(this, null, new ColumnViewerEditorActivationStrategy(this), 1);
    }

    @Override
    public void setSelection(ISelection iSelection, boolean bl) {
        super.setSelection(iSelection, bl);
    }

    @Override
    protected ViewerRow getViewerRowFromItem(Widget widget) {
        if (this.cachedRow == null) {
            this.cachedRow = new TableViewerRow((TableItem)widget);
        } else {
            this.cachedRow.setItem((TableItem)widget);
        }
        return this.cachedRow;
    }

    @Override
    protected ViewerRow internalCreateNewRowPart(int n, int n2) {
        TableItem tableItem = n2 >= 0 ? new TableItem(this.table, n, n2) : new TableItem(this.table, n);
        return this.getViewerRowFromItem((Widget)tableItem);
    }

    @Override
    protected Item getItemAt(Point point) {
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray.length == 1) {
            int n = this.table.getColumnCount();
            int n2 = 0;
            while (n2 < n) {
                if (tableItemArray[0].getBounds(n2).contains(point)) {
                    return tableItemArray[0];
                }
                ++n2;
            }
        }
        return this.table.getItem(point);
    }

    @Override
    protected int doGetItemCount() {
        return this.table.getItemCount();
    }

    @Override
    protected int doIndexOf(Item item) {
        return this.table.indexOf((TableItem)item);
    }

    @Override
    protected void doSetItemCount(int n) {
        this.table.setItemCount(n);
    }

    @Override
    protected Item[] doGetItems() {
        return this.table.getItems();
    }

    @Override
    protected int doGetColumnCount() {
        return this.table.getColumnCount();
    }

    @Override
    protected Widget doGetColumn(int n) {
        return this.table.getColumn(n);
    }

    @Override
    protected Item doGetItem(int n) {
        return this.table.getItem(n);
    }

    @Override
    protected Item[] doGetSelection() {
        return this.table.getSelection();
    }

    @Override
    protected int[] doGetSelectionIndices() {
        return this.table.getSelectionIndices();
    }

    @Override
    protected void doClearAll() {
        this.table.clearAll();
    }

    @Override
    protected void doResetItem(Item item) {
        TableItem tableItem = (TableItem)item;
        int n = Math.max(1, this.table.getColumnCount());
        int n2 = 0;
        while (n2 < n) {
            tableItem.setText(n2, "");
            if (tableItem.getImage(n2) != null) {
                tableItem.setImage(n2, null);
            }
            ++n2;
        }
    }

    @Override
    protected void doRemove(int n, int n2) {
        this.table.remove(n, n2);
    }

    @Override
    protected void doRemoveAll() {
        this.table.removeAll();
    }

    @Override
    protected void doRemove(int[] nArray) {
        this.table.remove(nArray);
    }

    @Override
    protected void doShowItem(Item item) {
        this.table.showItem((TableItem)item);
    }

    @Override
    protected void doDeselectAll() {
        this.table.deselectAll();
    }

    @Override
    protected void doSetSelection(Item[] itemArray) {
        Assert.isNotNull((Object)itemArray, (String)"Items-Array can not be null");
        TableItem[] tableItemArray = new TableItem[itemArray.length];
        System.arraycopy(itemArray, 0, tableItemArray, 0, tableItemArray.length);
        this.table.setSelection(tableItemArray);
    }

    @Override
    protected void doShowSelection() {
        this.table.showSelection();
    }

    @Override
    protected void doSetSelection(int[] nArray) {
        this.table.setSelection(nArray);
    }

    @Override
    protected void doClear(int n) {
        this.table.clear(n);
    }

    @Override
    protected void doSelect(int[] nArray) {
        this.table.select(nArray);
    }

    public void refresh(final Object object, final boolean bl, boolean bl2) {
        if (this.checkBusy()) {
            return;
        }
        if (this.isCellEditorActive()) {
            this.cancelEditing();
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                TableViewer.this.internalRefresh(object, bl);
            }
        }, bl2);
    }

    public void refresh(boolean bl, boolean bl2) {
        this.refresh(this.getRoot(), bl, bl2);
    }

    @Override
    public void remove(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        if (this.checkBusy()) {
            return;
        }
        if (objectArray.length == 0) {
            return;
        }
        boolean bl = false;
        Object object = null;
        CustomHashtable customHashtable = null;
        if (objectArray.length == 1) {
            object = objectArray[0];
        } else {
            customHashtable = new CustomHashtable(this.getComparer());
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = objectArray[n];
                customHashtable.put(object2, object2);
                ++n;
            }
        }
        int[] nArray = this.doGetSelectionIndices();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            Item item = this.doGetItem(n2);
            Object object3 = item.getData();
            if (object3 != null && (customHashtable != null && customHashtable.containsKey(object3) || this.equals(object, object3))) {
                this.table.deselect(n2);
                bl = true;
            }
            ++n;
        }
        super.remove(objectArray);
        if (bl) {
            ISelection iSelection = this.getSelection();
            this.updateSelection(iSelection);
            this.firePostSelectionChanged(new SelectionChangedEvent(this, iSelection));
        }
    }

    @Override
    protected Widget doFindItem(Object object) {
        IContentProvider iContentProvider = this.getContentProvider();
        if (iContentProvider instanceof IIndexableLazyContentProvider) {
            IIndexableLazyContentProvider iIndexableLazyContentProvider = (IIndexableLazyContentProvider)iContentProvider;
            int n = iIndexableLazyContentProvider.findElement(object);
            if (n != -1) {
                return this.doGetItem(n);
            }
            return null;
        }
        return super.doFindItem(object);
    }
}

