/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeEditor;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableTreeViewer
extends AbstractTreeViewer {
    private TableTreeEditorImpl tableEditorImpl;
    private TableTree tableTree;
    private TableTreeEditor tableTreeEditor;

    public TableTreeViewer(TableTree tableTree) {
        this.tableTree = tableTree;
        this.hookControl((Control)tableTree);
        this.tableTreeEditor = new TableTreeEditor(this.tableTree);
        this.tableEditorImpl = new TableTreeEditorImpl(this);
    }

    public TableTreeViewer(Composite composite) {
        this(composite, 2818);
    }

    public TableTreeViewer(Composite composite, int n) {
        this(new TableTree(composite, n));
    }

    @Override
    protected void addTreeListener(Control control, TreeListener treeListener) {
        ((TableTree)control).addTreeListener(treeListener);
    }

    @Override
    public void cancelEditing() {
        this.tableEditorImpl.cancelEditing();
    }

    @Override
    protected void doUpdateItem(Item item, Object object) {
        IBaseLabelProvider iBaseLabelProvider = this.getLabelProvider();
        ITableLabelProvider iTableLabelProvider = null;
        if (iBaseLabelProvider instanceof ITableLabelProvider) {
            iTableLabelProvider = (ITableLabelProvider)iBaseLabelProvider;
        }
        int n = this.tableTree.getTable().getColumnCount();
        TableTreeItem tableTreeItem = (TableTreeItem)item;
        int n2 = 0;
        while (n2 < n || n2 == 0) {
            String string = "";
            Image image = null;
            if (iTableLabelProvider != null) {
                string = iTableLabelProvider.getColumnText(object, n2);
                image = iTableLabelProvider.getColumnImage(object, n2);
            } else if (n2 == 0) {
                ViewerLabel viewerLabel = new ViewerLabel(item.getText(), item.getImage());
                this.buildLabel(viewerLabel, object);
                if (item.isDisposed()) {
                    this.unmapElement(object, (Widget)item);
                    return;
                }
                string = viewerLabel.getText();
                image = viewerLabel.getImage();
            }
            if (string == null) {
                string = "";
            }
            tableTreeItem.setText(n2, string);
            if (tableTreeItem.getImage(n2) != image) {
                tableTreeItem.setImage(n2, image);
            }
            this.getColorAndFontCollector().setFontsAndColors(object);
            this.getColorAndFontCollector().applyFontsAndColors(tableTreeItem);
            ++n2;
        }
    }

    @Override
    public void editElement(Object object, int n) {
        this.tableEditorImpl.editElement(object, n);
    }

    @Override
    public CellEditor[] getCellEditors() {
        return this.tableEditorImpl.getCellEditors();
    }

    @Override
    public ICellModifier getCellModifier() {
        return this.tableEditorImpl.getCellModifier();
    }

    @Override
    protected Item[] getChildren(Widget widget) {
        if (widget instanceof TableTreeItem) {
            return ((TableTreeItem)widget).getItems();
        }
        if (widget instanceof TableTree) {
            return ((TableTree)widget).getItems();
        }
        return null;
    }

    @Override
    protected Item getChild(Widget widget, int n) {
        if (widget instanceof TableTreeItem) {
            return ((TableTreeItem)widget).getItem(n);
        }
        if (widget instanceof TableTree) {
            return ((TableTree)widget).getItem(n);
        }
        return null;
    }

    @Override
    public Object[] getColumnProperties() {
        return this.tableEditorImpl.getColumnProperties();
    }

    @Override
    public Control getControl() {
        return this.tableTree;
    }

    public Object getElementAt(int n) {
        TableTreeItem tableTreeItem = this.tableTree.getItems()[n];
        if (tableTreeItem != null) {
            return tableTreeItem.getData();
        }
        return null;
    }

    @Override
    protected boolean getExpanded(Item item) {
        return ((TableTreeItem)item).getExpanded();
    }

    @Override
    protected Item getItemAt(Point point) {
        return this.getTableTree().getTable().getItem(point);
    }

    @Override
    protected int getItemCount(Control control) {
        return ((TableTree)control).getItemCount();
    }

    @Override
    protected int getItemCount(Item item) {
        return ((TableTreeItem)item).getItemCount();
    }

    @Override
    protected Item[] getItems(Item item) {
        return ((TableTreeItem)item).getItems();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    @Override
    protected Item getParentItem(Item item) {
        return ((TableTreeItem)item).getParentItem();
    }

    @Override
    protected Item[] getSelection(Control control) {
        return ((TableTree)control).getSelection();
    }

    public TableTree getTableTree() {
        return this.tableTree;
    }

    @Override
    protected void hookControl(Control control) {
        super.hookControl(control);
        this.tableTree.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                TableItem[] tableItemArray = TableTreeViewer.this.tableTree.getTable().getItems();
                int n = 0;
                while (n < tableItemArray.length) {
                    Rectangle rectangle = tableItemArray[n].getImageBounds(0);
                    if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
                        return;
                    }
                    ++n;
                }
                TableTreeViewer.this.tableEditorImpl.handleMouseDown(mouseEvent);
            }
        });
    }

    @Override
    public boolean isCellEditorActive() {
        return this.tableEditorImpl.isCellEditorActive();
    }

    @Override
    protected Item newItem(Widget widget, int n, int n2) {
        TableTreeItem tableTreeItem = n2 >= 0 ? (widget instanceof TableTreeItem ? new TableTreeItem((TableTreeItem)widget, n, n2) : new TableTreeItem((TableTree)widget, n, n2)) : (widget instanceof TableTreeItem ? new TableTreeItem((TableTreeItem)widget, n) : new TableTreeItem((TableTree)widget, n));
        return tableTreeItem;
    }

    @Override
    protected void removeAll(Control control) {
        ((TableTree)control).removeAll();
    }

    @Override
    public void setCellEditors(CellEditor[] cellEditorArray) {
        this.tableEditorImpl.setCellEditors(cellEditorArray);
    }

    @Override
    public void setCellModifier(ICellModifier iCellModifier) {
        this.tableEditorImpl.setCellModifier(iCellModifier);
    }

    @Override
    public void setColumnProperties(String[] stringArray) {
        this.tableEditorImpl.setColumnProperties(stringArray);
    }

    @Override
    protected void setExpanded(Item item, boolean bl) {
        ((TableTreeItem)item).setExpanded(bl);
    }

    @Override
    protected void setSelection(List list) {
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[list.size()];
        list.toArray(tableTreeItemArray);
        this.getTableTree().setSelection(tableTreeItemArray);
    }

    @Override
    protected void showItem(Item item) {
        this.getTableTree().showItem((TableTreeItem)item);
    }

    class TableTreeEditorImpl {
        private CellEditor cellEditor;
        private CellEditor[] cellEditors;
        private ICellModifier cellModifier;
        private String[] columnProperties;
        private Item tableItem;
        private int columnNumber;
        private ICellEditorListener cellEditorListener;
        private FocusListener focusListener;
        private MouseListener mouseListener;
        private int doubleClickExpirationTime;
        private ColumnViewer viewer;

        private TableTreeEditorImpl(ColumnViewer columnViewer) {
            this.viewer = columnViewer;
            this.initCellEditorListener();
        }

        public ColumnViewer getViewer() {
            return this.viewer;
        }

        private void activateCellEditor() {
            String string;
            Object object;
            if (this.cellEditors != null && this.cellEditors[this.columnNumber] != null && this.cellModifier != null && this.cellModifier.canModify(object = this.tableItem.getData(), string = this.columnProperties[this.columnNumber])) {
                this.cellEditor = this.cellEditors[this.columnNumber];
                this.cellEditor.addListener(this.cellEditorListener);
                Object object2 = this.cellModifier.getValue(object, string);
                this.cellEditor.setValue(object2);
                final Control control = this.cellEditor.getControl();
                this.cellEditor.activate();
                if (control == null) {
                    return;
                }
                this.setLayoutData(this.cellEditor.getLayoutData());
                this.setEditor(control, this.tableItem, this.columnNumber);
                this.cellEditor.setFocus();
                if (this.focusListener == null) {
                    this.focusListener = new FocusAdapter(){

                        public void focusLost(FocusEvent focusEvent) {
                            TableTreeEditorImpl.this.applyEditorValue();
                        }
                    };
                }
                control.addFocusListener(this.focusListener);
                this.mouseListener = new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        if (mouseEvent.time <= TableTreeEditorImpl.this.doubleClickExpirationTime) {
                            control.removeMouseListener(TableTreeEditorImpl.this.mouseListener);
                            TableTreeEditorImpl.this.cancelEditing();
                            TableTreeEditorImpl.this.handleDoubleClickEvent();
                        } else if (TableTreeEditorImpl.this.mouseListener != null) {
                            control.removeMouseListener(TableTreeEditorImpl.this.mouseListener);
                        }
                    }
                };
                control.addMouseListener(this.mouseListener);
            }
        }

        private void activateCellEditor(MouseEvent mouseEvent) {
            int n;
            if (this.tableItem == null || this.tableItem.isDisposed()) {
                return;
            }
            int n2 = this.getColumnCount();
            if (n2 == 0) {
                n = 0;
            } else {
                n = -1;
                int n3 = 0;
                while (n3 < n2) {
                    Rectangle rectangle = this.getBounds(this.tableItem, n3);
                    if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
                        n = n3;
                        break;
                    }
                    ++n3;
                }
                if (n == -1) {
                    return;
                }
            }
            this.columnNumber = n;
            this.activateCellEditor();
        }

        public void applyEditorValue() {
            CellEditor cellEditor = this.cellEditor;
            if (cellEditor != null) {
                this.cellEditor = null;
                Item item = this.tableItem;
                if (item != null && !item.isDisposed()) {
                    this.saveEditorValue(cellEditor, item);
                }
                this.setEditor(null, null, 0);
                cellEditor.removeListener(this.cellEditorListener);
                Control control = cellEditor.getControl();
                if (control != null) {
                    if (this.mouseListener != null) {
                        control.removeMouseListener(this.mouseListener);
                    }
                    if (this.focusListener != null) {
                        control.removeFocusListener(this.focusListener);
                    }
                }
                cellEditor.deactivate();
            }
        }

        public void cancelEditing() {
            if (this.cellEditor != null) {
                this.setEditor(null, null, 0);
                this.cellEditor.removeListener(this.cellEditorListener);
                CellEditor cellEditor = this.cellEditor;
                this.cellEditor = null;
                cellEditor.deactivate();
            }
        }

        public void editElement(Object object, int n) {
            if (this.cellEditor != null) {
                this.applyEditorValue();
            }
            this.setSelection(new StructuredSelection(object), true);
            Item[] itemArray = this.getSelection();
            if (itemArray.length != 1) {
                return;
            }
            this.tableItem = itemArray[0];
            this.showSelection();
            this.columnNumber = n;
            this.activateCellEditor();
        }

        public CellEditor[] getCellEditors() {
            return this.cellEditors;
        }

        public ICellModifier getCellModifier() {
            return this.cellModifier;
        }

        public Object[] getColumnProperties() {
            return this.columnProperties;
        }

        public void handleMouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button != 1) {
                return;
            }
            if (this.cellEditor != null) {
                this.applyEditorValue();
            }
            this.doubleClickExpirationTime = mouseEvent.time + Display.getCurrent().getDoubleClickTime();
            Item[] itemArray = this.getSelection();
            if (itemArray.length != 1) {
                this.tableItem = null;
                return;
            }
            this.tableItem = itemArray[0];
            this.activateCellEditor(mouseEvent);
        }

        private void initCellEditorListener() {
            this.cellEditorListener = new ICellEditorListener(){

                @Override
                public void editorValueChanged(boolean bl, boolean bl2) {
                }

                @Override
                public void cancelEditor() {
                    TableTreeEditorImpl.this.cancelEditing();
                }

                @Override
                public void applyEditorValue() {
                    TableTreeEditorImpl.this.applyEditorValue();
                }
            };
        }

        public boolean isCellEditorActive() {
            return this.cellEditor != null;
        }

        private void saveEditorValue(CellEditor cellEditor, Item item) {
            if (this.cellModifier != null) {
                cellEditor.isValueValid();
            }
            String string = null;
            if (this.columnProperties != null && this.columnNumber < this.columnProperties.length) {
                string = this.columnProperties[this.columnNumber];
            }
            this.cellModifier.modify(item, string, cellEditor.getValue());
        }

        public void setCellEditors(CellEditor[] cellEditorArray) {
            this.cellEditors = cellEditorArray;
        }

        public void setCellModifier(ICellModifier iCellModifier) {
            this.cellModifier = iCellModifier;
        }

        public void setColumnProperties(String[] stringArray) {
            this.columnProperties = stringArray;
        }

        Rectangle getBounds(Item item, int n) {
            return ((TableTreeItem)item).getBounds(n);
        }

        int getColumnCount() {
            return TableTreeViewer.this.getTableTree().getTable().getColumnCount();
        }

        Item[] getSelection() {
            return TableTreeViewer.this.getTableTree().getSelection();
        }

        void setEditor(Control control, Item item, int n) {
            TableTreeViewer.this.tableTreeEditor.setEditor(control, (TableTreeItem)item, n);
        }

        void setSelection(StructuredSelection structuredSelection, boolean bl) {
            TableTreeViewer.this.setSelection(structuredSelection, bl);
        }

        void showSelection() {
            TableTreeViewer.this.getTableTree().showSelection();
        }

        void setLayoutData(CellEditor.LayoutData layoutData) {
            ((TableTreeViewer)TableTreeViewer.this).tableTreeEditor.horizontalAlignment = layoutData.horizontalAlignment;
            ((TableTreeViewer)TableTreeViewer.this).tableTreeEditor.grabHorizontal = layoutData.grabHorizontal;
            ((TableTreeViewer)TableTreeViewer.this).tableTreeEditor.minimumWidth = layoutData.minimumWidth;
        }

        void handleDoubleClickEvent() {
            ColumnViewer columnViewer = this.getViewer();
            TableTreeViewer.this.fireDoubleClick(new DoubleClickEvent(columnViewer, ((Viewer)columnViewer).getSelection()));
            TableTreeViewer.this.fireOpen(new OpenEvent(columnViewer, ((Viewer)columnViewer).getSelection()));
        }
    }
}

