/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TableLayout
extends Layout {
    private static int COLUMN_TRIM = Util.isWindows() ? 4 : (Util.isMac() ? 24 : 3);
    private List columns = new ArrayList();
    private boolean firstTime = true;

    public void addColumnData(ColumnLayoutData columnLayoutData) {
        this.columns.add(columnLayoutData);
    }

    public Point computeSize(Composite composite, int n, int n2, boolean bl) {
        if (n != -1 && n2 != -1) {
            return new Point(n, n2);
        }
        Table table = (Table)composite;
        table.setLayout(null);
        Point point = table.computeSize(n, n2, bl);
        table.setLayout((Layout)this);
        int n3 = 0;
        int n4 = this.columns.size();
        int n5 = 0;
        while (n5 < n4) {
            ColumnLayoutData columnLayoutData;
            ColumnLayoutData columnLayoutData2 = (ColumnLayoutData)this.columns.get(n5);
            if (columnLayoutData2 instanceof ColumnPixelData) {
                columnLayoutData = (ColumnPixelData)columnLayoutData2;
                n3 += columnLayoutData.width;
                if (columnLayoutData.addTrim) {
                    n3 += COLUMN_TRIM;
                }
            } else if (columnLayoutData2 instanceof ColumnWeightData) {
                columnLayoutData = (ColumnWeightData)columnLayoutData2;
                n3 += ((ColumnWeightData)columnLayoutData).minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++n5;
        }
        if (n3 > point.x) {
            point.x = n3;
        }
        return point;
    }

    public void layout(Composite composite, boolean bl) {
        int n;
        if (!this.firstTime) {
            return;
        }
        int n2 = composite.getClientArea().width;
        if (n2 <= 1) {
            return;
        }
        Item[] itemArray = this.getColumns(composite);
        int n3 = Math.min(this.columns.size(), itemArray.length);
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            ColumnLayoutData columnLayoutData;
            ColumnLayoutData columnLayoutData2 = (ColumnLayoutData)this.columns.get(n7);
            if (columnLayoutData2 instanceof ColumnPixelData) {
                columnLayoutData = (ColumnPixelData)columnLayoutData2;
                n = columnLayoutData.width;
                if (columnLayoutData.addTrim) {
                    n += COLUMN_TRIM;
                }
                nArray[n7] = n;
                n4 += n;
            } else if (columnLayoutData2 instanceof ColumnWeightData) {
                columnLayoutData = (ColumnWeightData)columnLayoutData2;
                ++n5;
                n = ((ColumnWeightData)columnLayoutData).weight;
                n6 += n;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++n7;
        }
        if (n5 > 0) {
            ColumnLayoutData columnLayoutData;
            n7 = n2 - n4;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n3) {
                ColumnLayoutData columnLayoutData3 = (ColumnLayoutData)this.columns.get(n9);
                if (columnLayoutData3 instanceof ColumnWeightData) {
                    int n10;
                    columnLayoutData = (ColumnWeightData)columnLayoutData3;
                    int n11 = columnLayoutData.weight;
                    int n12 = n10 = n6 == 0 ? 0 : n11 * n7 / n6;
                    if (n10 < columnLayoutData.minimumWidth) {
                        n10 = columnLayoutData.minimumWidth;
                    }
                    n8 += n10;
                    nArray[n9] = n10;
                }
                ++n9;
            }
            n9 = n7 - n8;
            n = 0;
            while (n9 > 0) {
                if (n == n3) {
                    n = 0;
                }
                if ((columnLayoutData = (ColumnLayoutData)this.columns.get(n)) instanceof ColumnWeightData) {
                    int n13 = n;
                    nArray[n13] = nArray[n13] + 1;
                    --n9;
                }
                ++n;
            }
        }
        this.firstTime = false;
        n7 = 0;
        while (n7 < n3) {
            this.setWidth(itemArray[n7], nArray[n7]);
            ++n7;
        }
    }

    private void setWidth(Item item, int n) {
        if (item instanceof TreeColumn) {
            ((TreeColumn)item).setWidth(n);
        } else {
            ((TableColumn)item).setWidth(n);
        }
    }

    private Item[] getColumns(Composite composite) {
        if (composite instanceof Tree) {
            return ((Tree)composite).getColumns();
        }
        return ((Table)composite).getColumns();
    }
}

