/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;

public class StyledString {
    public static final Styler QUALIFIER_STYLER = StyledString.createColorRegistryStyler("QUALIFIER_COLOR", null);
    public static final Styler COUNTER_STYLER = StyledString.createColorRegistryStyler("COUNTER_COLOR", null);
    public static final Styler DECORATIONS_STYLER = StyledString.createColorRegistryStyler("DECORATIONS_COLOR", null);
    private static final StyleRange[] EMPTY = new StyleRange[0];
    private StringBuffer fBuffer = new StringBuffer();
    private StyleRunList fStyleRuns = null;

    public static Styler createColorRegistryStyler(String string, String string2) {
        return new DefaultStyler(string, string2);
    }

    public StyledString() {
    }

    public StyledString(String string) {
        this(string, null);
    }

    public StyledString(String string, Styler styler) {
        this();
        this.append(string, styler);
    }

    public String getString() {
        return this.fBuffer.toString();
    }

    public String toString() {
        return this.getString();
    }

    public int length() {
        return this.fBuffer.length();
    }

    public StyledString append(String string) {
        return this.append(string, null);
    }

    public StyledString append(char[] cArray) {
        return this.append(cArray, null);
    }

    public StyledString append(char c) {
        return this.append(String.valueOf(c), null);
    }

    public StyledString append(StyledString styledString) {
        if (styledString.length() == 0) {
            return this;
        }
        int n = this.fBuffer.length();
        this.fBuffer.append(styledString.toString());
        StyleRunList styleRunList = styledString.fStyleRuns;
        if (styleRunList != null && !styleRunList.isEmpty()) {
            int n2 = 0;
            while (n2 < styleRunList.size()) {
                StyleRun styleRun = (StyleRun)styleRunList.get(n2);
                if (n2 == 0 && styleRun.offset != 0) {
                    this.appendStyleRun(null, n);
                }
                this.appendStyleRun(styleRun.style, n + styleRun.offset);
                ++n2;
            }
        } else {
            this.appendStyleRun(null, n);
        }
        return this;
    }

    public StyledString append(char c, Styler styler) {
        return this.append(String.valueOf(c), styler);
    }

    public StyledString append(String string, Styler styler) {
        if (string.length() == 0) {
            return this;
        }
        int n = this.fBuffer.length();
        this.fBuffer.append(string);
        this.appendStyleRun(styler, n);
        return this;
    }

    public StyledString append(char[] cArray, Styler styler) {
        if (cArray.length == 0) {
            return this;
        }
        int n = this.fBuffer.length();
        this.fBuffer.append(cArray);
        this.appendStyleRun(styler, n);
        return this;
    }

    public StyledString insert(char c, int n) throws StringIndexOutOfBoundsException {
        if (n < 0 || n > this.fBuffer.length()) {
            throw new StringIndexOutOfBoundsException("Invalid offset (" + n + ")");
        }
        if (this.hasRuns()) {
            int n2 = this.findRun(n);
            n2 = n2 < 0 ? -n2 - 1 : ++n2;
            StyleRunList styleRunList = this.getStyleRuns();
            int n3 = styleRunList.size();
            int n4 = n2;
            while (n4 < n3) {
                StyleRun styleRun = styleRunList.getRun(n4);
                ++styleRun.offset;
                ++n4;
            }
        }
        this.fBuffer.insert(n, c);
        return this;
    }

    public void setStyle(int n, int n2, Styler styler) throws StringIndexOutOfBoundsException {
        int n3;
        if (n < 0 || n + n2 > this.fBuffer.length()) {
            throw new StringIndexOutOfBoundsException("Invalid offset (" + n + ") or length (" + n2 + ")");
        }
        if (n2 == 0) {
            return;
        }
        StyleRun styleRun = this.getLastRun();
        if (styleRun == null || styleRun.offset <= n) {
            Styler styler2 = styleRun == null ? null : styleRun.style;
            this.appendStyleRun(styler, n);
            if (n + n2 != this.fBuffer.length()) {
                this.appendStyleRun(styler2, n + n2);
            }
            return;
        }
        int n4 = this.findRun(n + n2);
        if (n4 < 0) {
            n4 = -(n4 + 1);
            if (n + n2 < this.fBuffer.length()) {
                Styler styler3 = n4 > 0 ? this.fStyleRuns.getRun((int)(n4 - 1)).style : null;
                this.fStyleRuns.add(n4, new StyleRun(n + n2, styler3));
            }
        }
        if ((n3 = this.findRun(n)) >= 0) {
            StyleRun styleRun2 = this.fStyleRuns.getRun(n3);
            styleRun2.style = styler;
        } else {
            Styler styler4;
            Styler styler5 = styler4 = (n3 = -(n3 + 1)) > 0 ? this.fStyleRuns.getRun((int)(n3 - 1)).style : null;
            if (this.isDifferentStyle(styler4, styler) || n3 == 0 && styler != null) {
                this.fStyleRuns.add(n3, new StyleRun(n, styler));
                ++n4;
            } else {
                --n3;
            }
        }
        if (n3 + 1 < n4) {
            this.fStyleRuns.removeRange(n3 + 1, n4);
        }
    }

    public StyleRange[] getStyleRanges() {
        if (this.hasRuns()) {
            ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
            StyleRunList styleRunList = this.getStyleRuns();
            int n = 0;
            Styler styler = null;
            int n2 = 0;
            while (n2 < styleRunList.size()) {
                StyleRun styleRun = (StyleRun)styleRunList.get(n2);
                if (this.isDifferentStyle(styleRun.style, styler)) {
                    if (styleRun.offset > n && styler != null) {
                        arrayList.add(this.createStyleRange(n, styleRun.offset, styler));
                    }
                    n = styleRun.offset;
                    styler = styleRun.style;
                }
                ++n2;
            }
            if (this.fBuffer.length() > n && styler != null) {
                arrayList.add(this.createStyleRange(n, this.fBuffer.length(), styler));
            }
            return arrayList.toArray(new StyleRange[arrayList.size()]);
        }
        return EMPTY;
    }

    private int findRun(int n) {
        int n2 = 0;
        int n3 = this.fStyleRuns.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            StyleRun styleRun = this.fStyleRuns.getRun(n4);
            if (styleRun.offset < n) {
                n2 = n4 + 1;
                continue;
            }
            if (styleRun.offset > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    private StyleRange createStyleRange(int n, int n2, Styler styler) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = n;
        styleRange.length = n2 - n;
        styler.applyStyles((TextStyle)styleRange);
        return styleRange;
    }

    private boolean hasRuns() {
        return this.fStyleRuns != null && !this.fStyleRuns.isEmpty();
    }

    private void appendStyleRun(Styler styler, int n) {
        StyleRun styleRun = this.getLastRun();
        if (styleRun != null && styleRun.offset == n) {
            styleRun.style = styler;
            return;
        }
        if (styleRun == null && styler != null || styleRun != null && this.isDifferentStyle(styler, styleRun.style)) {
            this.getStyleRuns().add(new StyleRun(n, styler));
        }
    }

    private boolean isDifferentStyle(Styler styler, Styler styler2) {
        if (styler == null) {
            return styler2 != null;
        }
        return !styler.equals(styler2);
    }

    private StyleRun getLastRun() {
        if (this.fStyleRuns == null || this.fStyleRuns.isEmpty()) {
            return null;
        }
        return this.fStyleRuns.getRun(this.fStyleRuns.size() - 1);
    }

    private StyleRunList getStyleRuns() {
        if (this.fStyleRuns == null) {
            this.fStyleRuns = new StyleRunList();
        }
        return this.fStyleRuns;
    }

    private static class DefaultStyler
    extends Styler {
        private final String fForegroundColorName;
        private final String fBackgroundColorName;

        public DefaultStyler(String string, String string2) {
            this.fForegroundColorName = string;
            this.fBackgroundColorName = string2;
        }

        @Override
        public void applyStyles(TextStyle textStyle) {
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            if (this.fForegroundColorName != null) {
                textStyle.foreground = colorRegistry.get(this.fForegroundColorName);
            }
            if (this.fBackgroundColorName != null) {
                textStyle.background = colorRegistry.get(this.fBackgroundColorName);
            }
        }
    }

    private static class StyleRun {
        public int offset;
        public Styler style;

        public StyleRun(int n, Styler styler) {
            this.offset = n;
            this.style = styler;
        }

        public String toString() {
            return "Offset " + this.offset + ", style: " + this.style;
        }
    }

    private static class StyleRunList
    extends ArrayList {
        private static final long serialVersionUID = 123L;

        public StyleRunList() {
            super(3);
        }

        public StyleRun getRun(int n) {
            return (StyleRun)this.get(n);
        }

        @Override
        public void removeRange(int n, int n2) {
            super.removeRange(n, n2);
        }
    }

    public static abstract class Styler {
        public abstract void applyStyles(TextStyle var1);
    }
}

