/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public abstract class StyledCellLabelProvider
extends OwnerDrawLabelProvider {
    public static final int COLORS_ON_SELECTION = 1;
    public static final int NO_FOCUS = 2;
    private static final int OWNER_DRAW_ENABLED = 16;
    private int style;
    private TextLayout cachedTextLayout;
    private ColumnViewer viewer;
    private ViewerColumn column;
    private int deltaOfLastMeasure;

    public StyledCellLabelProvider() {
        this(0);
    }

    public StyledCellLabelProvider(int n) {
        this.style = n & 3 | 0x10;
    }

    public boolean isOwnerDrawEnabled() {
        return (this.style & 0x10) != 0;
    }

    public void setOwnerDrawEnabled(boolean bl) {
        boolean bl2 = this.isOwnerDrawEnabled();
        if (bl2 != bl) {
            this.style = bl ? (this.style |= 0x10) : (this.style &= 0xFFFFFFEF);
            if (this.viewer != null) {
                this.setOwnerDrawEnabled(this.viewer, this.column, bl);
            }
        }
    }

    protected final ColumnViewer getViewer() {
        return this.viewer;
    }

    protected final ViewerColumn getColumn() {
        return this.column;
    }

    @Override
    public void initialize(ColumnViewer columnViewer, ViewerColumn viewerColumn) {
        Assert.isTrue((this.viewer == null && this.column == null ? 1 : 0) != 0, (String)"Label provider instance already in use");
        this.viewer = columnViewer;
        this.column = viewerColumn;
        super.initialize(columnViewer, viewerColumn, this.isOwnerDrawEnabled());
    }

    @Override
    public void dispose() {
        if (this.cachedTextLayout != null) {
            this.cachedTextLayout.dispose();
            this.cachedTextLayout = null;
        }
        this.viewer = null;
        this.column = null;
        super.dispose();
    }

    @Override
    public void update(ViewerCell viewerCell) {
        super.update(viewerCell);
    }

    private TextLayout getSharedTextLayout(Display display) {
        if (this.cachedTextLayout == null) {
            int n = this.viewer.getControl().getStyle() & 0x6000000;
            this.cachedTextLayout = new TextLayout((Device)display);
            this.cachedTextLayout.setOrientation(n);
        }
        return this.cachedTextLayout;
    }

    private boolean useColors(Event event) {
        return (event.detail & 2) == 0 || (this.style & 1) != 0;
    }

    private boolean drawFocus(Event event) {
        return (event.detail & 4) != 0 && (this.style & 2) == 0;
    }

    protected StyleRange prepareStyleRange(StyleRange styleRange, boolean bl) {
        if (!(bl || styleRange.foreground == null && styleRange.background == null)) {
            styleRange = (StyleRange)styleRange.clone();
            if (!bl) {
                styleRange.foreground = null;
                styleRange.background = null;
            }
        }
        return styleRange;
    }

    private ViewerCell getViewerCell(Event event, Object object) {
        ViewerRow viewerRow = this.viewer.getViewerRowFromItem(event.item);
        return new ViewerCell(viewerRow, event.index, object);
    }

    @Override
    protected void erase(Event event, Object object) {
        if (this.isOwnerDrawEnabled()) {
            event.detail &= 0xFFFFFFEF;
        }
    }

    @Override
    protected void measure(Event event, Object object) {
        if (!this.isOwnerDrawEnabled()) {
            return;
        }
        ViewerCell viewerCell = this.getViewerCell(event, object);
        boolean bl = this.useColors(event);
        TextLayout textLayout = this.getSharedTextLayout(event.display);
        int n = this.deltaOfLastMeasure = this.updateTextLayout(textLayout, viewerCell, bl);
        event.width += n;
    }

    private int updateTextLayout(TextLayout textLayout, ViewerCell viewerCell, boolean bl) {
        int n;
        textLayout.setStyle(null, 0, Integer.MAX_VALUE);
        textLayout.setText(viewerCell.getText());
        textLayout.setFont(viewerCell.getFont());
        int n2 = textLayout.getBounds().width;
        boolean bl2 = false;
        StyleRange[] styleRangeArray = viewerCell.getStyleRanges();
        if (styleRangeArray != null) {
            n = 0;
            while (n < styleRangeArray.length) {
                StyleRange styleRange = this.prepareStyleRange(styleRangeArray[n], bl);
                textLayout.setStyle((TextStyle)styleRange, styleRange.start, styleRange.start + styleRange.length - 1);
                if (styleRange.font != null) {
                    bl2 = true;
                }
                ++n;
            }
        }
        n = 0;
        if (bl2) {
            n = textLayout.getBounds().width - n2;
        }
        return n;
    }

    @Override
    protected void paint(Event event, Object object) {
        int n;
        Rectangle rectangle;
        Color color;
        Color color2;
        if (!this.isOwnerDrawEnabled()) {
            return;
        }
        ViewerCell viewerCell = this.getViewerCell(event, object);
        boolean bl = this.useColors(event);
        GC gC = event.gc;
        Color color3 = gC.getForeground();
        Color color4 = gC.getBackground();
        if (bl) {
            color2 = viewerCell.getForeground();
            if (color2 != null) {
                gC.setForeground(color2);
            }
            if ((color = viewerCell.getBackground()) != null) {
                gC.setBackground(color);
            }
        }
        if ((color2 = viewerCell.getImage()) != null && (color = viewerCell.getImageBounds()) != null) {
            rectangle = color2.getBounds();
            int n2 = color.x + Math.max(0, (color.width - rectangle.width) / 2);
            n = color.y + Math.max(0, (color.height - rectangle.height) / 2);
            gC.drawImage((Image)color2, n2, n);
        }
        if ((color = viewerCell.getTextBounds()) != null) {
            rectangle = this.getSharedTextLayout(event.display);
            Rectangle rectangle2 = rectangle.getBounds();
            n = color.x;
            int n3 = color.y + Math.max(0, (color.height - rectangle2.height) / 2);
            rectangle.draw(gC, n, n3);
        }
        if (this.drawFocus(event)) {
            rectangle = viewerCell.getViewerRow().getBounds();
            gC.drawFocus(rectangle.x, rectangle.y, rectangle.width + this.deltaOfLastMeasure, rectangle.height);
        }
        if (bl) {
            gC.setForeground(color3);
            gC.setBackground(color4);
        }
    }

    public static StyledString styleDecoratedString(String string, StyledString.Styler styler, StyledString styledString) {
        String string2 = styledString.getString();
        int n = string.indexOf(string2);
        if (n == -1) {
            return new StyledString(string);
        }
        if (string.length() == string2.length()) {
            return styledString;
        }
        if (n > 0) {
            StyledString styledString2 = new StyledString(string.substring(0, n), styler);
            styledString2.append(styledString);
            styledString = styledString2;
        }
        if (string.length() > n + string2.length()) {
            return styledString.append(string.substring(n + string2.length()), styler);
        }
        return styledString;
    }
}

