/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;

public class StructuredSelection
implements IStructuredSelection {
    private Object[] elements;
    private IElementComparer comparer;
    public static final StructuredSelection EMPTY = new StructuredSelection();

    public StructuredSelection() {
    }

    public StructuredSelection(Object[] objectArray) {
        Assert.isNotNull((Object)objectArray);
        this.elements = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
    }

    public StructuredSelection(Object object) {
        Assert.isNotNull((Object)object);
        this.elements = new Object[]{object};
    }

    public StructuredSelection(List list) {
        this(list, null);
    }

    public StructuredSelection(List list, IElementComparer iElementComparer) {
        Assert.isNotNull((Object)list);
        this.elements = list.toArray();
        this.comparer = iElementComparer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection structuredSelection = (StructuredSelection)object;
        if (this.isEmpty()) {
            return structuredSelection.isEmpty();
        }
        if (structuredSelection.isEmpty()) {
            return false;
        }
        boolean bl = this.comparer != null && this.comparer == structuredSelection.comparer;
        int n = this.elements.length;
        if (n != structuredSelection.elements.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (bl ? !this.comparer.equals(this.elements[n2], structuredSelection.elements[n2]) : !this.elements[n2].equals(structuredSelection.elements[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Object getFirstElement() {
        return this.isEmpty() ? null : this.elements[0];
    }

    @Override
    public boolean isEmpty() {
        return this.elements == null || this.elements.length == 0;
    }

    @Override
    public Iterator iterator() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements).iterator();
    }

    @Override
    public int size() {
        return this.elements == null ? 0 : this.elements.length;
    }

    @Override
    public Object[] toArray() {
        return this.elements == null ? new Object[]{} : (Object[])this.elements.clone();
    }

    @Override
    public List toList() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements);
    }

    public String toString() {
        return this.isEmpty() ? JFaceResources.getString("<empty_selection>") : this.toList().toString();
    }
}

