/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class OwnerDrawLabelProvider
extends CellLabelProvider {
    private static final String OWNER_DRAW_LABEL_PROVIDER_LISTENER = "owner_draw_label_provider_listener";

    public static void setUpOwnerDraw(ColumnViewer columnViewer) {
        ++OwnerDrawLabelProvider.getOrCreateOwnerDrawListener((ColumnViewer)columnViewer).enabledGlobally;
    }

    private static OwnerDrawListener getOrCreateOwnerDrawListener(ColumnViewer columnViewer) {
        Control control = columnViewer.getControl();
        OwnerDrawListener ownerDrawListener = (OwnerDrawListener)control.getData(OWNER_DRAW_LABEL_PROVIDER_LISTENER);
        if (ownerDrawListener == null) {
            ownerDrawListener = new OwnerDrawListener(columnViewer);
            control.setData(OWNER_DRAW_LABEL_PROVIDER_LISTENER, (Object)ownerDrawListener);
            control.addListener(41, (Listener)ownerDrawListener);
            control.addListener(40, (Listener)ownerDrawListener);
            control.addListener(42, (Listener)ownerDrawListener);
        }
        return ownerDrawListener;
    }

    @Override
    public void dispose(ColumnViewer columnViewer, ViewerColumn viewerColumn) {
        if (!columnViewer.getControl().isDisposed()) {
            this.setOwnerDrawEnabled(columnViewer, viewerColumn, false);
        }
        super.dispose(columnViewer, viewerColumn);
    }

    @Override
    protected void initialize(ColumnViewer columnViewer, ViewerColumn viewerColumn) {
        this.initialize(columnViewer, viewerColumn, true);
    }

    protected final void initialize(ColumnViewer columnViewer, ViewerColumn viewerColumn, boolean bl) {
        super.initialize(columnViewer, viewerColumn);
        this.setOwnerDrawEnabled(columnViewer, viewerColumn, bl);
    }

    @Override
    public void update(ViewerCell viewerCell) {
        Rectangle rectangle = viewerCell.getBounds();
        viewerCell.getControl().redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    protected void erase(Event event, Object object) {
        Rectangle rectangle = event.getBounds();
        if ((event.detail & 2) != 0) {
            Color color = event.gc.getForeground();
            Color color2 = event.gc.getBackground();
            event.gc.setBackground(event.item.getDisplay().getSystemColor(26));
            event.gc.setForeground(event.item.getDisplay().getSystemColor(27));
            event.gc.fillRectangle(rectangle);
            event.gc.setForeground(color);
            event.gc.setBackground(color2);
            event.detail &= 0xFFFFFFFD;
        }
    }

    protected abstract void measure(Event var1, Object var2);

    protected abstract void paint(Event var1, Object var2);

    protected void setOwnerDrawEnabled(ColumnViewer columnViewer, ViewerColumn viewerColumn, boolean bl) {
        if (bl) {
            OwnerDrawListener ownerDrawListener = OwnerDrawLabelProvider.getOrCreateOwnerDrawListener(columnViewer);
            if (viewerColumn == null) {
                ++ownerDrawListener.enabledGlobally;
            } else {
                ownerDrawListener.enabledColumns.add(viewerColumn);
            }
        } else {
            OwnerDrawListener ownerDrawListener = (OwnerDrawListener)columnViewer.getControl().getData(OWNER_DRAW_LABEL_PROVIDER_LISTENER);
            if (ownerDrawListener != null) {
                if (viewerColumn == null) {
                    --ownerDrawListener.enabledGlobally;
                } else {
                    ownerDrawListener.enabledColumns.remove(viewerColumn);
                }
                if (ownerDrawListener.enabledColumns.isEmpty() && ownerDrawListener.enabledGlobally <= 0) {
                    columnViewer.getControl().removeListener(41, (Listener)ownerDrawListener);
                    columnViewer.getControl().removeListener(40, (Listener)ownerDrawListener);
                    columnViewer.getControl().removeListener(42, (Listener)ownerDrawListener);
                    columnViewer.getControl().setData(OWNER_DRAW_LABEL_PROVIDER_LISTENER, null);
                }
            }
        }
    }

    static class OwnerDrawListener
    implements Listener {
        Set enabledColumns = new HashSet();
        int enabledGlobally = 0;
        private ColumnViewer viewer;

        OwnerDrawListener(ColumnViewer columnViewer) {
            this.viewer = columnViewer;
        }

        public void handleEvent(Event event) {
            CellLabelProvider cellLabelProvider;
            ViewerColumn viewerColumn = this.viewer.getViewerColumn(event.index);
            if (viewerColumn != null && (this.enabledGlobally > 0 || this.enabledColumns.contains(viewerColumn)) && (cellLabelProvider = viewerColumn.getLabelProvider()) instanceof OwnerDrawLabelProvider) {
                Object object = event.item.getData();
                OwnerDrawLabelProvider ownerDrawLabelProvider = (OwnerDrawLabelProvider)cellLabelProvider;
                switch (event.type) {
                    case 41: {
                        ownerDrawLabelProvider.measure(event, object);
                        break;
                    }
                    case 42: {
                        ownerDrawLabelProvider.paint(event, object);
                        break;
                    }
                    case 40: {
                        ownerDrawLabelProvider.erase(event, object);
                    }
                }
            }
        }
    }
}

