/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ListViewer
extends AbstractListViewer {
    private org.eclipse.swt.widgets.List list;

    public ListViewer(Composite composite) {
        this(composite, 2818);
    }

    public ListViewer(Composite composite, int n) {
        this(new org.eclipse.swt.widgets.List(composite, n));
    }

    public ListViewer(org.eclipse.swt.widgets.List list) {
        this.list = list;
        this.hookControl((Control)list);
    }

    @Override
    public Control getControl() {
        return this.list;
    }

    public org.eclipse.swt.widgets.List getList() {
        return this.list;
    }

    @Override
    public void reveal(Object object) {
        Assert.isNotNull((Object)object);
        int n = this.getElementIndex(object);
        if (n == -1) {
            return;
        }
        int n2 = this.list.getItemCount();
        if (n2 == 0) {
            return;
        }
        int n3 = this.list.getItemHeight();
        Rectangle rectangle = this.list.getClientArea();
        int n4 = this.list.getTopIndex();
        int n5 = Math.max(rectangle.height / n3, 1);
        int n6 = Math.min(n4 + n5, n2) - 1;
        if (n4 <= n && n <= n6) {
            return;
        }
        int n7 = Math.min(Math.max(n - n5 / 2, 0), n2 - 1);
        this.list.setTopIndex(n7);
    }

    @Override
    protected void listAdd(String string, int n) {
        this.list.add(string, n);
    }

    @Override
    protected void listSetItem(int n, String string) {
        this.list.setItem(n, string);
    }

    @Override
    protected int[] listGetSelectionIndices() {
        return this.list.getSelectionIndices();
    }

    @Override
    protected int listGetItemCount() {
        return this.list.getItemCount();
    }

    @Override
    protected void listSetItems(String[] stringArray) {
        this.list.setItems(stringArray);
    }

    @Override
    protected void listRemoveAll() {
        this.list.removeAll();
    }

    @Override
    protected void listRemove(int n) {
        this.list.remove(n);
    }

    @Override
    protected void listSetSelection(int[] nArray) {
        this.list.setSelection(nArray);
    }

    @Override
    protected void listDeselectAll() {
        this.list.deselectAll();
    }

    @Override
    protected void listShowSelection() {
        this.list.showSelection();
    }

    @Override
    protected int listGetTopIndex() {
        return this.list.getTopIndex();
    }

    @Override
    protected void listSetTopIndex(int n) {
        this.list.setTopIndex(n);
    }

    @Override
    protected void setSelectionToWidget(List list, boolean bl) {
        if (bl) {
            super.setSelectionToWidget(list, bl);
        } else if (list == null || list.size() == 0) {
            this.list.deselectAll();
        } else {
            int n = list.size();
            int[] nArray = new int[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Object e = list.get(n3);
                int n4 = this.getElementIndex(e);
                if (n4 >= 0) {
                    nArray[n2++] = n4;
                }
                ++n3;
            }
            if (n2 < n) {
                int[] nArray2 = nArray;
                nArray = new int[n2];
                System.arraycopy(nArray2, 0, nArray, 0, n2);
            }
            this.list.deselectAll();
            this.list.select(nArray);
        }
    }
}

