/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FocusCellOwnerDrawHighlighter
extends FocusCellHighlighter {
    public FocusCellOwnerDrawHighlighter(ColumnViewer columnViewer) {
        super(columnViewer);
        this.hookListener(columnViewer);
    }

    private void markFocusedCell(Event event, ViewerCell viewerCell) {
        Color color;
        Color color2 = viewerCell.getControl().isFocusControl() ? this.getSelectedCellBackgroundColor(viewerCell) : this.getSelectedCellBackgroundColorNoFocus(viewerCell);
        Color color3 = color = viewerCell.getControl().isFocusControl() ? this.getSelectedCellForegroundColor(viewerCell) : this.getSelectedCellForegroundColorNoFocus(viewerCell);
        if (color != null || color2 != null || this.onlyTextHighlighting(viewerCell)) {
            GC gC = event.gc;
            if (color2 == null) {
                color2 = viewerCell.getItem().getDisplay().getSystemColor(26);
            }
            if (color == null) {
                color = viewerCell.getItem().getDisplay().getSystemColor(27);
            }
            gC.setBackground(color2);
            gC.setForeground(color);
            if (this.onlyTextHighlighting(viewerCell)) {
                Rectangle rectangle = event.getBounds();
                Rectangle rectangle2 = viewerCell.getTextBounds();
                if (rectangle2 != null) {
                    rectangle.x = rectangle2.x;
                }
                gC.fillRectangle(rectangle);
            } else {
                gC.fillRectangle(event.getBounds());
            }
            event.detail &= 0xFFFFFFFD;
        }
    }

    private void removeSelectionInformation(Event event, ViewerCell viewerCell) {
        GC gC = event.gc;
        gC.setBackground(viewerCell.getViewerRow().getBackground(viewerCell.getColumnIndex()));
        gC.setForeground(viewerCell.getViewerRow().getForeground(viewerCell.getColumnIndex()));
        gC.fillRectangle(viewerCell.getBounds());
        event.detail &= 0xFFFFFFFD;
    }

    private void hookListener(final ColumnViewer columnViewer) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) > 0) {
                    ViewerCell viewerCell = FocusCellOwnerDrawHighlighter.this.getFocusCell();
                    ViewerRow viewerRow = columnViewer.getViewerRowFromItem(event.item);
                    Assert.isNotNull((Object)viewerRow, (String)"Internal structure invalid. Item without associated row is not possible.");
                    ViewerCell viewerCell2 = viewerRow.getCell(event.index);
                    if (viewerCell == null || !viewerCell2.equals(viewerCell)) {
                        FocusCellOwnerDrawHighlighter.this.removeSelectionInformation(event, viewerCell2);
                    } else {
                        FocusCellOwnerDrawHighlighter.this.markFocusedCell(event, viewerCell2);
                    }
                }
            }
        };
        columnViewer.getControl().addListener(40, listener);
    }

    protected Color getSelectedCellBackgroundColor(ViewerCell viewerCell) {
        return null;
    }

    protected Color getSelectedCellForegroundColor(ViewerCell viewerCell) {
        return null;
    }

    protected Color getSelectedCellForegroundColorNoFocus(ViewerCell viewerCell) {
        return null;
    }

    protected Color getSelectedCellBackgroundColorNoFocus(ViewerCell viewerCell) {
        return null;
    }

    protected boolean onlyTextHighlighting(ViewerCell viewerCell) {
        return false;
    }

    @Override
    protected void focusCellChanged(ViewerCell viewerCell, ViewerCell viewerCell2) {
        int n;
        int n2;
        Rectangle rectangle;
        super.focusCellChanged(viewerCell, viewerCell2);
        if (viewerCell != null) {
            rectangle = viewerCell.getBounds();
            n2 = viewerCell.getColumnIndex() == 0 ? 0 : rectangle.x;
            n = viewerCell.getColumnIndex() == 0 ? rectangle.x + rectangle.width : rectangle.width;
            viewerCell.getControl().redraw(n2, rectangle.y - 1, n, rectangle.height + 1, true);
        }
        if (viewerCell2 != null) {
            rectangle = viewerCell2.getBounds();
            n2 = viewerCell2.getColumnIndex() == 0 ? 0 : rectangle.x;
            n = viewerCell2.getColumnIndex() == 0 ? rectangle.x + rectangle.width : rectangle.width;
            viewerCell2.getControl().redraw(n2, rectangle.y - 1, n, rectangle.height + 1, true);
        }
    }
}

