/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Arrays;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DelegatingStyledCellLabelProvider
extends StyledCellLabelProvider {
    private IStyledLabelProvider styledLabelProvider;

    public DelegatingStyledCellLabelProvider(IStyledLabelProvider iStyledLabelProvider) {
        if (iStyledLabelProvider == null) {
            throw new IllegalArgumentException("Label provider must not be null");
        }
        this.styledLabelProvider = iStyledLabelProvider;
    }

    @Override
    public void update(ViewerCell viewerCell) {
        Object[] objectArray;
        Object object = viewerCell.getElement();
        StyledString styledString = this.getStyledText(object);
        String string = styledString.toString();
        Object[] objectArray2 = viewerCell.getStyleRanges();
        Object[] objectArray3 = objectArray = this.isOwnerDrawEnabled() ? styledString.getStyleRanges() : null;
        if (!Arrays.equals(objectArray2, objectArray)) {
            viewerCell.setStyleRanges((StyleRange[])objectArray);
            if (viewerCell.getText().equals(string)) {
                viewerCell.setText("");
            }
        }
        viewerCell.setText(string);
        viewerCell.setImage(this.getImage(object));
        viewerCell.setFont(this.getFont(object));
        viewerCell.setForeground(this.getForeground(object));
        viewerCell.setBackground(this.getBackground(object));
    }

    public Color getForeground(Object object) {
        if (this.styledLabelProvider instanceof IColorProvider) {
            return ((IColorProvider)((Object)this.styledLabelProvider)).getForeground(object);
        }
        return null;
    }

    public Color getBackground(Object object) {
        if (this.styledLabelProvider instanceof IColorProvider) {
            return ((IColorProvider)((Object)this.styledLabelProvider)).getBackground(object);
        }
        return null;
    }

    public Font getFont(Object object) {
        if (this.styledLabelProvider instanceof IFontProvider) {
            return ((IFontProvider)((Object)this.styledLabelProvider)).getFont(object);
        }
        return null;
    }

    public Image getImage(Object object) {
        return this.styledLabelProvider.getImage(object);
    }

    protected StyledString getStyledText(Object object) {
        return this.styledLabelProvider.getStyledText(object);
    }

    public IStyledLabelProvider getStyledStringProvider() {
        return this.styledLabelProvider;
    }

    @Override
    public void addListener(ILabelProviderListener iLabelProviderListener) {
        super.addListener(iLabelProviderListener);
        this.styledLabelProvider.addListener(iLabelProviderListener);
    }

    @Override
    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        super.removeListener(iLabelProviderListener);
        this.styledLabelProvider.removeListener(iLabelProviderListener);
    }

    @Override
    public boolean isLabelProperty(Object object, String string) {
        return this.styledLabelProvider.isLabelProperty(object, string);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.styledLabelProvider.dispose();
    }

    public static interface IStyledLabelProvider
    extends IBaseLabelProvider {
        public StyledString getStyledText(Object var1);

        public Image getImage(Object var1);
    }
}

