/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DecorationOverlayIcon
extends CompositeImageDescriptor {
    private Image base;
    private ImageDescriptor[] overlays;
    private Point size;

    public DecorationOverlayIcon(Image image, ImageDescriptor[] imageDescriptorArray, Point point) {
        this.base = image;
        this.overlays = imageDescriptorArray;
        this.size = point;
    }

    public DecorationOverlayIcon(Image image, ImageDescriptor[] imageDescriptorArray) {
        this(image, imageDescriptorArray, new Point(image.getBounds().width, image.getBounds().height));
    }

    public DecorationOverlayIcon(Image image, ImageDescriptor imageDescriptor, int n) {
        this(image, DecorationOverlayIcon.createArrayFrom(imageDescriptor, n));
    }

    private static ImageDescriptor[] createArrayFrom(ImageDescriptor imageDescriptor, int n) {
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[n] = imageDescriptor;
        return imageDescriptorArray;
    }

    private void drawOverlays(ImageDescriptor[] imageDescriptorArray) {
        int n = 0;
        while (n < this.overlays.length) {
            ImageDescriptor imageDescriptor = imageDescriptorArray[n];
            if (imageDescriptor != null) {
                ImageData imageData = imageDescriptor.getImageData();
                if (imageData == null) {
                    imageData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (n) {
                    case 0: {
                        this.drawImage(imageData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(imageData, this.size.x - imageData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(imageData, 0, this.size.y - imageData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(imageData, this.size.x - imageData.width, this.size.y - imageData.height);
                    }
                }
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecorationOverlayIcon)) {
            return false;
        }
        DecorationOverlayIcon decorationOverlayIcon = (DecorationOverlayIcon)object;
        return this.base.equals((Object)decorationOverlayIcon.base) && Arrays.equals(this.overlays, decorationOverlayIcon.overlays);
    }

    public int hashCode() {
        int n = System.identityHashCode(this.base);
        int n2 = 0;
        while (n2 < this.overlays.length) {
            if (this.overlays[n2] != null) {
                n ^= this.overlays[n2].hashCode();
            }
            ++n2;
        }
        return n;
    }

    @Override
    protected void drawCompositeImage(int n, int n2) {
        ImageDescriptor imageDescriptor;
        if (this.overlays.length > 4 && (imageDescriptor = this.overlays[4]) != null) {
            this.drawImage(imageDescriptor.getImageData(), 0, 0);
        }
        if (this.overlays.length > 5 && this.overlays[5] != null) {
            this.drawImage(this.overlays[5].getImageData(), 0, 0);
        } else {
            this.drawImage(this.base.getImageData(), 0, 0);
        }
        this.drawOverlays(this.overlays);
    }

    @Override
    protected Point getSize() {
        return this.size;
    }

    @Override
    protected int getTransparentPixel() {
        return this.base.getImageData().transparentPixel;
    }
}

