/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DecoratingStyledCellLabelProvider
extends DelegatingStyledCellLabelProvider {
    private ILabelDecorator decorator;
    private IDecorationContext decorationContext = DecorationContext.DEFAULT_CONTEXT;
    private ILabelProviderListener labelProviderListener;

    public DecoratingStyledCellLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider iStyledLabelProvider, ILabelDecorator iLabelDecorator, IDecorationContext iDecorationContext) {
        super(iStyledLabelProvider);
        this.decorator = iLabelDecorator;
        this.decorationContext = iDecorationContext != null ? iDecorationContext : DecorationContext.DEFAULT_CONTEXT;
        this.labelProviderListener = new ILabelProviderListener(){

            @Override
            public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
                DecoratingStyledCellLabelProvider.this.fireLabelProviderChanged(labelProviderChangedEvent);
            }
        };
        iStyledLabelProvider.addListener(this.labelProviderListener);
        if (iLabelDecorator != null) {
            iLabelDecorator.addListener(this.labelProviderListener);
        }
    }

    public IDecorationContext getDecorationContext() {
        return this.decorationContext;
    }

    public void setDecorationContext(IDecorationContext iDecorationContext) {
        Assert.isNotNull((Object)iDecorationContext);
        this.decorationContext = iDecorationContext;
    }

    private boolean waitForPendingDecoration(ViewerCell viewerCell) {
        if (this.decorator == null) {
            return false;
        }
        Object object = viewerCell.getElement();
        String string = viewerCell.getText();
        boolean bl = false;
        if (this.decorator instanceof LabelDecorator) {
            bl = !((LabelDecorator)this.decorator).prepareDecoration(object, string, this.getDecorationContext());
        } else if (this.decorator instanceof IDelayedLabelDecorator) {
            boolean bl2 = bl = !((IDelayedLabelDecorator)this.decorator).prepareDecoration(object, string);
        }
        if (bl && string.length() == 0) {
            return false;
        }
        return bl;
    }

    @Override
    public void update(ViewerCell viewerCell) {
        if (this.waitForPendingDecoration(viewerCell)) {
            return;
        }
        super.update(viewerCell);
    }

    @Override
    public Color getForeground(Object object) {
        Color color;
        if (this.decorator instanceof IColorDecorator && (color = ((IColorDecorator)((Object)this.decorator)).decorateForeground(object)) != null) {
            return color;
        }
        return super.getForeground(object);
    }

    @Override
    public Color getBackground(Object object) {
        Color color;
        if (this.decorator instanceof IColorDecorator && (color = ((IColorDecorator)((Object)this.decorator)).decorateBackground(object)) != null) {
            return color;
        }
        return super.getBackground(object);
    }

    @Override
    public Font getFont(Object object) {
        Font font;
        if (this.decorator instanceof IFontDecorator && (font = ((IFontDecorator)((Object)this.decorator)).decorateFont(object)) != null) {
            return font;
        }
        return super.getFont(object);
    }

    @Override
    public Image getImage(Object object) {
        Image image = super.getImage(object);
        if (this.decorator == null) {
            return image;
        }
        Image image2 = null;
        image2 = this.decorator instanceof LabelDecorator ? ((LabelDecorator)this.decorator).decorateImage(image, object, this.getDecorationContext()) : this.decorator.decorateImage(image, object);
        if (image2 != null) {
            return image2;
        }
        return image;
    }

    @Override
    protected StyledString getStyledText(Object object) {
        StyledString styledString = super.getStyledText(object);
        if (this.decorator == null) {
            return styledString;
        }
        String string = styledString.getString();
        String string2 = this.decorator instanceof LabelDecorator ? ((LabelDecorator)this.decorator).decorateText(string, object, this.getDecorationContext()) : this.decorator.decorateText(string, object);
        if (string2 == null) {
            return styledString;
        }
        StyledString.Styler styler = this.getDecorationStyle(object);
        return StyledCellLabelProvider.styleDecoratedString(string2, styler, styledString);
    }

    protected StyledString.Styler getDecorationStyle(Object object) {
        return StyledString.DECORATIONS_STYLER;
    }

    public ILabelDecorator getLabelDecorator() {
        return this.decorator;
    }

    public void setLabelDecorator(ILabelDecorator iLabelDecorator) {
        ILabelDecorator iLabelDecorator2 = this.decorator;
        if (iLabelDecorator2 != iLabelDecorator) {
            if (iLabelDecorator2 != null) {
                iLabelDecorator2.removeListener(this.labelProviderListener);
            }
            this.decorator = iLabelDecorator;
            if (iLabelDecorator != null) {
                iLabelDecorator.addListener(this.labelProviderListener);
            }
        }
        this.fireLabelProviderChanged(new LabelProviderChangedEvent(this));
    }

    @Override
    public void addListener(ILabelProviderListener iLabelProviderListener) {
        super.addListener(iLabelProviderListener);
        if (this.decorator != null) {
            this.decorator.addListener(this.labelProviderListener);
        }
    }

    @Override
    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        super.removeListener(iLabelProviderListener);
        if (this.decorator != null && !this.isListenerAttached()) {
            this.decorator.removeListener(this.labelProviderListener);
        }
    }

    @Override
    public boolean isLabelProperty(Object object, String string) {
        if (super.isLabelProperty(object, string)) {
            return true;
        }
        return this.decorator != null && this.decorator.isLabelProperty(object, string);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.decorator != null) {
            this.decorator.removeListener(this.labelProviderListener);
            this.decorator.dispose();
            this.decorator = null;
        }
    }
}

