/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DecoratingLabelProvider
extends LabelProvider
implements ILabelProvider,
IViewerLabelProvider,
IColorProvider,
IFontProvider,
ITreePathLabelProvider {
    private ILabelProvider provider;
    private ILabelDecorator decorator;
    private ListenerList listeners = new ListenerList();
    private IDecorationContext decorationContext = DecorationContext.DEFAULT_CONTEXT;

    public DecoratingLabelProvider(ILabelProvider iLabelProvider, ILabelDecorator iLabelDecorator) {
        Assert.isNotNull((Object)iLabelProvider);
        this.provider = iLabelProvider;
        this.decorator = iLabelDecorator;
    }

    @Override
    public void addListener(ILabelProviderListener iLabelProviderListener) {
        super.addListener(iLabelProviderListener);
        this.provider.addListener(iLabelProviderListener);
        if (this.decorator != null) {
            this.decorator.addListener(iLabelProviderListener);
        }
        this.listeners.add((Object)iLabelProviderListener);
    }

    @Override
    public void dispose() {
        this.provider.dispose();
        if (this.decorator != null) {
            this.decorator.dispose();
        }
    }

    @Override
    public Image getImage(Object object) {
        Image image = this.provider.getImage(object);
        if (this.decorator != null) {
            if (this.decorator instanceof LabelDecorator) {
                LabelDecorator labelDecorator = (LabelDecorator)this.decorator;
                Image image2 = labelDecorator.decorateImage(image, object, this.getDecorationContext());
                if (image2 != null) {
                    return image2;
                }
            } else {
                Image image3 = this.decorator.decorateImage(image, object);
                if (image3 != null) {
                    return image3;
                }
            }
        }
        return image;
    }

    public ILabelDecorator getLabelDecorator() {
        return this.decorator;
    }

    public ILabelProvider getLabelProvider() {
        return this.provider;
    }

    @Override
    public String getText(Object object) {
        String string = this.provider.getText(object);
        if (this.decorator != null) {
            if (this.decorator instanceof LabelDecorator) {
                LabelDecorator labelDecorator = (LabelDecorator)this.decorator;
                String string2 = labelDecorator.decorateText(string, object, this.getDecorationContext());
                if (string2 != null) {
                    return string2;
                }
            } else {
                String string3 = this.decorator.decorateText(string, object);
                if (string3 != null) {
                    return string3;
                }
            }
        }
        return string;
    }

    @Override
    public boolean isLabelProperty(Object object, String string) {
        if (this.provider.isLabelProperty(object, string)) {
            return true;
        }
        return this.decorator != null && this.decorator.isLabelProperty(object, string);
    }

    @Override
    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        super.removeListener(iLabelProviderListener);
        this.provider.removeListener(iLabelProviderListener);
        if (this.decorator != null) {
            this.decorator.removeListener(iLabelProviderListener);
        }
        this.listeners.remove((Object)iLabelProviderListener);
    }

    public void setLabelDecorator(ILabelDecorator iLabelDecorator) {
        ILabelDecorator iLabelDecorator2 = this.decorator;
        if (iLabelDecorator2 != iLabelDecorator) {
            int n;
            Object[] objectArray = this.listeners.getListeners();
            if (iLabelDecorator2 != null) {
                n = 0;
                while (n < objectArray.length) {
                    iLabelDecorator2.removeListener((ILabelProviderListener)objectArray[n]);
                    ++n;
                }
            }
            this.decorator = iLabelDecorator;
            if (iLabelDecorator != null) {
                n = 0;
                while (n < objectArray.length) {
                    iLabelDecorator.addListener((ILabelProviderListener)objectArray[n]);
                    ++n;
                }
            }
            this.fireLabelProviderChanged(new LabelProviderChangedEvent(this));
        }
    }

    @Override
    public void updateLabel(ViewerLabel viewerLabel, Object object) {
        IDelayedLabelDecorator iDelayedLabelDecorator;
        ILabelDecorator iLabelDecorator = this.getLabelDecorator();
        String string = viewerLabel.getText();
        boolean bl = true;
        if (iLabelDecorator instanceof IDelayedLabelDecorator && !(iDelayedLabelDecorator = (IDelayedLabelDecorator)iLabelDecorator).prepareDecoration(object, string)) {
            bl = false;
        }
        if (bl || string == null || viewerLabel.getText().length() == 0) {
            viewerLabel.setText(this.getText(object));
        }
        iDelayedLabelDecorator = viewerLabel.getImage();
        if (bl || iDelayedLabelDecorator == null) {
            viewerLabel.setImage(this.getImage(object));
        }
        if (bl) {
            this.updateForDecorationReady(viewerLabel, object);
        }
    }

    protected void updateForDecorationReady(ViewerLabel viewerLabel, Object object) {
        if (this.decorator instanceof IColorDecorator) {
            IColorDecorator iColorDecorator = (IColorDecorator)((Object)this.decorator);
            viewerLabel.setBackground(iColorDecorator.decorateBackground(object));
            viewerLabel.setForeground(iColorDecorator.decorateForeground(object));
        }
        if (this.decorator instanceof IFontDecorator) {
            viewerLabel.setFont(((IFontDecorator)((Object)this.decorator)).decorateFont(object));
        }
    }

    @Override
    public Color getBackground(Object object) {
        if (this.provider instanceof IColorProvider) {
            return ((IColorProvider)((Object)this.provider)).getBackground(object);
        }
        return null;
    }

    @Override
    public Font getFont(Object object) {
        if (this.provider instanceof IFontProvider) {
            return ((IFontProvider)((Object)this.provider)).getFont(object);
        }
        return null;
    }

    @Override
    public Color getForeground(Object object) {
        if (this.provider instanceof IColorProvider) {
            return ((IColorProvider)((Object)this.provider)).getForeground(object);
        }
        return null;
    }

    public IDecorationContext getDecorationContext() {
        return this.decorationContext;
    }

    public void setDecorationContext(IDecorationContext iDecorationContext) {
        Assert.isNotNull((Object)iDecorationContext);
        this.decorationContext = iDecorationContext;
    }

    @Override
    public void updateLabel(ViewerLabel viewerLabel, TreePath treePath) {
        IBaseLabelProvider iBaseLabelProvider;
        ILabelDecorator iLabelDecorator = this.getLabelDecorator();
        String string = viewerLabel.getText();
        Object object = treePath.getLastSegment();
        boolean bl = true;
        if (iLabelDecorator instanceof LabelDecorator) {
            iBaseLabelProvider = (LabelDecorator)iLabelDecorator;
            if (!((LabelDecorator)iBaseLabelProvider).prepareDecoration(object, string, this.getDecorationContext())) {
                bl = false;
            }
        } else if (iLabelDecorator instanceof IDelayedLabelDecorator && !(iBaseLabelProvider = (IDelayedLabelDecorator)iLabelDecorator).prepareDecoration(object, string)) {
            bl = false;
        }
        viewerLabel.setHasPendingDecorations(!bl);
        if (this.provider instanceof ITreePathLabelProvider) {
            iBaseLabelProvider = (ITreePathLabelProvider)((Object)this.provider);
            if (bl || string == null || viewerLabel.getText().length() == 0) {
                iBaseLabelProvider.updateLabel(viewerLabel, treePath);
                this.decorateSettings(viewerLabel, treePath);
            }
        } else {
            if (bl || string == null || viewerLabel.getText().length() == 0) {
                viewerLabel.setText(this.getText(object));
            }
            iBaseLabelProvider = viewerLabel.getImage();
            if (bl || iBaseLabelProvider == null) {
                viewerLabel.setImage(this.getImage(object));
            }
            if (bl) {
                this.updateForDecorationReady(viewerLabel, object);
            }
        }
    }

    private void decorateSettings(ViewerLabel viewerLabel, TreePath treePath) {
        Object object = treePath.getLastSegment();
        if (this.decorator != null) {
            Image image;
            String string;
            Object object2;
            if (this.decorator instanceof LabelDecorator) {
                object2 = (LabelDecorator)this.decorator;
                string = ((LabelDecorator)object2).decorateText(viewerLabel.getText(), object, this.getDecorationContext());
                if (string != null && string.length() > 0) {
                    viewerLabel.setText(string);
                }
                if ((image = ((LabelDecorator)object2).decorateImage(viewerLabel.getImage(), object, this.getDecorationContext())) != null) {
                    viewerLabel.setImage(image);
                }
            } else {
                object2 = this.decorator.decorateText(viewerLabel.getText(), object);
                if (object2 != null && ((String)object2).length() > 0) {
                    viewerLabel.setText((String)object2);
                }
                if ((string = this.decorator.decorateImage(viewerLabel.getImage(), object)) != null) {
                    viewerLabel.setImage((Image)string);
                }
            }
            if (this.decorator instanceof IColorDecorator) {
                object2 = (IColorDecorator)((Object)this.decorator);
                string = object2.decorateBackground(object);
                if (string != null) {
                    viewerLabel.setBackground((Color)string);
                }
                if ((image = object2.decorateForeground(object)) != null) {
                    viewerLabel.setForeground((Color)image);
                }
            }
            if (this.decorator instanceof IFontDecorator && (object2 = ((IFontDecorator)((Object)this.decorator)).decorateFont(object)) != null) {
                viewerLabel.setFont((Font)object2);
            }
        }
    }
}

