/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboViewer
extends AbstractListViewer {
    private Combo combo;
    private CCombo ccombo;

    public ComboViewer(Composite composite) {
        this(composite, 2056);
    }

    public ComboViewer(Composite composite, int n) {
        this(new Combo(composite, n));
    }

    public ComboViewer(Combo combo) {
        this.combo = combo;
        this.hookControl((Control)combo);
    }

    public ComboViewer(CCombo cCombo) {
        this.ccombo = cCombo;
        this.hookControl((Control)cCombo);
    }

    @Override
    protected void listAdd(String string, int n) {
        if (this.combo == null) {
            this.ccombo.add(string, n);
        } else {
            this.combo.add(string, n);
        }
    }

    @Override
    protected void listSetItem(int n, String string) {
        if (this.combo == null) {
            this.ccombo.setItem(n, string);
        } else {
            this.combo.setItem(n, string);
        }
    }

    @Override
    protected int[] listGetSelectionIndices() {
        if (this.combo == null) {
            return new int[]{this.ccombo.getSelectionIndex()};
        }
        return new int[]{this.combo.getSelectionIndex()};
    }

    @Override
    protected int listGetItemCount() {
        if (this.combo == null) {
            return this.ccombo.getItemCount();
        }
        return this.combo.getItemCount();
    }

    @Override
    protected void listSetItems(String[] stringArray) {
        if (this.combo == null) {
            this.ccombo.setItems(stringArray);
        } else {
            this.combo.setItems(stringArray);
        }
    }

    @Override
    protected void listRemoveAll() {
        if (this.combo == null) {
            this.ccombo.removeAll();
        } else {
            this.combo.removeAll();
        }
    }

    @Override
    protected void listRemove(int n) {
        if (this.combo == null) {
            this.ccombo.remove(n);
        } else {
            this.combo.remove(n);
        }
    }

    @Override
    public Control getControl() {
        if (this.combo == null) {
            return this.ccombo;
        }
        return this.combo;
    }

    public CCombo getCCombo() {
        Assert.isNotNull((Object)this.ccombo);
        return this.ccombo;
    }

    public Combo getCombo() {
        Assert.isNotNull((Object)this.combo);
        return this.combo;
    }

    @Override
    public void reveal(Object object) {
    }

    @Override
    protected void listSetSelection(int[] nArray) {
        if (this.combo == null) {
            int n = 0;
            while (n < nArray.length) {
                this.ccombo.select(nArray[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < nArray.length) {
                this.combo.select(nArray[n]);
                ++n;
            }
        }
    }

    @Override
    protected void listDeselectAll() {
        if (this.combo == null) {
            this.ccombo.deselectAll();
            this.ccombo.clearSelection();
        } else {
            this.combo.deselectAll();
            this.combo.clearSelection();
        }
    }

    @Override
    protected void listShowSelection() {
    }
}

