/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AbstractComboBoxCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBoxViewerCellEditor
extends AbstractComboBoxCellEditor {
    ComboViewer viewer;
    Object selectedValue;
    private static final int defaultStyle = 0;

    public ComboBoxViewerCellEditor(Composite composite) {
        this(composite, 0);
    }

    public ComboBoxViewerCellEditor(Composite composite, int n) {
        super(composite, n);
        this.setValueValid(true);
    }

    @Override
    protected Control createControl(Composite composite) {
        CCombo cCombo = new CCombo(composite, this.getStyle());
        cCombo.setFont(composite.getFont());
        this.viewer = new ComboViewer(cCombo);
        cCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ComboBoxViewerCellEditor.this.keyReleaseOccured(keyEvent);
            }
        });
        cCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ComboBoxViewerCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ISelection iSelection = ComboBoxViewerCellEditor.this.viewer.getSelection();
                ComboBoxViewerCellEditor.this.selectedValue = iSelection.isEmpty() ? null : ((IStructuredSelection)iSelection).getFirstElement();
            }
        });
        cCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        });
        cCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ComboBoxViewerCellEditor.this.focusLost();
            }
        });
        return cCombo;
    }

    @Override
    protected Object doGetValue() {
        return this.selectedValue;
    }

    @Override
    protected void doSetFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gC = new GC((Drawable)this.viewer.getControl());
            layoutData.minimumWidth = gC.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gC.dispose();
        }
        return layoutData;
    }

    @Override
    protected void doSetValue(Object object) {
        Assert.isTrue((this.viewer != null ? 1 : 0) != 0);
        this.selectedValue = object;
        if (object == null) {
            this.viewer.setSelection(StructuredSelection.EMPTY);
        } else {
            this.viewer.setSelection(new StructuredSelection(object));
        }
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        this.viewer.setLabelProvider(iBaseLabelProvider);
    }

    public void setContentProvider(IStructuredContentProvider iStructuredContentProvider) {
        this.viewer.setContentProvider(iStructuredContentProvider);
    }

    public void setContenProvider(IStructuredContentProvider iStructuredContentProvider) {
        this.viewer.setContentProvider(iStructuredContentProvider);
    }

    public void setInput(Object object) {
        this.viewer.setInput(object);
    }

    public ComboViewer getViewer() {
        return this.viewer;
    }

    void applyEditorValueAndDeactivate() {
        ISelection iSelection = this.viewer.getSelection();
        this.selectedValue = iSelection.isEmpty() ? null : ((IStructuredSelection)iSelection).getFirstElement();
        Object object = this.doGetValue();
        this.markDirty();
        boolean bl = this.isCorrect(object);
        this.setValueValid(bl);
        if (!bl) {
            MessageFormat.format(this.getErrorMessage(), this.selectedValue);
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    @Override
    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    @Override
    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }
}

