/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AbstractComboBoxCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBoxCellEditor
extends AbstractComboBoxCellEditor {
    private String[] items;
    int selection;
    CCombo comboBox;
    private static final int defaultStyle = 0;

    public ComboBoxCellEditor() {
        this.setStyle(0);
    }

    public ComboBoxCellEditor(Composite composite, String[] stringArray) {
        this(composite, stringArray, 0);
    }

    public ComboBoxCellEditor(Composite composite, String[] stringArray, int n) {
        super(composite, n);
        this.setItems(stringArray);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] stringArray) {
        Assert.isNotNull((Object)stringArray);
        this.items = stringArray;
        this.populateComboBoxItems();
    }

    @Override
    protected Control createControl(Composite composite) {
        this.comboBox = new CCombo(composite, this.getStyle());
        this.comboBox.setFont(composite.getFont());
        this.populateComboBoxItems();
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ComboBoxCellEditor.this.keyReleaseOccured(keyEvent);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ComboBoxCellEditor.this.selection = ComboBoxCellEditor.this.comboBox.getSelectionIndex();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ComboBoxCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    @Override
    protected Object doGetValue() {
        return new Integer(this.selection);
    }

    @Override
    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    @Override
    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gC = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gC.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gC.dispose();
        }
        return layoutData;
    }

    @Override
    protected void doSetValue(Object object) {
        Assert.isTrue((this.comboBox != null && object instanceof Integer ? 1 : 0) != 0);
        this.selection = (Integer)object;
        this.comboBox.select(this.selection);
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int n = 0;
            while (n < this.items.length) {
                this.comboBox.add(this.items[n], n);
                ++n;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object object = this.doGetValue();
        this.markDirty();
        boolean bl = this.isCorrect(object);
        this.setValueValid(bl);
        if (!bl) {
            if (this.items.length > 0 && this.selection >= 0 && this.selection < this.items.length) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    @Override
    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    @Override
    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }
}

