/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ColumnViewerToolTipSupport
extends DefaultToolTip {
    private ColumnViewer viewer;
    private static final String VIEWER_CELL_KEY = "org.eclipse.jface_VIEWER_CELL_KEY";
    private static final int DEFAULT_SHIFT_X = 10;
    private static final int DEFAULT_SHIFT_Y = 0;

    protected ColumnViewerToolTipSupport(ColumnViewer columnViewer, int n, boolean bl) {
        super(columnViewer.getControl(), n, bl);
        this.viewer = columnViewer;
    }

    public static void enableFor(ColumnViewer columnViewer) {
        new ColumnViewerToolTipSupport(columnViewer, 2, false);
    }

    public static void enableFor(ColumnViewer columnViewer, int n) {
        new ColumnViewerToolTipSupport(columnViewer, n, false);
    }

    @Override
    protected Object getToolTipArea(Event event) {
        return this.viewer.getCell(new Point(event.x, event.y));
    }

    @Override
    protected Composite createToolTipContentArea(Event event, Composite composite) {
        ViewerCell viewerCell = (ViewerCell)this.getData(VIEWER_CELL_KEY);
        this.setData(VIEWER_CELL_KEY, null);
        return this.createViewerToolTipContentArea(event, viewerCell, composite);
    }

    protected Composite createViewerToolTipContentArea(Event event, ViewerCell viewerCell, Composite composite) {
        return super.createToolTipContentArea(event, composite);
    }

    @Override
    protected boolean shouldCreateToolTip(Event event) {
        if (!super.shouldCreateToolTip(event)) {
            return false;
        }
        boolean bl = false;
        ViewerRow viewerRow = this.viewer.getViewerRow(new Point(event.x, event.y));
        this.viewer.getControl().setToolTipText("");
        Point point = new Point(event.x, event.y);
        if (viewerRow != null) {
            Object object = viewerRow.getItem().getData();
            ViewerCell viewerCell = viewerRow.getCell(point);
            if (viewerCell == null) {
                return false;
            }
            ViewerColumn viewerColumn = this.viewer.getViewerColumn(viewerCell.getColumnIndex());
            if (viewerColumn == null) {
                return false;
            }
            CellLabelProvider cellLabelProvider = viewerColumn.getLabelProvider();
            boolean bl2 = cellLabelProvider.useNativeToolTip(object);
            String string = cellLabelProvider.getToolTipText(object);
            Image image = null;
            if (!bl2) {
                image = cellLabelProvider.getToolTipImage(object);
            }
            if (bl2 || string == null && image == null) {
                this.viewer.getControl().setToolTipText(string);
                bl = false;
            } else {
                this.setPopupDelay(cellLabelProvider.getToolTipDisplayDelayTime(object));
                this.setHideDelay(cellLabelProvider.getToolTipTimeDisplayed(object));
                Point point2 = cellLabelProvider.getToolTipShift(object);
                if (point2 == null) {
                    this.setShift(new Point(10, 0));
                } else {
                    this.setShift(new Point(point2.x, point2.y));
                }
                this.setData(VIEWER_CELL_KEY, viewerCell);
                this.setText(string);
                this.setImage(image);
                this.setStyle(cellLabelProvider.getToolTipStyle(object));
                this.setForegroundColor(cellLabelProvider.getToolTipForegroundColor(object));
                this.setBackgroundColor(cellLabelProvider.getToolTipBackgroundColor(object));
                this.setFont(cellLabelProvider.getToolTipFont(object));
                bl = this.getText(event) != null || this.getImage(event) != null;
            }
        }
        return bl;
    }

    @Override
    protected void afterHideToolTip(Event event) {
        super.afterHideToolTip(event);
        this.setData(VIEWER_CELL_KEY, null);
        if (event != null && event.widget != this.viewer.getControl()) {
            this.viewer.getControl().setFocus();
        }
    }
}

