/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;

public class ColumnViewerEditorActivationStrategy {
    private ColumnViewer viewer;
    private KeyListener keyboardActivationListener;

    public ColumnViewerEditorActivationStrategy(ColumnViewer columnViewer) {
        this.viewer = columnViewer;
    }

    protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        boolean bl;
        boolean bl2 = ((IStructuredSelection)this.viewer.getSelection()).size() == 1;
        boolean bl3 = bl = columnViewerEditorActivationEvent.eventType == 2 && ((MouseEvent)columnViewerEditorActivationEvent.sourceEvent).button == 1;
        return bl2 && (bl || columnViewerEditorActivationEvent.eventType == 4 || columnViewerEditorActivationEvent.eventType == 5);
    }

    private ViewerCell getFocusCell() {
        return this.viewer.getColumnViewerEditor().getFocusCell();
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public void setEnableEditorActivationWithKeyboard(boolean bl) {
        if (bl) {
            if (this.keyboardActivationListener == null) {
                this.keyboardActivationListener = new KeyListener(){

                    public void keyPressed(KeyEvent keyEvent) {
                        ViewerCell viewerCell = ColumnViewerEditorActivationStrategy.this.getFocusCell();
                        if (viewerCell != null) {
                            ColumnViewerEditorActivationStrategy.this.viewer.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(viewerCell, keyEvent));
                        }
                    }

                    public void keyReleased(KeyEvent keyEvent) {
                    }
                };
                this.viewer.getControl().addKeyListener(this.keyboardActivationListener);
            }
        } else if (this.keyboardActivationListener != null) {
            this.viewer.getControl().removeKeyListener(this.keyboardActivationListener);
            this.keyboardActivationListener = null;
        }
    }
}

