/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;

public abstract class ColumnViewerEditor {
    private CellEditor cellEditor;
    private ICellEditorListener cellEditorListener;
    private FocusListener focusListener;
    private MouseListener mouseListener;
    private ColumnViewer viewer;
    private TraverseListener tabeditingListener;
    private ViewerCell cell;
    private ListenerList editorActivationListener;
    private ColumnViewerEditorActivationStrategy editorActivationStrategy;
    private boolean inEditorDeactivation;
    private DisposeListener disposeListener;
    public static final int DEFAULT = 1;
    public static final int TABBING_MOVE_TO_ROW_NEIGHBOR = 2;
    public static final int TABBING_CYCLE_IN_ROW = 4;
    public static final int TABBING_VERTICAL = 8;
    public static final int TABBING_HORIZONTAL = 16;
    public static final int KEYBOARD_ACTIVATION = 32;
    public static final int KEEP_EDITOR_ON_DOUBLE_CLICK = 64;
    private int feature;

    protected ColumnViewerEditor(final ColumnViewer columnViewer, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n) {
        this.viewer = columnViewer;
        this.editorActivationStrategy = columnViewerEditorActivationStrategy;
        if ((n & 0x20) == 32) {
            this.editorActivationStrategy.setEnableEditorActivationWithKeyboard(true);
        }
        this.feature = n;
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (columnViewer.isCellEditorActive()) {
                    ColumnViewerEditor.this.cancelEditing();
                }
            }
        };
        this.initCellEditorListener();
    }

    private void initCellEditorListener() {
        this.cellEditorListener = new ICellEditorListener(){

            @Override
            public void editorValueChanged(boolean bl, boolean bl2) {
            }

            @Override
            public void cancelEditor() {
                ColumnViewerEditor.this.cancelEditing();
            }

            @Override
            public void applyEditorValue() {
                ColumnViewerEditor.this.applyEditorValue();
            }
        };
    }

    private boolean activateCellEditor(final ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        ViewerColumn viewerColumn = this.viewer.getViewerColumn(this.cell.getColumnIndex());
        Object object = this.cell.getElement();
        if (viewerColumn != null && viewerColumn.getEditingSupport() != null && viewerColumn.getEditingSupport().canEdit(object)) {
            this.cellEditor = viewerColumn.getEditingSupport().getCellEditor(object);
            if (this.cellEditor != null) {
                Control control;
                int n = this.cellEditor.getDoubleClickTimeout();
                final int n2 = n != 0 ? columnViewerEditorActivationEvent.time + n : 0;
                if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                    control = this.editorActivationListener.getListeners();
                    int n3 = 0;
                    while (n3 < ((Object[])control).length) {
                        ((ColumnViewerEditorActivationListener)control[n3]).beforeEditorActivated(columnViewerEditorActivationEvent);
                        if (columnViewerEditorActivationEvent.cancel) {
                            return false;
                        }
                        ++n3;
                    }
                }
                this.updateFocusCell(this.cell, columnViewerEditorActivationEvent);
                this.cellEditor.addListener(this.cellEditorListener);
                viewerColumn.getEditingSupport().initializeCellEditorValue(this.cellEditor, this.cell);
                control = this.cellEditor.getControl();
                this.cellEditor.activate(columnViewerEditorActivationEvent);
                if (control == null) {
                    return false;
                }
                this.setLayoutData(this.cellEditor.getLayoutData());
                this.setEditor(control, (Item)this.cell.getItem(), this.cell.getColumnIndex());
                this.cellEditor.setFocus();
                if (this.cellEditor.dependsOnExternalFocusListener()) {
                    if (this.focusListener == null) {
                        this.focusListener = new FocusAdapter(){

                            public void focusLost(FocusEvent focusEvent) {
                                ColumnViewerEditor.this.applyEditorValue();
                            }
                        };
                    }
                    control.addFocusListener(this.focusListener);
                }
                this.mouseListener = new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        if (ColumnViewerEditor.this.shouldFireDoubleClick(n2, mouseEvent.time, columnViewerEditorActivationEvent) && mouseEvent.button == 1) {
                            control.removeMouseListener(ColumnViewerEditor.this.mouseListener);
                            ColumnViewerEditor.this.cancelEditing();
                            ColumnViewerEditor.this.handleDoubleClickEvent();
                        } else if (ColumnViewerEditor.this.mouseListener != null) {
                            control.removeMouseListener(ColumnViewerEditor.this.mouseListener);
                        }
                    }
                };
                if (n2 != 0 && (this.feature & 0x40) == 0) {
                    control.addMouseListener(this.mouseListener);
                }
                if (this.tabeditingListener == null) {
                    this.tabeditingListener = new TraverseListener(){

                        public void keyTraversed(TraverseEvent traverseEvent) {
                            if ((ColumnViewerEditor.this.feature & 1) != 1) {
                                ColumnViewerEditor.this.processTraverseEvent(ColumnViewerEditor.this.cell.getColumnIndex(), ColumnViewerEditor.this.viewer.getViewerRowFromItem(ColumnViewerEditor.this.cell.getItem()), traverseEvent);
                            }
                        }
                    };
                }
                control.addTraverseListener(this.tabeditingListener);
                if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                    Object[] objectArray = this.editorActivationListener.getListeners();
                    int n4 = 0;
                    while (n4 < objectArray.length) {
                        ((ColumnViewerEditorActivationListener)objectArray[n4]).afterEditorActivated(columnViewerEditorActivationEvent);
                        ++n4;
                    }
                }
                this.cell.getItem().addDisposeListener(this.disposeListener);
                return true;
            }
        }
        return false;
    }

    private boolean shouldFireDoubleClick(int n, int n2, ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        return n2 <= n && columnViewerEditorActivationEvent.eventType != 1 && columnViewerEditorActivationEvent.eventType != 4 && columnViewerEditorActivationEvent.eventType != 5;
    }

    void applyEditorValue() {
        if (!this.inEditorDeactivation) {
            try {
                this.inEditorDeactivation = true;
                CellEditor cellEditor = this.cellEditor;
                if (cellEditor != null && this.cell != null) {
                    Object[] objectArray;
                    ColumnViewerEditorDeactivationEvent columnViewerEditorDeactivationEvent = new ColumnViewerEditorDeactivationEvent(this.cell);
                    columnViewerEditorDeactivationEvent.eventType = 2;
                    if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                        objectArray = this.editorActivationListener.getListeners();
                        int n = 0;
                        while (n < objectArray.length) {
                            ((ColumnViewerEditorActivationListener)objectArray[n]).beforeEditorDeactivated(columnViewerEditorDeactivationEvent);
                            ++n;
                        }
                    }
                    if ((objectArray = (Object[])this.cell.getItem()) != null && !objectArray.isDisposed() && cellEditor.isValueValid()) {
                        this.saveEditorValue(cellEditor);
                    }
                    if (!this.viewer.getControl().isDisposed()) {
                        this.setEditor(null, null, 0);
                    }
                    cellEditor.removeListener(this.cellEditorListener);
                    Control control = cellEditor.getControl();
                    if (control != null && !control.isDisposed()) {
                        if (this.mouseListener != null) {
                            control.removeMouseListener(this.mouseListener);
                            this.mouseListener = null;
                        }
                        if (this.focusListener != null) {
                            control.removeFocusListener(this.focusListener);
                        }
                        if (this.tabeditingListener != null) {
                            control.removeTraverseListener(this.tabeditingListener);
                        }
                    }
                    cellEditor.deactivate(columnViewerEditorDeactivationEvent);
                    if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                        Object[] objectArray2 = this.editorActivationListener.getListeners();
                        int n = 0;
                        while (n < objectArray2.length) {
                            ((ColumnViewerEditorActivationListener)objectArray2[n]).afterEditorDeactivated(columnViewerEditorDeactivationEvent);
                            ++n;
                        }
                    }
                    if (!this.cell.getItem().isDisposed()) {
                        this.cell.getItem().removeDisposeListener(this.disposeListener);
                    }
                }
                this.cellEditor = null;
                this.cell = null;
            }
            finally {
                this.inEditorDeactivation = false;
            }
        }
    }

    void cancelEditing() {
        if (!this.inEditorDeactivation) {
            try {
                this.inEditorDeactivation = true;
                if (this.cellEditor != null) {
                    Control control;
                    ColumnViewerEditorDeactivationEvent columnViewerEditorDeactivationEvent = new ColumnViewerEditorDeactivationEvent(this.cell);
                    columnViewerEditorDeactivationEvent.eventType = 1;
                    if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                        control = this.editorActivationListener.getListeners();
                        int n = 0;
                        while (n < ((Object[])control).length) {
                            ((ColumnViewerEditorActivationListener)control[n]).beforeEditorDeactivated(columnViewerEditorDeactivationEvent);
                            ++n;
                        }
                    }
                    if (!this.viewer.getControl().isDisposed()) {
                        this.setEditor(null, null, 0);
                    }
                    this.cellEditor.removeListener(this.cellEditorListener);
                    control = this.cellEditor.getControl();
                    if (control != null && !this.viewer.getControl().isDisposed()) {
                        if (this.mouseListener != null) {
                            control.removeMouseListener(this.mouseListener);
                            this.mouseListener = null;
                        }
                        if (this.focusListener != null) {
                            control.removeFocusListener(this.focusListener);
                        }
                        if (this.tabeditingListener != null) {
                            control.removeTraverseListener(this.tabeditingListener);
                        }
                    }
                    CellEditor cellEditor = this.cellEditor;
                    cellEditor.deactivate(columnViewerEditorDeactivationEvent);
                    if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                        Object[] objectArray = this.editorActivationListener.getListeners();
                        int n = 0;
                        while (n < objectArray.length) {
                            ((ColumnViewerEditorActivationListener)objectArray[n]).afterEditorDeactivated(columnViewerEditorDeactivationEvent);
                            ++n;
                        }
                    }
                    if (!this.cell.getItem().isDisposed()) {
                        this.cell.getItem().addDisposeListener(this.disposeListener);
                    }
                    this.cellEditor = null;
                    this.cell = null;
                }
            }
            finally {
                this.inEditorDeactivation = false;
            }
        }
    }

    void handleEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        if (!columnViewerEditorActivationEvent.cancel && this.editorActivationStrategy.isEditorActivationEvent(columnViewerEditorActivationEvent)) {
            if (this.cellEditor != null) {
                this.applyEditorValue();
            }
            this.cell = (ViewerCell)columnViewerEditorActivationEvent.getSource();
            if (!this.activateCellEditor(columnViewerEditorActivationEvent) && !this.inEditorDeactivation) {
                this.cell = null;
                this.cellEditor = null;
            }
        }
    }

    private void saveEditorValue(CellEditor cellEditor) {
        ViewerColumn viewerColumn = this.viewer.getViewerColumn(this.cell.getColumnIndex());
        if (viewerColumn != null && viewerColumn.getEditingSupport() != null) {
            viewerColumn.getEditingSupport().saveCellEditorValue(cellEditor, this.cell);
        }
    }

    boolean isCellEditorActive() {
        return this.cellEditor != null;
    }

    void handleDoubleClickEvent() {
        this.viewer.fireDoubleClick(new DoubleClickEvent(this.viewer, this.viewer.getSelection()));
        this.viewer.fireOpen(new OpenEvent(this.viewer, this.viewer.getSelection()));
    }

    public void addEditorActivationListener(ColumnViewerEditorActivationListener columnViewerEditorActivationListener) {
        if (this.editorActivationListener == null) {
            this.editorActivationListener = new ListenerList();
        }
        this.editorActivationListener.add((Object)columnViewerEditorActivationListener);
    }

    public void removeEditorActivationListener(ColumnViewerEditorActivationListener columnViewerEditorActivationListener) {
        if (this.editorActivationListener != null) {
            this.editorActivationListener.remove((Object)columnViewerEditorActivationListener);
        }
    }

    protected void processTraverseEvent(int n, ViewerRow viewerRow, TraverseEvent traverseEvent) {
        ViewerCell viewerCell = null;
        if (traverseEvent.detail == 8) {
            traverseEvent.doit = false;
            if ((traverseEvent.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                viewerCell = this.searchCellAboveBelow(viewerRow, this.viewer, n, true);
            } else if ((this.feature & 0x10) == 16) {
                viewerCell = this.searchPreviousCell(viewerRow, viewerRow.getCell(n), viewerRow.getCell(n), this.viewer);
            }
        } else if (traverseEvent.detail == 16) {
            traverseEvent.doit = false;
            if ((traverseEvent.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                viewerCell = this.searchCellAboveBelow(viewerRow, this.viewer, n, false);
            } else if ((this.feature & 0x10) == 16) {
                viewerCell = this.searchNextCell(viewerRow, viewerRow.getCell(n), viewerRow.getCell(n), this.viewer);
            }
        }
        if (viewerCell != null) {
            this.viewer.getControl().setRedraw(false);
            ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent = new ColumnViewerEditorActivationEvent(viewerCell, traverseEvent);
            this.viewer.triggerEditorActivationEvent(columnViewerEditorActivationEvent);
            this.viewer.getControl().setRedraw(true);
        }
    }

    private ViewerCell searchCellAboveBelow(ViewerRow viewerRow, ColumnViewer columnViewer, int n, boolean bl) {
        ViewerCell viewerCell = null;
        ViewerRow viewerRow2 = null;
        viewerRow2 = bl ? viewerRow.getNeighbor(1, false) : viewerRow.getNeighbor(2, false);
        if (viewerRow2 != null) {
            ViewerColumn viewerColumn = columnViewer.getViewerColumn(n);
            viewerCell = viewerColumn != null && viewerColumn.getEditingSupport() != null && viewerColumn.getEditingSupport().canEdit(viewerRow2.getItem().getData()) ? viewerRow2.getCell(n) : this.searchCellAboveBelow(viewerRow2, columnViewer, n, bl);
        }
        return viewerCell;
    }

    private boolean isCellEditable(ColumnViewer columnViewer, ViewerCell viewerCell) {
        ViewerColumn viewerColumn = columnViewer.getViewerColumn(viewerCell.getColumnIndex());
        return viewerColumn != null && viewerColumn.getEditingSupport() != null && viewerColumn.getEditingSupport().canEdit(viewerCell.getElement());
    }

    private ViewerCell searchPreviousCell(ViewerRow viewerRow, ViewerCell viewerCell, ViewerCell viewerCell2, ColumnViewer columnViewer) {
        ViewerRow viewerRow2;
        ViewerCell viewerCell3 = null;
        ViewerCell viewerCell4 = viewerCell != null ? viewerCell.getNeighbor(ViewerCell.LEFT, true) : (viewerRow.getColumnCount() != 0 ? viewerRow.getCell(viewerRow.getCreationIndex(viewerRow.getColumnCount() - 1)) : viewerRow.getCell(0));
        if (viewerCell2.equals(viewerCell4)) {
            return null;
        }
        if (viewerCell4 != null) {
            viewerCell3 = this.isCellEditable(columnViewer, viewerCell4) ? viewerCell4 : this.searchPreviousCell(viewerRow, viewerCell4, viewerCell2, columnViewer);
        } else if ((this.feature & 4) == 4) {
            viewerCell3 = this.searchPreviousCell(viewerRow, null, viewerCell2, columnViewer);
        } else if ((this.feature & 2) == 2 && (viewerRow2 = viewerRow.getNeighbor(1, false)) != null) {
            viewerCell3 = this.searchPreviousCell(viewerRow2, null, viewerCell2, columnViewer);
        }
        return viewerCell3;
    }

    private ViewerCell searchNextCell(ViewerRow viewerRow, ViewerCell viewerCell, ViewerCell viewerCell2, ColumnViewer columnViewer) {
        ViewerRow viewerRow2;
        ViewerCell viewerCell3 = null;
        ViewerCell viewerCell4 = viewerCell != null ? viewerCell.getNeighbor(ViewerCell.RIGHT, true) : viewerRow.getCell(viewerRow.getCreationIndex(0));
        if (viewerCell2.equals(viewerCell4)) {
            return null;
        }
        if (viewerCell4 != null) {
            viewerCell3 = this.isCellEditable(columnViewer, viewerCell4) ? viewerCell4 : this.searchNextCell(viewerRow, viewerCell4, viewerCell2, columnViewer);
        } else if ((this.feature & 4) == 4) {
            viewerCell3 = this.searchNextCell(viewerRow, null, viewerCell2, columnViewer);
        } else if ((this.feature & 2) == 2 && (viewerRow2 = viewerRow.getNeighbor(2, false)) != null) {
            viewerCell3 = this.searchNextCell(viewerRow2, null, viewerCell2, columnViewer);
        }
        return viewerCell3;
    }

    protected abstract void setEditor(Control var1, Item var2, int var3);

    protected abstract void setLayoutData(CellEditor.LayoutData var1);

    protected abstract void updateFocusCell(ViewerCell var1, ColumnViewerEditorActivationEvent var2);

    public ViewerCell getFocusCell() {
        return null;
    }

    protected ColumnViewer getViewer() {
        return this.viewer;
    }
}

