/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class CheckboxTreeViewer
extends TreeViewer
implements ICheckable {
    private ListenerList checkStateListeners = new ListenerList();
    private ICheckStateProvider checkStateProvider;
    private TreeItem lastClickedItem = null;

    public CheckboxTreeViewer(Composite composite) {
        this(composite, 2048);
    }

    public CheckboxTreeViewer(Composite composite, int n) {
        this(new Tree(composite, 0x20 | n));
    }

    public CheckboxTreeViewer(Tree tree) {
        super(tree);
    }

    @Override
    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.checkStateListeners.add((Object)iCheckStateListener);
    }

    public void setCheckStateProvider(ICheckStateProvider iCheckStateProvider) {
        this.checkStateProvider = iCheckStateProvider;
        this.refresh();
    }

    @Override
    protected void doUpdateItem(Item item, Object object) {
        super.doUpdateItem(item, object);
        if (!item.isDisposed() && this.checkStateProvider != null) {
            this.setChecked(object, this.checkStateProvider.isChecked(object));
            this.setGrayed(object, this.checkStateProvider.isGrayed(object));
        }
    }

    private void applyState(CustomHashtable customHashtable, CustomHashtable customHashtable2, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Object object;
            Item item = itemArray[n];
            if (item instanceof TreeItem && (object = item.getData()) != null) {
                TreeItem treeItem = (TreeItem)item;
                treeItem.setChecked(customHashtable.containsKey(object));
                treeItem.setGrayed(customHashtable2.containsKey(object));
            }
            this.applyState(customHashtable, customHashtable2, (Widget)item);
            ++n;
        }
    }

    protected void fireCheckStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
        Object[] objectArray = this.checkStateListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ICheckStateListener iCheckStateListener = (ICheckStateListener)objectArray[n];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iCheckStateListener.checkStateChanged(checkStateChangedEvent);
                }
            });
            ++n;
        }
    }

    private void gatherState(CustomHashtable customHashtable, CustomHashtable customHashtable2, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Object object;
            Item item = itemArray[n];
            if (item instanceof TreeItem && (object = item.getData()) != null) {
                TreeItem treeItem = (TreeItem)item;
                if (treeItem.getChecked()) {
                    customHashtable.put(object, object);
                }
                if (treeItem.getGrayed()) {
                    customHashtable2.put(object, object);
                }
            }
            this.gatherState(customHashtable, customHashtable2, (Widget)item);
            ++n;
        }
    }

    @Override
    public boolean getChecked(Object object) {
        Widget widget = this.findItem(object);
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getChecked();
        }
        return false;
    }

    public Object[] getCheckedElements() {
        ArrayList arrayList = new ArrayList();
        Control control = this.getControl();
        this.internalCollectChecked(arrayList, (Widget)control);
        return arrayList.toArray();
    }

    public boolean getGrayed(Object object) {
        Widget widget = this.findItem(object);
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getGrayed();
        }
        return false;
    }

    public Object[] getGrayedElements() {
        ArrayList arrayList = new ArrayList();
        this.internalCollectGrayed(arrayList, (Widget)this.getControl());
        return arrayList.toArray();
    }

    @Override
    protected void handleDoubleSelect(SelectionEvent selectionEvent) {
        if (this.lastClickedItem != null) {
            TreeItem treeItem = this.lastClickedItem;
            Object object = treeItem.getData();
            if (object != null) {
                boolean bl = treeItem.getChecked();
                this.setChecked(object, !bl);
                this.fireCheckStateChanged(new CheckStateChangedEvent(this, object, !bl));
            }
            this.lastClickedItem = null;
        } else {
            super.handleDoubleSelect(selectionEvent);
        }
    }

    @Override
    protected void handleSelect(SelectionEvent selectionEvent) {
        this.lastClickedItem = null;
        if (selectionEvent.detail == 32) {
            TreeItem treeItem;
            this.lastClickedItem = treeItem = (TreeItem)selectionEvent.item;
            super.handleSelect(selectionEvent);
            Object object = treeItem.getData();
            if (object != null) {
                this.fireCheckStateChanged(new CheckStateChangedEvent(this, object, treeItem.getChecked()));
            }
        } else {
            super.handleSelect(selectionEvent);
        }
    }

    private void internalCollectChecked(List list, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Object object;
            Item item = itemArray[n];
            if (item instanceof TreeItem && ((TreeItem)item).getChecked() && (object = item.getData()) != null) {
                list.add(object);
            }
            this.internalCollectChecked(list, (Widget)item);
            ++n;
        }
    }

    private void internalCollectGrayed(List list, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Object object;
            Item item = itemArray[n];
            if (item instanceof TreeItem && ((TreeItem)item).getGrayed() && (object = item.getData()) != null) {
                list.add(object);
            }
            this.internalCollectGrayed(list, (Widget)item);
            ++n;
        }
    }

    private void internalSetChecked(CustomHashtable customHashtable, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            boolean bl;
            TreeItem treeItem = (TreeItem)itemArray[n];
            Object object = treeItem.getData();
            if (object != null && (bl = customHashtable.containsKey(object)) != treeItem.getChecked()) {
                treeItem.setChecked(bl);
            }
            this.internalSetChecked(customHashtable, (Widget)treeItem);
            ++n;
        }
    }

    private void internalSetGrayed(CustomHashtable customHashtable, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            boolean bl;
            TreeItem treeItem = (TreeItem)itemArray[n];
            Object object = treeItem.getData();
            if (object != null && (bl = customHashtable.containsKey(object)) != treeItem.getGrayed()) {
                treeItem.setGrayed(bl);
            }
            this.internalSetGrayed(customHashtable, (Widget)treeItem);
            ++n;
        }
    }

    @Override
    protected void preservingSelection(Runnable runnable) {
        if (!this.getPreserveSelection()) {
            return;
        }
        if (this.checkStateProvider != null) {
            super.preservingSelection(runnable);
            return;
        }
        int n = this.getItemCount(this.getControl());
        CustomHashtable customHashtable = this.newHashtable(n * 2 + 1);
        CustomHashtable customHashtable2 = this.newHashtable(n * 2 + 1);
        this.gatherState(customHashtable, customHashtable2, (Widget)this.getControl());
        super.preservingSelection(runnable);
        this.applyState(customHashtable, customHashtable2, (Widget)this.getControl());
    }

    @Override
    public void removeCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.checkStateListeners.remove((Object)iCheckStateListener);
    }

    @Override
    public boolean setChecked(Object object, boolean bl) {
        Assert.isNotNull((Object)object);
        Widget widget = this.internalExpand(object, false);
        if (widget instanceof TreeItem) {
            ((TreeItem)widget).setChecked(bl);
            return true;
        }
        return false;
    }

    private void setCheckedChildren(Item item, boolean bl) {
        this.createChildren((Widget)item);
        Item[] itemArray = this.getChildren((Widget)item);
        if (itemArray != null) {
            int n = 0;
            while (n < itemArray.length) {
                Item item2 = itemArray[n];
                if (item2.getData() != null && item2 instanceof TreeItem) {
                    TreeItem treeItem = (TreeItem)item2;
                    treeItem.setChecked(bl);
                    this.setCheckedChildren((Item)treeItem, bl);
                }
                ++n;
            }
        }
    }

    public void setCheckedElements(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        CustomHashtable customHashtable = this.newHashtable(objectArray.length * 2 + 1);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.internalExpand(object, false);
            customHashtable.put(object, object);
            ++n;
        }
        Control control = this.getControl();
        control.setRedraw(false);
        this.internalSetChecked(customHashtable, (Widget)control);
        control.setRedraw(true);
    }

    public boolean setGrayed(Object object, boolean bl) {
        Assert.isNotNull((Object)object);
        Widget widget = this.internalExpand(object, false);
        if (widget instanceof TreeItem) {
            ((TreeItem)widget).setGrayed(bl);
            return true;
        }
        return false;
    }

    public boolean setGrayChecked(Object object, boolean bl) {
        Assert.isNotNull((Object)object);
        Widget widget = this.internalExpand(object, false);
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            treeItem.setChecked(bl);
            treeItem.setGrayed(bl);
            return true;
        }
        return false;
    }

    public void setGrayedElements(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        CustomHashtable customHashtable = this.newHashtable(objectArray.length * 2 + 1);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.internalExpand(object, false);
            customHashtable.put(object, object);
            ++n;
        }
        Control control = this.getControl();
        control.setRedraw(false);
        this.internalSetGrayed(customHashtable, (Widget)control);
        control.setRedraw(true);
    }

    public boolean setParentsGrayed(Object object, boolean bl) {
        Assert.isNotNull((Object)object);
        Widget widget = this.internalExpand(object, false);
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            treeItem.setGrayed(bl);
            treeItem = treeItem.getParentItem();
            while (treeItem != null) {
                treeItem.setGrayed(bl);
                treeItem = treeItem.getParentItem();
            }
            return true;
        }
        return false;
    }

    public boolean setSubtreeChecked(Object object, boolean bl) {
        Widget widget = this.internalExpand(object, false);
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            treeItem.setChecked(bl);
            this.setCheckedChildren((Item)treeItem, bl);
            return true;
        }
        return false;
    }

    public void setAllChecked(boolean bl) {
        this.setAllChecked(bl, this.getTree().getItems());
    }

    private void setAllChecked(boolean bl, TreeItem[] treeItemArray) {
        int n = 0;
        while (n < treeItemArray.length) {
            treeItemArray[n].setChecked(bl);
            TreeItem[] treeItemArray2 = treeItemArray[n].getItems();
            this.setAllChecked(bl, treeItemArray2);
            ++n;
        }
    }

    @Override
    boolean optionallyPruneChildren(Item item, Object object) {
        return false;
    }
}

