/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class CellEditor {
    private ListenerList listeners = new ListenerList();
    private ListenerList propertyChangeListeners = new ListenerList();
    private boolean valid = false;
    private ICellEditorValidator validator = null;
    private String errorMessage = null;
    private boolean dirty = false;
    private Control control = null;
    private static final int defaultStyle = 0;
    private int style = 0;
    public static final String COPY = "copy";
    public static final String CUT = "cut";
    public static final String DELETE = "delete";
    public static final String FIND = "find";
    public static final String PASTE = "paste";
    public static final String REDO = "redo";
    public static final String SELECT_ALL = "selectall";
    public static final String UNDO = "undo";

    protected CellEditor() {
    }

    protected CellEditor(Composite composite) {
        this(composite, 0);
    }

    protected CellEditor(Composite composite, int n) {
        this.style = n;
        this.create(composite);
    }

    public void activate() {
    }

    public void addListener(ICellEditorListener iCellEditorListener) {
        this.listeners.add((Object)iCellEditorListener);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListeners.add((Object)iPropertyChangeListener);
    }

    protected abstract Control createControl(Composite var1);

    public void create(Composite composite) {
        Assert.isTrue((this.control == null ? 1 : 0) != 0);
        this.control = this.createControl(composite);
        this.deactivate();
    }

    public void deactivate() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
    }

    public void dispose() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
        this.control = null;
    }

    protected abstract Object doGetValue();

    protected abstract void doSetFocus();

    protected abstract void doSetValue(Object var1);

    protected void fireApplyEditorValue() {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ICellEditorListener iCellEditorListener = (ICellEditorListener)objectArray[n];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iCellEditorListener.applyEditorValue();
                }
            });
            ++n;
        }
    }

    protected void fireCancelEditor() {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ICellEditorListener iCellEditorListener = (ICellEditorListener)objectArray[n];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iCellEditorListener.cancelEditor();
                }
            });
            ++n;
        }
    }

    protected void fireEditorValueChanged(final boolean bl, final boolean bl2) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ICellEditorListener iCellEditorListener = (ICellEditorListener)objectArray[n];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iCellEditorListener.editorValueChanged(bl, bl2);
                }
            });
            ++n;
        }
    }

    protected void fireEnablementChanged(final String string) {
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iPropertyChangeListener.propertyChange(new PropertyChangeEvent(this, string, null, null));
                }
            });
            ++n;
        }
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public int getStyle() {
        return this.style;
    }

    public Control getControl() {
        return this.control;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public LayoutData getLayoutData() {
        LayoutData layoutData = new LayoutData();
        Control control = this.getControl();
        if (control != null) {
            layoutData.minimumWidth = control.computeSize((int)-1, (int)-1, (boolean)true).x;
        }
        return layoutData;
    }

    public ICellEditorValidator getValidator() {
        return this.validator;
    }

    public final Object getValue() {
        if (!this.valid) {
            return null;
        }
        return this.doGetValue();
    }

    public boolean isActivated() {
        return this.control != null && this.control.getVisible();
    }

    public boolean isCopyEnabled() {
        return false;
    }

    protected boolean isCorrect(Object object) {
        this.errorMessage = null;
        if (this.validator == null) {
            return true;
        }
        this.errorMessage = this.validator.isValid(object);
        return this.errorMessage == null || this.errorMessage.equals("");
    }

    public boolean isCutEnabled() {
        return false;
    }

    public boolean isDeleteEnabled() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    public boolean isFindEnabled() {
        return false;
    }

    public boolean isPasteEnabled() {
        return false;
    }

    public boolean isRedoEnabled() {
        return false;
    }

    public boolean isSelectAllEnabled() {
        return false;
    }

    public boolean isUndoEnabled() {
        return false;
    }

    public boolean isValueValid() {
        return this.valid;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\r') {
            this.fireApplyEditorValue();
            this.deactivate();
        }
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.fireApplyEditorValue();
            this.deactivate();
        }
    }

    public void performCopy() {
    }

    public void performCut() {
    }

    public void performDelete() {
    }

    public void performFind() {
    }

    public void performPaste() {
    }

    public void performRedo() {
    }

    public void performSelectAll() {
    }

    public void performUndo() {
    }

    public void removeListener(ICellEditorListener iCellEditorListener) {
        this.listeners.remove((Object)iCellEditorListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListeners.remove((Object)iPropertyChangeListener);
    }

    protected void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setFocus() {
        this.doSetFocus();
    }

    public void setValidator(ICellEditorValidator iCellEditorValidator) {
        this.validator = iCellEditorValidator;
    }

    public final void setValue(Object object) {
        this.valid = this.isCorrect(object);
        this.dirty = false;
        this.doSetValue(object);
    }

    protected void setValueValid(boolean bl) {
        this.valid = bl;
    }

    protected void valueChanged(boolean bl, boolean bl2) {
        this.valid = bl2;
        this.dirty = true;
        this.fireEditorValueChanged(bl, bl2);
    }

    public void activate(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        this.activate();
    }

    protected boolean dependsOnExternalFocusListener() {
        return true;
    }

    protected void deactivate(ColumnViewerEditorDeactivationEvent columnViewerEditorDeactivationEvent) {
        this.deactivate();
    }

    protected int getDoubleClickTimeout() {
        return Display.getCurrent().getDoubleClickTime();
    }

    public static class LayoutData {
        public int horizontalAlignment = 16384;
        public boolean grabHorizontal = true;
        public int minimumWidth = 50;
        public int minimumHeight = -1;
        public int verticalAlignment = 0x1000000;
    }
}

