/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTreeViewer
extends ColumnViewer {
    public static final int ALL_LEVELS = -1;
    private ListenerList treeListeners = new ListenerList();
    private int expandToLevel = 0;
    private boolean isExpandableCheckFilters = false;

    protected AbstractTreeViewer() {
    }

    public void add(Object object, Object[] objectArray) {
        Assert.isNotNull((Object)object);
        this.assertElementsNotNull(objectArray);
        if (this.checkBusy()) {
            return;
        }
        Widget[] widgetArray = this.internalFindItems(object);
        if (widgetArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < widgetArray.length) {
            this.internalAdd(widgetArray[n], object, objectArray);
            ++n;
        }
    }

    protected final Widget[] internalFindItems(Object object) {
        TreePath treePath;
        Widget widget;
        Widget[] widgetArray = object instanceof TreePath ? ((widget = this.internalFindItem(treePath = (TreePath)object)) == null ? new Widget[]{} : new Widget[]{widget}) : this.findItems(object);
        return widgetArray;
    }

    private Widget internalFindItem(TreePath treePath) {
        Widget[] widgetArray = this.findItems(treePath.getLastSegment());
        int n = 0;
        while (n < widgetArray.length) {
            Item item;
            TreePath treePath2;
            Widget widget = widgetArray[n];
            if (widget instanceof Item && (treePath2 = this.getTreePathFromItem(item = (Item)widget)).equals(treePath)) {
                return widget;
            }
            ++n;
        }
        return null;
    }

    protected void internalAdd(Widget widget, Object object, Object[] objectArray) {
        Object[] objectArray2;
        Object object2;
        TreePath treePath;
        if (object instanceof TreePath) {
            treePath = (TreePath)object;
            object2 = treePath.getLastSegment();
        } else {
            object2 = object;
            treePath = null;
        }
        if (widget instanceof Item && !this.getExpanded((Item)(objectArray2 = (Object[])widget))) {
            boolean bl = this.isExpandable((Item)objectArray2, treePath, object2);
            boolean bl2 = false;
            Item[] itemArray = this.getItems((Item)objectArray2);
            int n = 0;
            while (n < itemArray.length) {
                if (itemArray[n].getData() != null) {
                    this.disassociate(itemArray[n]);
                    itemArray[n].dispose();
                } else if (bl && !bl2) {
                    bl2 = true;
                } else {
                    itemArray[n].dispose();
                }
                ++n;
            }
            if (bl && !bl2) {
                this.newItem((Widget)objectArray2, 0, -1);
            }
            return;
        }
        if (objectArray.length > 0) {
            Item[] itemArray;
            objectArray2 = this.filter(object, objectArray);
            ViewerComparator viewerComparator = this.getComparator();
            if (viewerComparator != null) {
                if (viewerComparator instanceof TreePathViewerSorter) {
                    itemArray = (Item[])viewerComparator;
                    if (treePath == null) {
                        treePath = this.internalGetSorterParentPath(widget, viewerComparator);
                    }
                    itemArray.sort(this, treePath, objectArray2);
                } else {
                    viewerComparator.sort(this, objectArray2);
                }
            }
            this.createAddedElements(widget, objectArray2);
            if (InternalPolicy.DEBUG_LOG_EQUAL_VIEWER_ELEMENTS) {
                itemArray = this.getChildren(widget);
                Object[] objectArray3 = new Object[itemArray.length];
                int n = 0;
                while (n < itemArray.length) {
                    objectArray3[n] = itemArray[n].getData();
                    ++n;
                }
                this.assertElementsNotNull(object2, objectArray3);
            }
        }
    }

    private Object[] filter(Object object, Object[] objectArray) {
        ViewerFilter[] viewerFilterArray = this.getFilters();
        if (viewerFilterArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                boolean bl = true;
                int n2 = 0;
                while (n2 < viewerFilterArray.length) {
                    bl = viewerFilterArray[n2].select(this, object, objectArray[n]);
                    if (!bl) break;
                    ++n2;
                }
                if (bl) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return objectArray;
    }

    private void createAddedElements(Widget widget, Object[] objectArray) {
        if (objectArray.length == 1 && this.equals(objectArray[0], widget.getData())) {
            return;
        }
        ViewerComparator viewerComparator = this.getComparator();
        TreePath treePath = this.internalGetSorterParentPath(widget, viewerComparator);
        Item[] itemArray = this.getChildren(widget);
        if (itemArray.length == 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.createTreeItem(widget, objectArray[n], -1);
                ++n;
            }
            return;
        }
        if (viewerComparator == null) {
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (this.itemExists(itemArray, object)) {
                    this.internalRefresh(object);
                } else {
                    this.createTreeItem(widget, object, -1);
                }
                ++n;
            }
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            block14: {
                Object object = objectArray[n3];
                if ((n = this.insertionPosition(itemArray, viewerComparator, n, object, treePath)) == itemArray.length) {
                    this.createTreeItem(widget, object, -1);
                    ++n2;
                } else {
                    int n4 = n;
                    while (n4 < itemArray.length && this.internalCompare(viewerComparator, treePath, object, itemArray[n4].getData()) == 0) {
                        if (itemArray[n4].getData().equals(object)) {
                            this.internalRefresh(object);
                            break block14;
                        }
                        ++n4;
                    }
                    if (n4 == itemArray.length) {
                        this.createTreeItem(widget, object, -1);
                        ++n2;
                    } else {
                        this.createTreeItem(widget, object, n4 + n2);
                        ++n2;
                    }
                }
            }
            ++n3;
        }
    }

    private boolean itemExists(Item[] itemArray, Object object) {
        if (this.usingElementMap()) {
            Widget[] widgetArray = this.findItems(object);
            if (widgetArray.length == 0) {
                return false;
            }
            if (widgetArray.length == 1 && itemArray.length > 0 && widgetArray[0] instanceof Item) {
                Item item = (Item)widgetArray[0];
                return this.getParentItem(item) == this.getParentItem(itemArray[0]);
            }
        }
        int n = 0;
        while (n < itemArray.length) {
            if (itemArray[n].getData().equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int insertionPosition(Item[] itemArray, ViewerComparator viewerComparator, int n, Object object, TreePath treePath) {
        int n2 = itemArray.length;
        if (viewerComparator == null) {
            return n2;
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            Object object2 = itemArray[n5].getData();
            int n6 = this.internalCompare(viewerComparator, treePath, object2, object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
        }
        return n3;
    }

    protected int indexForElement(Widget widget, Object object) {
        ViewerComparator viewerComparator = this.getComparator();
        TreePath treePath = this.internalGetSorterParentPath(widget, viewerComparator);
        Item[] itemArray = this.getChildren(widget);
        int n = itemArray.length;
        if (viewerComparator == null) {
            return n;
        }
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Object object2 = itemArray[n4].getData();
            int n5 = this.internalCompare(viewerComparator, treePath, object2, object);
            if (n5 == 0) {
                while (n5 == 0) {
                    if (++n4 >= n) break;
                    object2 = itemArray[n4].getData();
                    n5 = this.internalCompare(viewerComparator, treePath, object2, object);
                }
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    private TreePath internalGetSorterParentPath(Widget widget, ViewerComparator viewerComparator) {
        TreePath treePath;
        if (viewerComparator instanceof TreePathViewerSorter && widget instanceof Item) {
            Item item = (Item)widget;
            treePath = this.getTreePathFromItem(item);
        } else {
            treePath = null;
        }
        return treePath;
    }

    private int internalCompare(ViewerComparator viewerComparator, TreePath treePath, Object object, Object object2) {
        if (viewerComparator instanceof TreePathViewerSorter) {
            TreePathViewerSorter treePathViewerSorter = (TreePathViewerSorter)viewerComparator;
            return treePathViewerSorter.compare(this, treePath, object, object2);
        }
        return viewerComparator.compare(this, object, object2);
    }

    @Override
    protected Object[] getSortedChildren(Object object) {
        Object[] objectArray = this.getFilteredChildren(object);
        ViewerComparator viewerComparator = this.getComparator();
        if (object != null && viewerComparator instanceof TreePathViewerSorter) {
            TreePathViewerSorter treePathViewerSorter = (TreePathViewerSorter)viewerComparator;
            objectArray = (Object[])objectArray.clone();
            TreePath treePath = null;
            if (object instanceof TreePath) {
                treePath = (TreePath)object;
            } else {
                Object object2 = object;
                Widget widget = this.internalGetWidgetToSelect(object2);
                if (widget != null) {
                    treePath = this.internalGetSorterParentPath(widget, viewerComparator);
                }
            }
            treePathViewerSorter.sort(this, treePath, objectArray);
        } else if (viewerComparator != null) {
            objectArray = (Object[])objectArray.clone();
            viewerComparator.sort(this, objectArray);
        }
        return objectArray;
    }

    public void add(Object object, Object object2) {
        this.add(object, new Object[]{object2});
    }

    protected void addSelectionListener(Control control, SelectionListener selectionListener) {
    }

    public void addTreeListener(ITreeViewerListener iTreeViewerListener) {
        this.treeListeners.add((Object)iTreeViewerListener);
    }

    protected abstract void addTreeListener(Control var1, TreeListener var2);

    @Override
    protected void associate(Object object, Item item) {
        Object object2 = item.getData();
        if (object2 != null && object2 != object && this.equals(object2, object)) {
            this.unmapElement(object2, (Widget)item);
            item.setData(object);
            this.mapElement(object, (Widget)item);
        } else {
            super.associate(object, item);
        }
    }

    public void collapseAll() {
        Object object = this.getRoot();
        if (object != null) {
            this.collapseToLevel(object, -1);
        }
    }

    public void collapseToLevel(Object object, int n) {
        Assert.isNotNull((Object)object);
        Widget widget = this.internalGetWidgetToSelect(object);
        if (widget != null) {
            this.internalCollapseToLevel(widget, n);
        }
    }

    protected void createChildren(Widget widget) {
        this.createChildren(widget, true);
    }

    void createChildren(final Widget widget, boolean bl) {
        boolean bl2 = this.isBusy();
        this.setBusy(true);
        try {
            Object object;
            final Item[] itemArray = this.getChildren(widget);
            if (itemArray != null && itemArray.length > 0 && (object = itemArray[0].getData()) != null) {
                return;
            }
            BusyIndicator.showWhile((Display)widget.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    Object object;
                    if (itemArray != null) {
                        int n = 0;
                        while (n < itemArray.length) {
                            if (itemArray[n].getData() != null) {
                                AbstractTreeViewer.this.disassociate(itemArray[n]);
                                Assert.isTrue((itemArray[n].getData() == null ? 1 : 0) != 0, (String)"Second or later child is non -null");
                            }
                            itemArray[n].dispose();
                            ++n;
                        }
                    }
                    if ((object = widget.getData()) != null) {
                        Object[] objectArray;
                        Object object2 = object;
                        if (AbstractTreeViewer.this.isTreePathContentProvider() && widget instanceof Item) {
                            TreePath treePath = AbstractTreeViewer.this.getTreePathFromItem((Item)widget);
                            objectArray = AbstractTreeViewer.this.getSortedChildren(treePath);
                        } else {
                            objectArray = AbstractTreeViewer.this.getSortedChildren(object2);
                        }
                        int n = 0;
                        while (n < objectArray.length) {
                            AbstractTreeViewer.this.createTreeItem(widget, objectArray[n], -1);
                            ++n;
                        }
                    }
                }
            });
        }
        finally {
            this.setBusy(bl2);
        }
    }

    protected void createTreeItem(Widget widget, Object object, int n) {
        Item item = this.newItem(widget, 0, n);
        this.updateItem((Widget)item, object);
        this.updatePlus(item, object);
    }

    @Override
    protected void disassociate(Item item) {
        super.disassociate(item);
        if (this.usingElementMap()) {
            this.disassociateChildren(item);
        }
    }

    private void disassociateChildren(Item item) {
        Item[] itemArray = this.getChildren((Widget)item);
        int n = 0;
        while (n < itemArray.length) {
            if (itemArray[n].getData() != null) {
                this.disassociate(itemArray[n]);
            }
            ++n;
        }
    }

    @Override
    protected Widget doFindInputItem(Object object) {
        Object object2 = this.getRoot();
        if (object2 == null) {
            return null;
        }
        if (this.equals(object2, object)) {
            return this.getControl();
        }
        return null;
    }

    @Override
    protected Widget doFindItem(Object object) {
        Object object2 = this.getRoot();
        if (object2 == null) {
            return null;
        }
        Item[] itemArray = this.getChildren((Widget)this.getControl());
        if (itemArray != null) {
            int n = 0;
            while (n < itemArray.length) {
                Widget widget = this.internalFindItem(itemArray[n], object);
                if (widget != null) {
                    return widget;
                }
                ++n;
            }
        }
        return null;
    }

    protected void doUpdateItem(Item item, Object object) {
        boolean bl;
        if (item.isDisposed()) {
            this.unmapElement(object, (Widget)item);
            return;
        }
        int n = this.doGetColumnCount();
        if (n == 0) {
            n = 1;
        }
        ViewerRow viewerRow = this.getViewerRowFromItem((Widget)item);
        boolean bl2 = bl = (this.getControl().getStyle() & 0x10000000) != 0;
        if (bl) {
            viewerRow = (ViewerRow)viewerRow.clone();
        }
        int n2 = 0;
        while (n2 < n) {
            ViewerColumn viewerColumn = this.getViewerColumn(n2);
            ViewerCell viewerCell = this.updateCell(viewerRow, n2, object);
            if (bl) {
                viewerCell = new ViewerCell(viewerCell.getViewerRow(), viewerCell.getColumnIndex(), object);
            }
            viewerColumn.refresh(viewerCell);
            this.updateCell(null, 0, null);
            if (item.isDisposed()) {
                this.unmapElement(object, (Widget)item);
                return;
            }
            ++n2;
        }
    }

    protected boolean isSameSelection(List list, Item[] itemArray) {
        int n = list.size();
        if (n != itemArray.length) {
            return false;
        }
        CustomHashtable customHashtable = this.newHashtable(n * 2 + 1);
        for (Item item : list) {
            Object object = item.getData();
            customHashtable.put(object, object);
        }
        int n2 = 0;
        while (n2 < itemArray.length) {
            if (itemArray[n2].getData() == null || !customHashtable.containsKey(itemArray[n2].getData())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        boolean bl2 = this.isBusy();
        this.setBusy(true);
        try {
            if (widget instanceof Item) {
                Item item = (Item)widget;
                if (bl) {
                    this.associate(object, item);
                } else {
                    Object object2 = item.getData();
                    if (object2 != null) {
                        this.unmapElement(object2, (Widget)item);
                    }
                    item.setData(object);
                    this.mapElement(object, (Widget)item);
                }
                SafeRunnable.run(new UpdateItemSafeRunnable(item, object));
            }
        }
        finally {
            this.setBusy(bl2);
        }
    }

    public void expandAll() {
        this.expandToLevel(-1);
    }

    public void expandToLevel(int n) {
        this.expandToLevel(this.getRoot(), n);
    }

    public void expandToLevel(Object object, int n) {
        if (this.checkBusy()) {
            return;
        }
        Widget widget = this.internalExpand(object, true);
        if (widget != null) {
            this.internalExpandToLevel(widget, n);
        }
    }

    protected void fireTreeCollapsed(final TreeExpansionEvent treeExpansionEvent) {
        Object[] objectArray = this.treeListeners.getListeners();
        boolean bl = this.isBusy();
        this.setBusy(true);
        try {
            int n = 0;
            while (n < objectArray.length) {
                final ITreeViewerListener iTreeViewerListener = (ITreeViewerListener)objectArray[n];
                SafeRunnable.run(new SafeRunnable(){

                    public void run() {
                        iTreeViewerListener.treeCollapsed(treeExpansionEvent);
                    }
                });
                ++n;
            }
        }
        finally {
            this.setBusy(bl);
        }
    }

    protected void fireTreeExpanded(final TreeExpansionEvent treeExpansionEvent) {
        Object[] objectArray = this.treeListeners.getListeners();
        boolean bl = this.isBusy();
        this.setBusy(true);
        try {
            int n = 0;
            while (n < objectArray.length) {
                final ITreeViewerListener iTreeViewerListener = (ITreeViewerListener)objectArray[n];
                SafeRunnable.run(new SafeRunnable(){

                    public void run() {
                        iTreeViewerListener.treeExpanded(treeExpansionEvent);
                    }
                });
                ++n;
            }
        }
        finally {
            this.setBusy(bl);
        }
    }

    public int getAutoExpandLevel() {
        return this.expandToLevel;
    }

    protected abstract Item[] getChildren(Widget var1);

    protected Item getChild(Widget widget, int n) {
        return this.getChildren(widget)[n];
    }

    protected abstract boolean getExpanded(Item var1);

    public Object[] getExpandedElements() {
        ArrayList arrayList = new ArrayList();
        this.internalCollectExpandedItems(arrayList, (Widget)this.getControl());
        ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        for (Item item : arrayList) {
            Object object = item.getData();
            if (object == null) continue;
            arrayList2.add(object);
        }
        return arrayList2.toArray();
    }

    public boolean getExpandedState(Object object) {
        Assert.isNotNull((Object)object);
        Widget widget = this.internalGetWidgetToSelect(object);
        if (widget instanceof Item) {
            return this.getExpanded((Item)widget);
        }
        return false;
    }

    protected abstract int getItemCount(Control var1);

    protected abstract int getItemCount(Item var1);

    protected abstract Item[] getItems(Item var1);

    protected Item getNextItem(Item item, boolean bl) {
        Item[] itemArray;
        if (item == null) {
            return null;
        }
        if (bl && this.getExpanded(item) && (itemArray = this.getItems(item)) != null && itemArray.length > 0) {
            return itemArray[0];
        }
        itemArray = this.getParentItem(item);
        if (itemArray == null) {
            return null;
        }
        Item[] itemArray2 = this.getItems((Item)itemArray);
        if (itemArray2 != null) {
            if (itemArray2.length <= 1) {
                return this.getNextItem((Item)itemArray, false);
            }
            int n = 0;
            while (n < itemArray2.length) {
                if (itemArray2[n] == item && n < itemArray2.length - 1) {
                    return itemArray2[n + 1];
                }
                ++n;
            }
        }
        return this.getNextItem((Item)itemArray, false);
    }

    protected abstract Item getParentItem(Item var1);

    protected Item getPreviousItem(Item item) {
        Item item2 = this.getParentItem(item);
        if (item2 == null) {
            return null;
        }
        Item[] itemArray = this.getItems(item2);
        if (itemArray.length == 0 || itemArray[0] == item) {
            return item2;
        }
        Item item3 = itemArray[0];
        int n = 1;
        while (n < itemArray.length) {
            if (itemArray[n] == item) {
                return this.rightMostVisibleDescendent(item3);
            }
            item3 = itemArray[n];
            ++n;
        }
        return null;
    }

    @Override
    protected Object[] getRawChildren(Object object) {
        boolean bl = this.isBusy();
        this.setBusy(true);
        try {
            Object object2;
            TreePath treePath;
            if (object instanceof TreePath) {
                treePath = (TreePath)object;
                object2 = treePath.getLastSegment();
            } else {
                object2 = object;
                treePath = null;
            }
            if (object2 != null) {
                ITreeContentProvider iTreeContentProvider;
                Object[] objectArray;
                if (this.equals(object2, this.getRoot())) {
                    Object[] objectArray2 = super.getRawChildren(object2);
                    return objectArray2;
                }
                IContentProvider iContentProvider = this.getContentProvider();
                if (iContentProvider instanceof ITreePathContentProvider) {
                    Object[] objectArray3;
                    ITreePathContentProvider iTreePathContentProvider = (ITreePathContentProvider)iContentProvider;
                    if (treePath == null) {
                        objectArray3 = this.findItem(object2);
                        if (objectArray3 instanceof Item) {
                            Item item = (Item)objectArray3;
                            treePath = this.getTreePathFromItem(item);
                        }
                        if (treePath == null) {
                            treePath = new TreePath(new Object[]{object2});
                        }
                    }
                    if ((objectArray3 = iTreePathContentProvider.getChildren(treePath)) != null) {
                        this.assertElementsNotNull(object2, objectArray3);
                        Object[] objectArray4 = objectArray3;
                        return objectArray4;
                    }
                } else if (iContentProvider instanceof ITreeContentProvider && (objectArray = (iTreeContentProvider = (ITreeContentProvider)iContentProvider).getChildren(object2)) != null) {
                    this.assertElementsNotNull(object2, objectArray);
                    Object[] objectArray5 = objectArray;
                    return objectArray5;
                }
            }
            Object[] objectArray = new Object[]{};
            return objectArray;
        }
        finally {
            this.setBusy(bl);
        }
    }

    private void assertElementsNotNull(Object object, Object[] objectArray) {
        Assert.isNotNull((Object)objectArray);
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Assert.isNotNull((Object)objectArray[n]);
            ++n;
        }
        if (InternalPolicy.DEBUG_LOG_EQUAL_VIEWER_ELEMENTS && objectArray.length > 1) {
            CustomHashtable customHashtable = this.newHashtable(objectArray.length * 2);
            n2 = 0;
            while (n2 < objectArray.length) {
                Object object2 = objectArray[n2];
                Object object3 = customHashtable.put(object2, object2);
                if (object3 != null) {
                    String string = "Sibling elements in viewer must not be equal:\n  " + object3 + ",\n  " + object2 + ",\n  parent: " + object;
                    Policy.getLog().log((IStatus)new Status(2, "org.eclipse.jface", string, (Throwable)new RuntimeException()));
                    return;
                }
                ++n2;
            }
        }
    }

    protected abstract Item[] getSelection(Control var1);

    @Override
    protected List getSelectionFromWidget() {
        Item[] itemArray = this.getSelection(this.getControl());
        ArrayList<Object> arrayList = new ArrayList<Object>(itemArray.length);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            Object object = item.getData();
            if (object != null) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    @Override
    protected void handleDoubleSelect(SelectionEvent selectionEvent) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            ISelection iSelection;
            if (selectionEvent.item != null && selectionEvent.item.getData() != null) {
                TreePath treePath = this.getTreePathFromItem((Item)selectionEvent.item);
                iSelection = new TreeSelection(treePath);
            } else {
                iSelection = this.getSelection();
                this.updateSelection(iSelection);
            }
            this.fireDoubleClick(new DoubleClickEvent(this, iSelection));
        }
    }

    protected void handleTreeCollapse(TreeEvent treeEvent) {
        if (treeEvent.item.getData() != null) {
            this.fireTreeCollapsed(new TreeExpansionEvent(this, treeEvent.item.getData()));
        }
    }

    protected void handleTreeExpand(TreeEvent treeEvent) {
        this.createChildren(treeEvent.item);
        if (treeEvent.item.getData() != null) {
            this.fireTreeExpanded(new TreeExpansionEvent(this, treeEvent.item.getData()));
        }
    }

    @Override
    protected void hookControl(Control control) {
        super.hookControl(control);
        this.addTreeListener(control, new TreeListener(){

            public void treeExpanded(TreeEvent treeEvent) {
                AbstractTreeViewer.this.handleTreeExpand(treeEvent);
            }

            public void treeCollapsed(TreeEvent treeEvent) {
                AbstractTreeViewer.this.handleTreeCollapse(treeEvent);
            }
        });
    }

    @Override
    protected void inputChanged(Object object, Object object2) {
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                Control control = AbstractTreeViewer.this.getControl();
                control.setRedraw(false);
                try {
                    AbstractTreeViewer.this.removeAll(control);
                    control.setData(AbstractTreeViewer.this.getRoot());
                    AbstractTreeViewer.this.internalInitializeTree(control);
                }
                finally {
                    control.setRedraw(true);
                }
            }
        });
    }

    protected void internalInitializeTree(Control control) {
        this.createChildren((Widget)control);
        this.internalExpandToLevel((Widget)control, this.expandToLevel);
    }

    protected void internalCollapseToLevel(Widget widget, int n) {
        if (n == -1 || n > 0) {
            Item[] itemArray;
            if (widget instanceof Item) {
                itemArray = (Item[])widget;
                this.setExpanded((Item)itemArray, false);
                Object object = itemArray.getData();
                if (object != null && n == -1 && this.optionallyPruneChildren((Item)itemArray, object)) {
                    return;
                }
            }
            if ((n == -1 || n > 1) && (itemArray = this.getChildren(widget)) != null) {
                int n2 = n == -1 ? -1 : n - 1;
                int n3 = 0;
                while (n3 < itemArray.length) {
                    this.internalCollapseToLevel((Widget)itemArray[n3], n2);
                    ++n3;
                }
            }
        }
    }

    private void internalCollectExpandedItems(List list, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            if (item.getData() != null) {
                if (this.getExpanded(item)) {
                    list.add(item);
                }
                this.internalCollectExpandedItems(list, (Widget)item);
            }
            ++n;
        }
    }

    protected Widget internalExpand(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        Widget widget = this.internalGetWidgetToSelect(object);
        if (widget == null) {
            Widget widget2;
            if (this.equals(object, this.getRoot())) {
                return null;
            }
            Object object2 = this.getParentElement(object);
            if (object2 != null && (widget2 = this.internalExpand(object2, false)) != null) {
                this.createChildren(widget2);
                Object object3 = this.internalToElement(object);
                widget = this.internalFindChild(widget2, object3);
                if (bl && widget2 instanceof Item) {
                    Item item = (Item)widget2;
                    LinkedList<Item> linkedList = new LinkedList<Item>();
                    while (item != null && !this.getExpanded(item)) {
                        linkedList.addFirst(item);
                        item = this.getParentItem(item);
                    }
                    for (Item item2 : linkedList) {
                        this.setExpanded(item2, true);
                    }
                }
            }
        }
        return widget;
    }

    private Object internalToElement(Object object) {
        if (object instanceof TreePath) {
            return ((TreePath)object).getLastSegment();
        }
        return object;
    }

    protected Object getParentElement(Object object) {
        IStructuredContentProvider iStructuredContentProvider;
        TreePath[] treePathArray;
        if (object instanceof TreePath) {
            TreePath treePath = (TreePath)object;
            return treePath.getParentPath();
        }
        IContentProvider iContentProvider = this.getContentProvider();
        if (iContentProvider instanceof ITreePathContentProvider && (treePathArray = (iStructuredContentProvider = (ITreePathContentProvider)iContentProvider).getParents(object)).length > 0) {
            if (treePathArray[0].getSegmentCount() == 0) {
                return this.getRoot();
            }
            return treePathArray[0].getLastSegment();
        }
        if (iContentProvider instanceof ITreeContentProvider) {
            iStructuredContentProvider = (ITreeContentProvider)iContentProvider;
            return iStructuredContentProvider.getParent(object);
        }
        return null;
    }

    protected Widget internalGetWidgetToSelect(Object object) {
        if (object instanceof TreePath) {
            TreePath treePath = (TreePath)object;
            if (treePath.getSegmentCount() == 0) {
                return this.getControl();
            }
            Widget[] widgetArray = this.findItems(treePath.getLastSegment());
            int n = 0;
            while (n < widgetArray.length) {
                Widget widget = widgetArray[n];
                if (widget instanceof Item && treePath.equals(this.getTreePathFromItem((Item)widget), this.getComparer())) {
                    return widget;
                }
                ++n;
            }
            return null;
        }
        return this.findItem(object);
    }

    protected void internalExpandToLevel(Widget widget, int n) {
        if (n == -1 || n > 0) {
            Item[] itemArray;
            if (widget instanceof Item && widget.getData() != null && !this.isExpandable((Item)widget, null, widget.getData())) {
                return;
            }
            this.createChildren(widget, false);
            if (widget instanceof Item) {
                this.setExpanded((Item)widget, true);
            }
            if ((n == -1 || n > 1) && (itemArray = this.getChildren(widget)) != null) {
                int n2 = n == -1 ? -1 : n - 1;
                int n3 = 0;
                while (n3 < itemArray.length) {
                    this.internalExpandToLevel((Widget)itemArray[n3], n2);
                    ++n3;
                }
            }
        }
    }

    private Widget internalFindChild(Widget widget, Object object) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            Object object2 = item.getData();
            if (object2 != null && this.equals(object2, object)) {
                return item;
            }
            ++n;
        }
        return null;
    }

    private Widget internalFindItem(Item item, Object object) {
        Object object2 = item.getData();
        if (object2 != null && this.equals(object2, object)) {
            return item;
        }
        Item[] itemArray = this.getChildren((Widget)item);
        int n = 0;
        while (n < itemArray.length) {
            Item item2 = itemArray[n];
            Widget widget = this.internalFindItem(item2, object);
            if (widget != null) {
                return widget;
            }
            ++n;
        }
        return null;
    }

    @Override
    protected void internalRefresh(Object object) {
        this.internalRefresh(object, true);
    }

    @Override
    protected void internalRefresh(Object object, boolean bl) {
        if (object == null) {
            this.internalRefresh((Widget)this.getControl(), this.getRoot(), true, bl);
            return;
        }
        Widget[] widgetArray = this.findItems(object);
        if (widgetArray.length != 0) {
            int n = 0;
            while (n < widgetArray.length) {
                this.internalRefresh(widgetArray[n], object, true, bl);
                ++n;
            }
        }
    }

    protected void internalRefresh(Widget widget, Object object, boolean bl, boolean bl2) {
        if (widget instanceof Item) {
            if (bl) {
                this.updatePlus((Item)widget, object);
            }
            if (bl2 || !this.equals(object, widget.getData())) {
                this.doUpdateItem(widget, object, true);
            } else {
                this.associate(object, (Item)widget);
            }
        }
        if (bl) {
            this.internalRefreshStruct(widget, object, bl2);
        } else {
            Item[] itemArray = this.getChildren(widget);
            if (itemArray != null) {
                int n = 0;
                while (n < itemArray.length) {
                    Item item = itemArray[n];
                    Object object2 = item.getData();
                    if (object2 != null) {
                        this.internalRefresh((Widget)item, object2, bl, bl2);
                    }
                    ++n;
                }
            }
        }
    }

    void internalRefreshStruct(Widget widget, Object object, boolean bl) {
        this.updateChildren(widget, object, null, bl);
        Item[] itemArray = this.getChildren(widget);
        if (itemArray != null) {
            int n = 0;
            while (n < itemArray.length) {
                Item item = itemArray[n];
                Object object2 = item.getData();
                if (object2 != null) {
                    this.internalRefreshStruct((Widget)item, object2, bl);
                }
                ++n;
            }
        }
    }

    protected void internalRemove(Object[] objectArray) {
        Object object = this.getInput();
        int n = 0;
        while (n < objectArray.length) {
            Widget[] widgetArray;
            Object object2 = objectArray[n];
            if (this.equals(object2, object)) {
                this.setInput(null);
                return;
            }
            Widget[] widgetArray2 = this.internalFindItems(object2);
            if (widgetArray2.length > 0) {
                int n2 = 0;
                while (n2 < widgetArray2.length) {
                    widgetArray = widgetArray2[n2];
                    if (widgetArray instanceof Item) {
                        this.disassociate((Item)widgetArray);
                        widgetArray.dispose();
                    }
                    ++n2;
                }
            } else {
                Object object3 = this.getParentElement(object2);
                if (!(object3 == null || this.equals(object3, this.getRoot()) || object3 instanceof TreePath && ((TreePath)object3).getSegmentCount() == 0)) {
                    widgetArray = this.internalFindItems(object3);
                    int n3 = 0;
                    while (n3 < widgetArray.length) {
                        Widget widget = widgetArray[n3];
                        if (widget instanceof Item) {
                            this.updatePlus((Item)widget, object3);
                        }
                        ++n3;
                    }
                }
            }
            ++n;
        }
    }

    protected void internalRemove(Object object, Object[] objectArray) {
        CustomHashtable customHashtable = new CustomHashtable(this.getComparer());
        int n = 0;
        while (n < objectArray.length) {
            customHashtable.put(objectArray[n], objectArray[n]);
            ++n;
        }
        Widget[] widgetArray = this.findItems(object);
        int n2 = 0;
        while (n2 < widgetArray.length) {
            Widget widget = widgetArray[n2];
            if (!widget.isDisposed()) {
                Item[] itemArray = this.getChildren(widget);
                if (itemArray.length == 1 && itemArray[0].getData() == null && widget instanceof Item) {
                    this.updatePlus((Item)widget, object);
                } else {
                    int n3 = 0;
                    while (n3 < itemArray.length) {
                        Item item = itemArray[n3];
                        Object object2 = item.getData();
                        if (object2 != null && customHashtable.containsKey(object2)) {
                            this.disassociate(item);
                            item.dispose();
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
    }

    private void internalSetExpanded(CustomHashtable customHashtable, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            Object object = item.getData();
            if (object != null) {
                boolean bl;
                boolean bl2 = bl = customHashtable.remove(object) != null;
                if (bl != this.getExpanded(item)) {
                    if (bl) {
                        this.createChildren((Widget)item);
                    }
                    this.setExpanded(item, bl);
                }
            }
            if (customHashtable.size() > 0) {
                this.internalSetExpanded(customHashtable, (Widget)item);
            }
            ++n;
        }
    }

    private void internalSetExpandedTreePaths(CustomHashtable customHashtable, Widget widget, TreePath treePath) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            TreePath treePath2;
            Item item = itemArray[n];
            Object object = item.getData();
            TreePath treePath3 = treePath2 = object == null ? null : treePath.createChildPath(object);
            if (object != null && treePath2 != null) {
                boolean bl;
                boolean bl2 = bl = customHashtable.remove(treePath2) != null;
                if (bl != this.getExpanded(item)) {
                    if (bl) {
                        this.createChildren((Widget)item);
                    }
                    this.setExpanded(item, bl);
                }
            }
            this.internalSetExpandedTreePaths(customHashtable, (Widget)item, treePath2);
            ++n;
        }
    }

    public boolean isExpandable(Object object) {
        Object object2;
        TreePath treePath;
        if (object instanceof TreePath) {
            treePath = (TreePath)object;
            object2 = treePath.getLastSegment();
        } else {
            object2 = object;
            treePath = null;
        }
        IContentProvider iContentProvider = this.getContentProvider();
        if (iContentProvider instanceof ITreePathContentProvider) {
            boolean bl;
            ITreePathContentProvider iTreePathContentProvider = (ITreePathContentProvider)iContentProvider;
            if (treePath == null) {
                Widget widget = this.findItem(object2);
                if (widget instanceof Item) {
                    Item item = (Item)widget;
                    treePath = this.getTreePathFromItem(item);
                }
                if (treePath == null) {
                    treePath = new TreePath(new Object[]{object2});
                }
            }
            if ((bl = iTreePathContentProvider.hasChildren(treePath)) && this.isExpandableCheckFilters && this.hasFilters()) {
                return this.getFilteredChildren(treePath).length > 0;
            }
            return bl;
        }
        if (iContentProvider instanceof ITreeContentProvider) {
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)iContentProvider;
            boolean bl = iTreeContentProvider.hasChildren(object2);
            if (bl && this.isExpandableCheckFilters && this.hasFilters()) {
                return this.getFilteredChildren(object2).length > 0;
            }
            return bl;
        }
        return false;
    }

    private boolean isExpandable(Item item, TreePath treePath, Object object) {
        Object object2 = object;
        if (this.isTreePathContentProvider()) {
            object2 = treePath != null ? treePath.createChildPath(object) : this.getTreePathFromItem(item);
        }
        return this.isExpandable(object2);
    }

    @Override
    protected void labelProviderChanged() {
        Control control = this.getControl();
        control.setRedraw(false);
        this.internalRefresh((Widget)control, this.getRoot(), false, true);
        control.setRedraw(true);
    }

    protected abstract Item newItem(Widget var1, int var2, int var3);

    public void remove(final Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        if (objectArray.length == 0) {
            return;
        }
        if (this.checkBusy()) {
            return;
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                AbstractTreeViewer.this.internalRemove(objectArray);
            }
        });
    }

    public void remove(final Object object, final Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        if (objectArray.length == 0) {
            return;
        }
        if (this.checkBusy()) {
            return;
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                AbstractTreeViewer.this.internalRemove(object, objectArray);
            }
        });
    }

    public void remove(Object object) {
        this.remove(new Object[]{object});
    }

    protected abstract void removeAll(Control var1);

    public void removeTreeListener(ITreeViewerListener iTreeViewerListener) {
        this.treeListeners.remove((Object)iTreeViewerListener);
    }

    @Override
    public void reveal(Object object) {
        Assert.isNotNull((Object)object);
        Widget widget = this.internalExpand(object, true);
        if (widget instanceof Item) {
            this.showItem((Item)widget);
        }
    }

    private Item rightMostVisibleDescendent(Item item) {
        Item[] itemArray = this.getItems(item);
        if (this.getExpanded(item) && itemArray != null && itemArray.length > 0) {
            return this.rightMostVisibleDescendent(itemArray[itemArray.length - 1]);
        }
        return item;
    }

    @Override
    public Item scrollDown(int n, int n2) {
        Item item = this.getItem(n, n2);
        if (item != null) {
            Item item2 = this.getNextItem(item, true);
            this.showItem(item2 == null ? item : item2);
            return item2;
        }
        return null;
    }

    @Override
    public Item scrollUp(int n, int n2) {
        Item item = this.getItem(n, n2);
        if (item != null) {
            Item item2 = this.getPreviousItem(item);
            this.showItem(item2 == null ? item : item2);
            return item2;
        }
        return null;
    }

    public void setAutoExpandLevel(int n) {
        this.expandToLevel = n;
    }

    @Override
    public void setContentProvider(IContentProvider iContentProvider) {
        super.setContentProvider(iContentProvider);
    }

    @Override
    protected void assertContentProviderType(IContentProvider iContentProvider) {
        Assert.isTrue((iContentProvider instanceof ITreeContentProvider || iContentProvider instanceof ITreePathContentProvider ? 1 : 0) != 0);
    }

    protected abstract void setExpanded(Item var1, boolean var2);

    public void setExpandedElements(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        if (this.checkBusy()) {
            return;
        }
        CustomHashtable customHashtable = this.newHashtable(objectArray.length * 2 + 1);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.internalExpand(object, false);
            customHashtable.put(object, object);
            ++n;
        }
        this.internalSetExpanded(customHashtable, (Widget)this.getControl());
    }

    public void setExpandedTreePaths(TreePath[] treePathArray) {
        this.assertElementsNotNull(treePathArray);
        if (this.checkBusy()) {
            return;
        }
        final IElementComparer iElementComparer = this.getComparer();
        IElementComparer iElementComparer2 = new IElementComparer(){

            @Override
            public boolean equals(Object object, Object object2) {
                return ((TreePath)object).equals((TreePath)object2, iElementComparer);
            }

            @Override
            public int hashCode(Object object) {
                return ((TreePath)object).hashCode(iElementComparer);
            }
        };
        CustomHashtable customHashtable = new CustomHashtable(treePathArray.length * 2 + 1, iElementComparer2);
        int n = 0;
        while (n < treePathArray.length) {
            TreePath treePath = treePathArray[n];
            this.internalExpand(treePath, false);
            customHashtable.put(treePath, treePath);
            ++n;
        }
        this.internalSetExpandedTreePaths(customHashtable, (Widget)this.getControl(), new TreePath(new Object[0]));
    }

    public void setExpandedState(Object object, boolean bl) {
        Assert.isNotNull((Object)object);
        if (this.checkBusy()) {
            return;
        }
        Widget widget = this.internalExpand(object, false);
        if (widget instanceof Item) {
            if (bl) {
                this.createChildren(widget);
            }
            this.setExpanded((Item)widget, bl);
        }
    }

    protected abstract void setSelection(List var1);

    @Override
    protected void setSelectionToWidget(List list, boolean bl) {
        if (list == null) {
            this.setSelection(new ArrayList(0));
            return;
        }
        int n = list.size();
        ArrayList<Widget> arrayList = new ArrayList<Widget>(n);
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath;
            Object object;
            Object e = list.get(n2);
            Widget widget = this.internalExpand(e, false);
            if (widget instanceof Item) {
                arrayList.add(widget);
            } else if (widget == null && e instanceof TreePath && (object = (treePath = (TreePath)e).getLastSegment()) != null && (widget = this.internalExpand(object, false)) instanceof Item) {
                arrayList.add(widget);
            }
            ++n2;
        }
        this.setSelection(arrayList);
        if (bl && arrayList.size() > 0) {
            n2 = arrayList.size() - 1;
            while (n2 >= 0) {
                this.showItem((Item)arrayList.get(n2));
                --n2;
            }
        }
    }

    protected abstract void showItem(Item var1);

    protected void updateChildren(Widget widget, Object object, Object[] objectArray) {
        this.updateChildren(widget, object, objectArray, true);
    }

    private void updateChildren(Widget widget, Object object, Object[] objectArray, boolean bl) {
        Object object2;
        Object object3;
        if (widget instanceof Item && !this.getExpanded((Item)(object3 = (Item)widget))) {
            if (this.optionallyPruneChildren((Item)object3, object)) {
                return;
            }
            Item[] itemArray = this.getItems((Item)object3);
            if (this.isExpandable((Item)object3, null, object)) {
                if (itemArray.length == 0) {
                    this.newItem((Widget)object3, 0, -1);
                    return;
                }
                if (itemArray.length == 1 && itemArray[0].getData() == null) {
                    return;
                }
            } else {
                int n = 0;
                while (n < itemArray.length) {
                    if (itemArray[n].getData() != null) {
                        this.disassociate(itemArray[n]);
                    }
                    itemArray[n].dispose();
                    ++n;
                }
                return;
            }
        }
        if (objectArray == null) {
            if (this.isTreePathContentProvider() && widget instanceof Item) {
                object3 = this.getTreePathFromItem((Item)widget);
                objectArray = this.getSortedChildren(object3);
            } else {
                objectArray = this.getSortedChildren(object);
            }
        }
        object3 = this.getControl();
        int n = -1;
        if (widget == object3) {
            n = this.getItemCount((Control)object3);
        }
        Item[] itemArray = this.getChildren(widget);
        CustomHashtable customHashtable = this.newHashtable(13);
        int n2 = 0;
        while (n2 < itemArray.length) {
            Object object4;
            if (this.getExpanded(itemArray[n2]) && (object4 = itemArray[n2].getData()) != null) {
                customHashtable.put(object4, object4);
            }
            ++n2;
        }
        n2 = Math.min(objectArray.length, itemArray.length);
        int n3 = itemArray.length - n2;
        if (n3 > 0) {
            CustomHashtable customHashtable2 = this.newHashtable(objectArray.length * 2);
            int n4 = 0;
            while (n4 < objectArray.length) {
                object2 = objectArray[n4];
                customHashtable2.put(object2, object2);
                ++n4;
            }
            n4 = 0;
            while (n3 > 0 && n4 < itemArray.length) {
                object2 = itemArray[n4].getData();
                if (object2 == null || !customHashtable2.containsKey(object2)) {
                    if (object2 != null) {
                        this.disassociate(itemArray[n4]);
                    }
                    itemArray[n4].dispose();
                    if (n4 + 1 < itemArray.length) {
                        System.arraycopy(itemArray, n4 + 1, itemArray, n4, itemArray.length - (n4 + 1));
                    }
                    --n3;
                    continue;
                }
                ++n4;
            }
        }
        int n5 = 0;
        while (n5 < n2) {
            Object object5;
            Item item = itemArray[n5];
            object2 = item.getData();
            if (object2 != null && (object5 = objectArray[n5]) != object2) {
                if (this.equals(object5, object2)) {
                    Object object6 = item.getData();
                    if (object6 != null) {
                        this.unmapElement(object6, (Widget)item);
                    }
                    item.setData(object5);
                    this.mapElement(object5, (Widget)item);
                } else {
                    this.disassociate(item);
                    item.setImage(null);
                    item.setText("");
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n2) {
            Item item = itemArray[n5];
            object2 = objectArray[n5];
            if (item.getData() == null) {
                this.associate(object2, item);
                this.updatePlus(item, object2);
                this.updateItem((Widget)item, object2);
            } else {
                this.updatePlus(item, object2);
                if (bl) {
                    this.updateItem((Widget)item, object2);
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n2) {
            Item item = itemArray[n5];
            object2 = objectArray[n5];
            this.setExpanded(item, customHashtable.containsKey(object2));
            ++n5;
        }
        if (n2 < objectArray.length) {
            n5 = n2;
            while (n5 < objectArray.length) {
                this.createTreeItem(widget, objectArray[n5], -1);
                ++n5;
            }
            if (customHashtable.size() > 0) {
                itemArray = this.getChildren(widget);
                n5 = n2;
                while (n5 < objectArray.length) {
                    if (customHashtable.containsKey(objectArray[n5])) {
                        this.setExpanded(itemArray[n5], true);
                    }
                    ++n5;
                }
            }
        }
        if (widget == object3 && n == 0 && this.getItemCount((Control)object3) != 0) {
            object3.setRedraw(false);
            object3.setRedraw(true);
        }
    }

    boolean optionallyPruneChildren(Item item, Object object) {
        boolean bl = this.isExpandable(item, null, object);
        boolean bl2 = false;
        Item[] itemArray = this.getItems(item);
        int n = 0;
        while (n < itemArray.length) {
            if (itemArray[n].getData() != null) {
                this.disassociate(itemArray[n]);
                itemArray[n].dispose();
            } else if (bl && !bl2) {
                bl2 = true;
            } else {
                itemArray[n].dispose();
            }
            ++n;
        }
        if (bl && !bl2) {
            this.newItem((Widget)item, 0, -1);
        }
        return true;
    }

    public Item[] getChildren(Widget widget, Object[] objectArray) {
        return this.getChildren(widget);
    }

    protected void updatePlus(Item item, Object object) {
        boolean bl = this.getItemCount(item) > 0;
        boolean bl2 = this.isExpandable(item, null, object);
        boolean bl3 = false;
        boolean bl4 = false;
        Object object2 = item.getData();
        if (object2 != null && this.equals(object, object2)) {
            if (bl != bl2) {
                if (bl2) {
                    bl4 = true;
                } else {
                    bl3 = true;
                }
            }
        } else {
            bl3 = true;
            bl4 = bl2;
            this.setExpanded(item, false);
        }
        if (bl3) {
            Item[] itemArray = this.getItems(item);
            int n = 0;
            while (n < itemArray.length) {
                if (itemArray[n].getData() != null) {
                    this.disassociate(itemArray[n]);
                }
                itemArray[n].dispose();
                ++n;
            }
        }
        if (bl4) {
            this.newItem((Widget)item, 0, -1);
        }
    }

    public Object[] getVisibleExpandedElements() {
        ArrayList arrayList = new ArrayList();
        this.internalCollectVisibleExpanded(arrayList, (Widget)this.getControl());
        return arrayList.toArray();
    }

    private void internalCollectVisibleExpanded(ArrayList arrayList, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            if (this.getExpanded(item)) {
                Object object = item.getData();
                if (object != null) {
                    arrayList.add(object);
                }
                this.internalCollectVisibleExpanded(arrayList, (Widget)item);
            }
            ++n;
        }
    }

    protected TreePath getTreePathFromItem(Item item) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (item != null) {
            Object object = item.getData();
            Assert.isNotNull((Object)object);
            linkedList.addFirst(object);
            item = this.getParentItem(item);
        }
        return new TreePath(linkedList.toArray());
    }

    @Override
    public ISelection getSelection() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return TreeSelection.EMPTY;
        }
        Item[] itemArray = this.getSelection(this.getControl());
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(itemArray.length);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            if (item.getData() != null) {
                arrayList.add(this.getTreePathFromItem(item));
            }
            ++n;
        }
        return new TreeSelection(arrayList.toArray(new TreePath[arrayList.size()]), this.getComparer());
    }

    @Override
    protected void setSelectionToWidget(ISelection iSelection, boolean bl) {
        if (iSelection instanceof ITreeSelection) {
            ITreeSelection iTreeSelection = (ITreeSelection)iSelection;
            this.setSelectionToWidget(Arrays.asList(iTreeSelection.getPaths()), bl);
        } else {
            super.setSelectionToWidget(iSelection, bl);
        }
    }

    public TreePath[] getExpandedTreePaths() {
        ArrayList arrayList = new ArrayList();
        this.internalCollectExpandedItems(arrayList, (Widget)this.getControl());
        ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>(arrayList.size());
        for (Item item : arrayList) {
            TreePath treePath = this.getTreePathFromItem(item);
            if (treePath == null) continue;
            arrayList2.add(treePath);
        }
        return arrayList2.toArray(new TreePath[arrayList.size()]);
    }

    private boolean isTreePathContentProvider() {
        return this.getContentProvider() instanceof ITreePathContentProvider;
    }

    public void insert(Object object, Object object2, int n) {
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)object2);
        if (this.checkBusy()) {
            return;
        }
        if (this.getComparator() != null || this.hasFilters()) {
            this.add(object, new Object[]{object2});
            return;
        }
        Widget[] widgetArray = this.internalIsInputOrEmptyPath(object) ? new Widget[]{this.getControl()} : this.internalFindItems(object);
        int n2 = 0;
        while (n2 < widgetArray.length) {
            Widget widget = widgetArray[n2];
            if (widget instanceof Item) {
                Item item = (Item)widget;
                Item[] itemArray = this.getChildren((Widget)item);
                if (this.getExpanded(item) || itemArray.length > 0 && itemArray[0].getData() != null) {
                    int n3 = n;
                    if (n3 == -1) {
                        n3 = this.getItemCount(item);
                    }
                    this.createTreeItem((Widget)item, object2, n3);
                } else {
                    Object object3 = object;
                    if (object2 instanceof TreePath) {
                        object3 = ((TreePath)object3).getLastSegment();
                    }
                    this.updatePlus(item, object3);
                }
            } else {
                int n4 = n;
                if (n4 == -1) {
                    n4 = this.getItemCount((Control)widget);
                }
                this.createTreeItem(widget, object2, n4);
            }
            ++n2;
        }
    }

    @Override
    protected Widget getColumnViewerOwner(int n) {
        return null;
    }

    @Override
    protected Item getItemAt(Point point) {
        return null;
    }

    @Override
    protected ColumnViewerEditor createViewerEditor() {
        return null;
    }

    @Override
    protected int doGetColumnCount() {
        return 0;
    }

    @Override
    protected void buildLabel(ViewerLabel viewerLabel, Object object) {
        Object object2;
        if (object instanceof TreePath) {
            TreePath treePath = (TreePath)object;
            IBaseLabelProvider iBaseLabelProvider = this.getLabelProvider();
            if (iBaseLabelProvider instanceof ITreePathLabelProvider) {
                ITreePathLabelProvider iTreePathLabelProvider = (ITreePathLabelProvider)iBaseLabelProvider;
                this.buildLabel(viewerLabel, treePath, iTreePathLabelProvider);
                return;
            }
            object2 = treePath.getLastSegment();
        } else {
            object2 = object;
        }
        super.buildLabel(viewerLabel, object2);
    }

    protected final boolean internalIsInputOrEmptyPath(Object object) {
        if (object.equals(this.getRoot())) {
            return true;
        }
        if (!(object instanceof TreePath)) {
            return false;
        }
        return ((TreePath)object).getSegmentCount() == 0;
    }

    @Override
    protected ViewerRow getViewerRowFromItem(Widget widget) {
        return null;
    }

    public void setExpandPreCheckFilters(boolean bl) {
        if (bl != this.isExpandableCheckFilters) {
            this.isExpandableCheckFilters = bl;
            this.refresh();
        }
    }

    class UpdateItemSafeRunnable
    extends SafeRunnable {
        private Object element;
        private Item item;

        UpdateItemSafeRunnable(Item item, Object object) {
            this.item = item;
            this.element = object;
        }

        public void run() {
            AbstractTreeViewer.this.doUpdateItem(this.item, this.element);
        }
    }
}

