/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTableViewer
extends ColumnViewer {
    private VirtualManager virtualManager;

    @Override
    protected void hookControl(Control control) {
        super.hookControl(control);
        this.initializeVirtualManager(this.getControl().getStyle());
    }

    @Override
    protected void handleDispose(DisposeEvent disposeEvent) {
        super.handleDispose(disposeEvent);
        this.virtualManager = null;
    }

    private void initializeVirtualManager(int n) {
        if ((n & 0x10000000) == 0) {
            return;
        }
        this.virtualManager = new VirtualManager();
    }

    public void add(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        if (this.checkBusy()) {
            return;
        }
        Object[] objectArray2 = this.filter(objectArray);
        int n = 0;
        while (n < objectArray2.length) {
            Object object = objectArray2[n];
            int n2 = this.indexForElement(object);
            this.createItem(object, n2);
            ++n;
        }
    }

    private void createItem(Object object, int n) {
        if (this.virtualManager == null) {
            this.updateItem(this.internalCreateNewRowPart(0, n).getItem(), object);
        } else {
            this.virtualManager.notVisibleAdded(object, n);
        }
    }

    protected abstract ViewerRow internalCreateNewRowPart(int var1, int var2);

    public void add(Object object) {
        this.add(new Object[]{object});
    }

    @Override
    protected Widget doFindInputItem(Object object) {
        if (this.equals(object, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    @Override
    protected Widget doFindItem(Object object) {
        Item[] itemArray = this.doGetItems();
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            Object object2 = item.getData();
            if (object2 != null && this.equals(object2, object)) {
                return item;
            }
            ++n;
        }
        return null;
    }

    @Override
    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        boolean bl2 = this.isBusy();
        this.setBusy(true);
        try {
            if (widget instanceof Item) {
                boolean bl3;
                Item item = (Item)widget;
                if (bl) {
                    this.associate(object, item);
                } else {
                    Object object2 = item.getData();
                    if (object2 != null) {
                        this.unmapElement(object2, (Widget)item);
                    }
                    item.setData(object);
                    this.mapElement(object, (Widget)item);
                }
                int n = this.doGetColumnCount();
                if (n == 0) {
                    n = 1;
                }
                ViewerRow viewerRow = this.getViewerRowFromItem((Widget)item);
                boolean bl4 = bl3 = (this.getControl().getStyle() & 0x10000000) != 0;
                if (bl3) {
                    viewerRow = (ViewerRow)viewerRow.clone();
                }
                int n2 = 0;
                while (n2 < n || n2 == 0) {
                    ViewerColumn viewerColumn = this.getViewerColumn(n2);
                    ViewerCell viewerCell = this.updateCell(viewerRow, n2, object);
                    if (bl3) {
                        viewerCell = new ViewerCell(viewerCell.getViewerRow(), viewerCell.getColumnIndex(), object);
                    }
                    viewerColumn.refresh(viewerCell);
                    this.updateCell(null, 0, null);
                    if (item.isDisposed()) {
                        this.unmapElement(object, (Widget)item);
                        return;
                    }
                    ++n2;
                }
            }
        }
        finally {
            this.setBusy(bl2);
        }
    }

    @Override
    protected Widget getColumnViewerOwner(int n) {
        int n2 = this.doGetColumnCount();
        if (n < 0 || n > 0 && n >= n2) {
            return null;
        }
        if (n2 == 0) {
            return this.getControl();
        }
        return this.doGetColumn(n);
    }

    public Object getElementAt(int n) {
        Item item;
        if (n >= 0 && n < this.doGetItemCount() && (item = this.doGetItem(n)) != null) {
            return item.getData();
        }
        return null;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    @Override
    protected List getSelectionFromWidget() {
        if (this.virtualManager != null) {
            return this.getVirtualSelection();
        }
        Item[] itemArray = this.doGetSelection();
        ArrayList<Object> arrayList = new ArrayList<Object>(itemArray.length);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            Object object = item.getData();
            if (object != null) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    private List getVirtualSelection() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int[] nArray = this.doGetSelectionIndices();
        if (this.getContentProvider() instanceof ILazyContentProvider) {
            ILazyContentProvider iLazyContentProvider = (ILazyContentProvider)this.getContentProvider();
            int n = 0;
            while (n < nArray.length) {
                Object object;
                int n2 = nArray[n];
                iLazyContentProvider.updateElement(n2);
                if (n2 < this.doGetItemCount() && (object = this.doGetItem(n2).getData()) != null) {
                    arrayList.add(object);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < nArray.length) {
                Object object = null;
                int n3 = nArray[n];
                if (n3 < this.virtualManager.cachedElements.length) {
                    object = this.virtualManager.cachedElements[n3];
                }
                if (object == null) {
                    Item item = this.doGetItem(n3);
                    object = item.getData();
                }
                if (object != null) {
                    arrayList.add(object);
                }
                ++n;
            }
        }
        return arrayList;
    }

    protected int indexForElement(Object object) {
        ViewerComparator viewerComparator = this.getComparator();
        if (viewerComparator == null) {
            return this.doGetItemCount();
        }
        int n = this.doGetItemCount();
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Object object2 = this.doGetItem(n4).getData();
            int n5 = viewerComparator.compare(this, object2, object);
            if (n5 == 0) {
                while (n5 == 0) {
                    if (++n4 >= n) break;
                    object2 = this.doGetItem(n4).getData();
                    n5 = viewerComparator.compare(this, object2, object);
                }
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    @Override
    protected void inputChanged(Object object, Object object2) {
        this.getControl().setRedraw(false);
        try {
            this.preservingSelection(new Runnable(){

                @Override
                public void run() {
                    AbstractTableViewer.this.internalRefresh(AbstractTableViewer.this.getRoot());
                }
            });
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    public void insert(Object object, int n) {
        this.applyEditorValue();
        if (this.getComparator() != null || this.hasFilters()) {
            this.add(object);
            return;
        }
        if (n == -1) {
            n = this.doGetItemCount();
        }
        if (this.checkBusy()) {
            return;
        }
        this.createItem(object, n);
    }

    @Override
    protected void internalRefresh(Object object) {
        this.internalRefresh(object, true);
    }

    @Override
    protected void internalRefresh(Object object, boolean bl) {
        this.applyEditorValue();
        if (object == null || this.equals(object, this.getRoot())) {
            if (this.virtualManager == null) {
                this.internalRefreshAll(bl);
            } else {
                this.internalVirtualRefreshAll();
            }
        } else {
            Widget widget = this.findItem(object);
            if (widget != null) {
                this.updateItem(widget, object);
            }
        }
    }

    private void internalVirtualRefreshAll() {
        Object object = this.getRoot();
        IContentProvider iContentProvider = this.getContentProvider();
        if (!(iContentProvider instanceof ILazyContentProvider) && iContentProvider instanceof IStructuredContentProvider && object != null) {
            this.virtualManager.cachedElements = this.getSortedChildren(object);
            this.doSetItemCount(this.virtualManager.cachedElements.length);
        }
        this.doClearAll();
    }

    private void internalRefreshAll(boolean bl) {
        Item item;
        Object[] objectArray = this.getSortedChildren(this.getRoot());
        Item[] itemArray = this.doGetItems();
        int n = Math.min(objectArray.length, itemArray.length);
        int n2 = 0;
        while (n2 < n) {
            item = itemArray[n2];
            if (this.equals(objectArray[n2], item.getData())) {
                if (bl) {
                    this.updateItem((Widget)item, objectArray[n2]);
                } else {
                    this.associate(objectArray[n2], item);
                }
            } else {
                this.disassociate(item);
                this.doClear(n2);
            }
            ++n2;
        }
        if (n < itemArray.length) {
            n2 = itemArray.length;
            while (--n2 >= n) {
                this.disassociate(itemArray[n2]);
            }
            if (this.virtualManager != null) {
                this.virtualManager.removeIndicesFromTo(n, itemArray.length - 1);
            }
            this.doRemove(n, itemArray.length - 1);
        }
        if (this.doGetItemCount() == 0) {
            this.doRemoveAll();
        }
        n2 = 0;
        while (n2 < n) {
            item = itemArray[n2];
            if (item.getData() == null) {
                this.updateItem((Widget)item, objectArray[n2]);
            }
            ++n2;
        }
        n2 = n;
        while (n2 < objectArray.length) {
            this.createItem(objectArray[n2], n2);
            ++n2;
        }
    }

    private void internalRemove(Object[] objectArray) {
        Object object = this.getInput();
        int n = 0;
        while (n < objectArray.length) {
            if (this.equals(objectArray[n], object)) {
                boolean bl = this.isBusy();
                this.setBusy(false);
                try {
                    this.setInput(null);
                }
                finally {
                    this.setBusy(bl);
                }
                return;
            }
            ++n;
        }
        int[] nArray = new int[objectArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            Widget widget = this.findItem(objectArray[n3]);
            if (widget == null && this.virtualManager != null) {
                int n4 = this.virtualManager.find(objectArray[n3]);
                if (n4 != -1) {
                    nArray[n2++] = n4;
                }
            } else if (widget instanceof Item) {
                Item item = (Item)widget;
                this.disassociate(item);
                nArray[n2++] = this.doIndexOf(item);
            }
            ++n3;
        }
        if (n2 < nArray.length) {
            int[] nArray2 = nArray;
            nArray = new int[n2];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
        }
        if (this.virtualManager != null) {
            this.virtualManager.removeIndices(nArray);
        }
        this.doRemove(nArray);
        if (this.doGetItemCount() == 0) {
            this.doRemoveAll();
        }
    }

    public void remove(final Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        if (this.checkBusy()) {
            return;
        }
        if (objectArray.length == 0) {
            return;
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                AbstractTableViewer.this.internalRemove(objectArray);
            }
        });
    }

    public void remove(Object object) {
        this.remove(new Object[]{object});
    }

    @Override
    public void reveal(Object object) {
        Assert.isNotNull((Object)object);
        Widget widget = this.findItem(object);
        if (widget instanceof Item) {
            this.doShowItem((Item)widget);
        }
    }

    @Override
    protected void setSelectionToWidget(List list, boolean bl) {
        if (list == null) {
            this.doDeselectAll();
            return;
        }
        if (this.virtualManager != null) {
            this.virtualSetSelectionToWidget(list, bl);
            return;
        }
        if (bl) {
            int n = list.size();
            Item[] itemArray = new Item[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Object e = list.get(n3);
                Widget widget = this.findItem(e);
                if (widget instanceof Item) {
                    Item item = (Item)widget;
                    itemArray[n2++] = item;
                }
                ++n3;
            }
            if (n2 < n) {
                Item[] itemArray2 = itemArray;
                itemArray = new Item[n2];
                System.arraycopy(itemArray2, 0, itemArray, 0, n2);
            }
            this.doSetSelection(itemArray);
        } else {
            this.doDeselectAll();
            if (!list.isEmpty()) {
                int[] nArray = new int[list.size()];
                Iterator iterator = list.iterator();
                Item[] itemArray = this.doGetItems();
                int n = 0;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    boolean bl2 = false;
                    int n4 = 0;
                    while (n4 < itemArray.length && !bl2) {
                        if (this.equals(e, itemArray[n4].getData())) {
                            nArray[n++] = n4;
                            bl2 = true;
                        }
                        ++n4;
                    }
                }
                if (n < nArray.length) {
                    int[] nArray2 = nArray;
                    nArray = new int[n];
                    System.arraycopy(nArray2, 0, nArray, 0, n);
                }
                this.doSelect(nArray);
            }
        }
    }

    private void virtualSetSelectionToWidget(List list, boolean bl) {
        Widget widget;
        Object object;
        int n = list.size();
        int[] nArray = new int[list.size()];
        Item item = null;
        int n2 = 0;
        HashSet hashSet = new HashSet();
        int n3 = 0;
        while (n3 < n) {
            object = list.get(n3);
            widget = this.findItem(object);
            if (widget instanceof Item) {
                Item item2 = (Item)widget;
                nArray[n2++] = this.doIndexOf(item2);
                if (item == null) {
                    item = item2;
                }
            } else {
                hashSet.add(object);
            }
            ++n3;
        }
        if (this.getContentProvider() instanceof ILazyContentProvider) {
            ILazyContentProvider iLazyContentProvider = (ILazyContentProvider)this.getContentProvider();
            int n4 = 0;
            while (hashSet.size() > 0 && n4 < this.doGetItemCount()) {
                iLazyContentProvider.updateElement(n4);
                widget = this.doGetItem(n4);
                if (hashSet.contains(widget.getData())) {
                    nArray[n2++] = n4;
                    hashSet.remove(widget.getData());
                    if (item == null) {
                        item = widget;
                    }
                }
                ++n4;
            }
        } else if (n2 != list.size()) {
            n3 = 0;
            while (n3 < this.virtualManager.cachedElements.length) {
                object = this.virtualManager.cachedElements[n3];
                if (hashSet.contains(object)) {
                    widget = this.doGetItem(n3);
                    widget.getText();
                    nArray[n2++] = n3;
                    hashSet.remove(object);
                    if (item == null) {
                        item = widget;
                    }
                }
                ++n3;
            }
        }
        if (n2 < n) {
            int[] nArray2 = nArray;
            nArray = new int[n2];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
        }
        this.doDeselectAll();
        this.doSelect(nArray);
        if (bl && item != null) {
            this.doShowItem(item);
        }
    }

    public void setItemCount(int n) {
        if (this.checkBusy()) {
            return;
        }
        int n2 = this.doGetItemCount();
        if (n < n2) {
            int n3 = n;
            while (n3 < n2) {
                Item item = this.doGetItem(n3);
                if (item.getData() != null) {
                    this.disassociate(item);
                }
                ++n3;
            }
        }
        this.doSetItemCount(n);
        if (this.virtualManager != null) {
            this.virtualManager.adjustCacheSize(n);
        }
        this.getControl().redraw();
    }

    public void replace(Object object, int n) {
        if (this.checkBusy()) {
            return;
        }
        Item item = this.doGetItem(n);
        this.refreshItem((Widget)item, object);
    }

    public void clear(int n) {
        Item item = this.doGetItem(n);
        if (item.getData() != null) {
            this.disassociate(item);
        }
        this.doClear(n);
    }

    @Override
    protected Object[] getRawChildren(Object object) {
        Assert.isTrue((!(this.getContentProvider() instanceof ILazyContentProvider) ? 1 : 0) != 0, (String)"Cannot get raw children with an ILazyContentProvider");
        return super.getRawChildren(object);
    }

    @Override
    protected void assertContentProviderType(IContentProvider iContentProvider) {
        Assert.isTrue((iContentProvider instanceof IStructuredContentProvider || iContentProvider instanceof ILazyContentProvider ? 1 : 0) != 0);
    }

    protected abstract int doIndexOf(Item var1);

    protected abstract int doGetItemCount();

    protected abstract void doSetItemCount(int var1);

    protected abstract Item[] doGetItems();

    protected abstract Widget doGetColumn(int var1);

    protected abstract Item doGetItem(int var1);

    protected abstract Item[] doGetSelection();

    protected abstract int[] doGetSelectionIndices();

    protected abstract void doClearAll();

    protected abstract void doResetItem(Item var1);

    protected abstract void doRemove(int var1, int var2);

    protected abstract void doRemoveAll();

    protected abstract void doRemove(int[] var1);

    protected abstract void doShowItem(Item var1);

    protected abstract void doDeselectAll();

    protected abstract void doSetSelection(Item[] var1);

    protected abstract void doShowSelection();

    protected abstract void doSetSelection(int[] var1);

    protected abstract void doClear(int var1);

    protected abstract void doSelect(int[] var1);

    private class VirtualManager {
        private Object[] cachedElements = new Object[0];

        public VirtualManager() {
            this.addTableListener();
        }

        private void addTableListener() {
            AbstractTableViewer.this.getControl().addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    IContentProvider iContentProvider;
                    Item item = (Item)event.item;
                    int n = AbstractTableViewer.this.doIndexOf(item);
                    if (n == -1) {
                        return;
                    }
                    Object object = VirtualManager.this.resolveElement(n);
                    if (object == null && (iContentProvider = AbstractTableViewer.this.getContentProvider()) instanceof ILazyContentProvider) {
                        ((ILazyContentProvider)iContentProvider).updateElement(n);
                        return;
                    }
                    AbstractTableViewer.this.associate(object, item);
                    AbstractTableViewer.this.updateItem((Widget)item, object);
                }
            });
        }

        protected Object resolveElement(int n) {
            Object object = null;
            if (n < this.cachedElements.length) {
                object = this.cachedElements[n];
            }
            return object;
        }

        public void notVisibleAdded(Object object, int n) {
            int n2 = AbstractTableViewer.this.doGetItemCount() + 1;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.cachedElements, 0, objectArray, 0, n);
            if (n < this.cachedElements.length) {
                System.arraycopy(this.cachedElements, n, objectArray, n + 1, this.cachedElements.length - n);
            }
            objectArray[n] = object;
            this.cachedElements = objectArray;
            AbstractTableViewer.this.doSetItemCount(n2);
        }

        public void removeIndices(int[] nArray) {
            if (nArray.length == 1) {
                this.removeIndicesFromTo(nArray[0], nArray[0]);
            }
            int n = AbstractTableViewer.this.doGetItemCount() - nArray.length;
            Arrays.sort(nArray);
            Object[] objectArray = new Object[n];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.cachedElements.length) {
                if (n3 < nArray.length && n4 == nArray[n3]) {
                    ++n3;
                } else {
                    objectArray[n2++] = this.cachedElements[n4];
                }
                ++n4;
            }
            this.cachedElements = objectArray;
        }

        public void removeIndicesFromTo(int n, int n2) {
            int n3 = n2 + 1;
            Object[] objectArray = new Object[this.cachedElements.length - (n3 - n)];
            System.arraycopy(this.cachedElements, 0, objectArray, 0, n);
            if (n3 < this.cachedElements.length) {
                System.arraycopy(this.cachedElements, n3, objectArray, n, this.cachedElements.length - n3);
            }
        }

        public int find(Object object) {
            return Arrays.asList(this.cachedElements).indexOf(object);
        }

        public void adjustCacheSize(int n) {
            if (n == this.cachedElements.length) {
                return;
            }
            if (n < this.cachedElements.length) {
                Object[] objectArray = new Object[n];
                System.arraycopy(this.cachedElements, 0, objectArray, 0, n);
                this.cachedElements = objectArray;
            } else {
                Object[] objectArray = new Object[n];
                System.arraycopy(this.cachedElements, 0, objectArray, 0, this.cachedElements.length);
                this.cachedElements = objectArray;
            }
        }
    }
}

