/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractListViewer
extends StructuredViewer {
    private List listMap = new ArrayList();

    protected abstract void listAdd(String var1, int var2);

    protected abstract void listSetItem(int var1, String var2);

    protected abstract int[] listGetSelectionIndices();

    protected abstract int listGetItemCount();

    protected abstract void listSetItems(String[] var1);

    protected abstract void listRemoveAll();

    protected abstract void listRemove(int var1);

    protected abstract void listSetSelection(int[] var1);

    protected abstract void listShowSelection();

    protected abstract void listDeselectAll();

    public void add(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        Object[] objectArray2 = this.filter(objectArray);
        ILabelProvider iLabelProvider = (ILabelProvider)this.getLabelProvider();
        int n = 0;
        while (n < objectArray2.length) {
            Object object = objectArray2[n];
            int n2 = this.indexForElement(object);
            this.insertItem(iLabelProvider, object, n2);
            ++n;
        }
    }

    private void insertItem(ILabelProvider iLabelProvider, Object object, int n) {
        this.listAdd(this.getLabelProviderText(iLabelProvider, object), n);
        this.listMap.add(n, object);
        this.mapElement(object, (Widget)this.getControl());
    }

    public void insert(Object object, int n) {
        if (this.getComparator() != null || this.hasFilters()) {
            this.add(object);
            return;
        }
        this.insertItem((ILabelProvider)this.getLabelProvider(), object, n);
    }

    private String getLabelProviderText(ILabelProvider iLabelProvider, Object object) {
        String string = iLabelProvider.getText(object);
        if (string == null) {
            return "";
        }
        return string;
    }

    public void add(Object object) {
        this.add(new Object[]{object});
    }

    @Override
    protected Widget doFindInputItem(Object object) {
        if (object != null && this.equals(object, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    @Override
    protected Widget doFindItem(Object object) {
        if (object != null && this.listMapContains(object)) {
            return this.getControl();
        }
        return null;
    }

    @Override
    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        int n;
        if (object != null && (n = this.getElementIndex(object)) >= 0) {
            ILabelProvider iLabelProvider = (ILabelProvider)this.getLabelProvider();
            this.listSetItem(n, this.getLabelProviderText(iLabelProvider, object));
        }
    }

    public Object getElementAt(int n) {
        if (n >= 0 && n < this.listMap.size()) {
            return this.listMap.get(n);
        }
        return null;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    @Override
    protected List getSelectionFromWidget() {
        int[] nArray = this.listGetSelectionIndices();
        ArrayList<Object> arrayList = new ArrayList<Object>(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            Object object = this.getElementAt(nArray[n]);
            if (object != null) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    protected int indexForElement(Object object) {
        ViewerComparator viewerComparator = this.getComparator();
        if (viewerComparator == null) {
            return this.listGetItemCount();
        }
        int n = this.listGetItemCount();
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Object e = this.listMap.get(n4);
            int n5 = viewerComparator.compare(this, e, object);
            if (n5 == 0) {
                while (n5 == 0) {
                    if (++n4 >= n) break;
                    e = this.listMap.get(n4);
                    n5 = viewerComparator.compare(this, e, object);
                }
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    @Override
    protected void inputChanged(Object object, Object object2) {
        this.listMap.clear();
        Object[] objectArray = this.getSortedChildren(this.getRoot());
        int n = objectArray.length;
        this.listRemoveAll();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Object object3 = objectArray[n2];
            stringArray[n2] = this.getLabelProviderText((ILabelProvider)this.getLabelProvider(), object3);
            this.listMap.add(object3);
            this.mapElement(object3, (Widget)this.getControl());
            ++n2;
        }
        this.listSetItems(stringArray);
    }

    @Override
    protected void internalRefresh(Object object) {
        Control control = this.getControl();
        if (object == null || this.equals(object, this.getRoot())) {
            if (this.listMap != null) {
                this.listMap.clear();
            }
            this.unmapAllElements();
            List list = this.getSelectionFromWidget();
            int n = -1;
            if (list == null || list.isEmpty()) {
                n = this.listGetTopIndex();
            }
            Object[] objectArray = null;
            control.setRedraw(false);
            try {
                this.listRemoveAll();
                objectArray = this.getSortedChildren(this.getRoot());
                String[] stringArray = new String[objectArray.length];
                ILabelProvider iLabelProvider = (ILabelProvider)this.getLabelProvider();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    Object object2 = objectArray[n2];
                    stringArray[n2] = this.getLabelProviderText(iLabelProvider, object2);
                    this.listMap.add(object2);
                    this.mapElement(object2, (Widget)control);
                    ++n2;
                }
                this.listSetItems(stringArray);
            }
            finally {
                control.setRedraw(true);
            }
            if (n == -1) {
                this.setSelectionToWidget(list, false);
            } else {
                this.listSetTopIndex(Math.min(n, objectArray.length));
            }
        } else {
            this.doUpdateItem((Widget)control, object, true);
        }
    }

    protected int listGetTopIndex() {
        return -1;
    }

    protected void listSetTopIndex(int n) {
    }

    private void internalRemove(Object[] objectArray) {
        Object object = this.getInput();
        int n = 0;
        while (n < objectArray.length) {
            if (this.equals(objectArray[n], object)) {
                this.setInput(null);
                return;
            }
            int n2 = this.getElementIndex(objectArray[n]);
            if (n2 >= 0) {
                this.listRemove(n2);
                this.listMap.remove(n2);
                this.unmapElement(objectArray[n], (Widget)this.getControl());
            }
            ++n;
        }
    }

    public void remove(final Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        if (objectArray.length == 0) {
            return;
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                AbstractListViewer.this.internalRemove(objectArray);
            }
        });
    }

    public void remove(Object object) {
        this.remove(new Object[]{object});
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        Assert.isTrue((boolean)(iBaseLabelProvider instanceof ILabelProvider));
        super.setLabelProvider(iBaseLabelProvider);
    }

    @Override
    protected void setSelectionToWidget(List list, boolean bl) {
        if (list == null || list.size() == 0) {
            this.listDeselectAll();
        } else {
            int n = list.size();
            int[] nArray = new int[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Object e = list.get(n3);
                int n4 = this.getElementIndex(e);
                if (n4 >= 0) {
                    nArray[n2++] = n4;
                }
                ++n3;
            }
            if (n2 < n) {
                int[] nArray2 = nArray;
                nArray = new int[n2];
                System.arraycopy(nArray2, 0, nArray, 0, n2);
            }
            this.listSetSelection(nArray);
            if (bl) {
                this.listShowSelection();
            }
        }
    }

    int getElementIndex(Object object) {
        IElementComparer iElementComparer = this.getComparer();
        if (iElementComparer == null) {
            return this.listMap.indexOf(object);
        }
        int n = this.listMap.size();
        int n2 = 0;
        while (n2 < n) {
            if (iElementComparer.equals(object, this.listMap.get(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private boolean listMapContains(Object object) {
        return this.getElementIndex(object) != -1;
    }
}

