/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.swt.SWT;

public final class Util {
    public static final SortedSet EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    public static final String ZERO_LENGTH_STRING = "";
    public static final String WS_WIN32 = "win32";
    public static final String WS_MOTIF = "motif";
    public static final String WS_GTK = "gtk";
    public static final String WS_PHOTON = "photon";
    public static final String WS_CARBON = "carbon";
    public static final String WS_COCOA = "cocoa";
    public static final String WS_WPF = "wpf";
    public static final String WS_UNKNOWN = "unknown";

    public static final void assertInstance(Object object, Class clazz) {
        Util.assertInstance(object, clazz, false);
    }

    private static final void assertInstance(Object object, Class clazz, boolean bl) {
        if (object == null && bl) {
            return;
        }
        if (object == null || clazz == null) {
            throw new NullPointerException();
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static final int compare(boolean bl, boolean bl2) {
        return !bl ? (bl2 ? -1 : 0) : 1;
    }

    public static final int compare(int n, int n2) {
        return n - n2;
    }

    public static final int compare(Comparable comparable, Comparable comparable2) {
        if (comparable == null && comparable2 == null) {
            return 0;
        }
        if (comparable == null) {
            return -1;
        }
        if (comparable2 == null) {
            return 1;
        }
        return comparable.compareTo(comparable2);
    }

    public static final int compare(Comparable[] comparableArray, Comparable[] comparableArray2) {
        if (comparableArray == null && comparableArray2 == null) {
            return 0;
        }
        if (comparableArray == null) {
            return -1;
        }
        if (comparableArray2 == null) {
            return 1;
        }
        int n = comparableArray.length;
        int n2 = comparableArray2.length;
        if (n != n2) {
            return n - n2;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = Util.compare(comparableArray[n3], comparableArray2[n3]);
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public static final int compare(List list, List list2) {
        int n;
        if (list == null && list2 == null) {
            return 0;
        }
        if (list == null) {
            return -1;
        }
        if (list2 == null) {
            return 1;
        }
        int n2 = list.size();
        if (n2 != (n = list2.size())) {
            return n2 - n;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Util.compare((Comparable)list.get(n3), (Comparable)list2.get(n3));
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public static final boolean endsWith(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray2.length;
        int n2 = objectArray.length;
        if (n > n2 || !bl && n == n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!Util.equals(objectArray[n2 - n3 - 1], objectArray2[n - n3 - 1])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object2 != null && object.equals(object2);
    }

    public static final boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            boolean bl;
            Object object = objectArray[n];
            Object object2 = objectArray2[n];
            boolean bl2 = object == null ? object2 == null : (bl = object.equals(object2));
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final int hashCode(int n) {
        return n;
    }

    public static final int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static final int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 89;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if (object != null) {
                n = n * 31 + object.hashCode();
            }
            ++n2;
        }
        return n;
    }

    public static final boolean startsWith(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray2.length;
        int n2 = objectArray.length;
        if (n > n2 || !bl && n == n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!Util.equals(objectArray[n3], objectArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (n2 != 0) {
                stringBuffer.append(',');
            }
            Object object = objectArray[n2];
            String string = String.valueOf(object);
            stringBuffer.append(string);
            ++n2;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static final String translateString(ResourceBundle resourceBundle, String string, String string2) {
        if (resourceBundle != null && string != null) {
            try {
                String string3 = resourceBundle.getString(string);
                if (string3 != null) {
                    return string3;
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string2;
    }

    public static final String replaceAll(String string, String string2, String string3) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = string.indexOf(string2);
        if (n3 < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n3 != -1 && n3 < n) {
            stringBuffer.append(string.substring(n4, n3));
            stringBuffer.append(string3);
            n4 = n3 + n2;
            n3 = n4 < n ? string.indexOf(string2, n4) : -1;
        }
        if (n4 < n) {
            stringBuffer.append(string.substring(n4, n3 == -1 ? n : n3));
        }
        return stringBuffer.toString();
    }

    public static final boolean isWindows() {
        String string = SWT.getPlatform();
        return WS_WIN32.equals(string) || WS_WPF.equals(string);
    }

    public static final boolean isMac() {
        String string = SWT.getPlatform();
        return WS_CARBON.equals(string) || WS_COCOA.equals(string);
    }

    public static final boolean isLinux() {
        String string = SWT.getPlatform();
        return WS_GTK.equals(string) || WS_MOTIF.equals(string);
    }

    public static final boolean isGtk() {
        String string = SWT.getPlatform();
        return WS_GTK.equals(string);
    }

    public static final boolean isMotif() {
        String string = SWT.getPlatform();
        return WS_MOTIF.equals(string);
    }

    public static final boolean isPhoton() {
        String string = SWT.getPlatform();
        return WS_PHOTON.equals(string);
    }

    public static final boolean isCarbon() {
        String string = SWT.getPlatform();
        return WS_CARBON.equals(string);
    }

    public static final boolean isCocoa() {
        String string = SWT.getPlatform();
        return WS_COCOA.equals(string);
    }

    public static final boolean isWpf() {
        String string = SWT.getPlatform();
        return WS_WPF.equals(string);
    }

    public static final boolean isWin32() {
        String string = SWT.getPlatform();
        return WS_WIN32.equals(string);
    }

    public static final String getWS() {
        return SWT.getPlatform();
    }

    private Util() {
    }
}

