/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class SafeRunnableDialog
extends ErrorDialog {
    private TableViewer statusListViewer;
    private Collection statuses = new ArrayList();

    SafeRunnableDialog(IStatus iStatus) {
        super(null, JFaceResources.getString("error"), iStatus.getMessage(), iStatus, 4);
        this.setShellStyle(0xCF0 | SafeRunnableDialog.getDefaultOrientation());
        this.setStatus(iStatus);
        this.statuses.add(iStatus);
        this.setBlockOnOpen(false);
        String string = JFaceResources.getString("SafeRunnableDialog_checkDetailsMessage");
        if (iStatus.getException() != null) {
            string = iStatus.getException().getMessage() == null ? iStatus.getException().toString() : iStatus.getException().getMessage();
        }
        this.message = JFaceResources.format("SafeRunnableDialog_reason", new Object[]{iStatus.getMessage(), string});
    }

    void refresh() {
        if (AUTOMATED_MODE) {
            return;
        }
        this.createStatusList((Composite)this.dialogArea);
        this.updateEnablements();
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Control control = super.createDialogArea(composite);
        this.createStatusList((Composite)control);
        return control;
    }

    private void createStatusList(Composite composite) {
        if (this.isMultipleStatusDialog()) {
            if (this.statusListViewer == null) {
                this.setMessage(JFaceResources.getString("SafeRunnableDialog_MultipleErrorsMessage"));
                this.getShell().setText(JFaceResources.getString("SafeRunnableDialog_MultipleErrorsTitle"));
                this.createStatusListArea(composite);
                this.showDetailsArea();
            }
            this.refreshStatusList();
        }
    }

    private void updateEnablements() {
        Button button = this.getButton(13);
        if (button != null) {
            button.setEnabled(true);
        }
    }

    private void setMessage(String string) {
        String string2 = this.message = string == null ? "" : string;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(this.message);
    }

    private void createStatusListArea(Composite composite) {
        this.statusListViewer = new TableViewer(composite, 2820);
        this.statusListViewer.setComparator(this.getViewerComparator());
        Control control = this.statusListViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        gridData.horizontalSpan = 2;
        control.setLayoutData((Object)gridData);
        this.statusListViewer.setContentProvider(this.getStatusContentProvider());
        this.statusListViewer.setLabelProvider(this.getStatusListLabelProvider());
        this.statusListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SafeRunnableDialog.this.handleSelectionChange();
            }
        });
        SafeRunnableDialog.applyDialogFont((Control)composite);
        this.statusListViewer.setInput(this);
    }

    private CellLabelProvider getStatusListLabelProvider() {
        return new CellLabelProvider(){

            @Override
            public void update(ViewerCell viewerCell) {
                viewerCell.setText(((IStatus)viewerCell.getElement()).getMessage());
            }
        };
    }

    private IStructuredContentProvider getStatusContentProvider() {
        return new IStructuredContentProvider(){

            @Override
            public Object[] getElements(Object object) {
                return SafeRunnableDialog.this.statuses.toArray();
            }

            @Override
            public void dispose() {
            }

            @Override
            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        };
    }

    private boolean isMultipleStatusDialog() {
        return this.statuses.size() > 1;
    }

    private ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            @Override
            public int compare(Viewer viewer, Object object, Object object2) {
                String string = ((IStatus)object).getMessage();
                String string2 = ((IStatus)object2).getMessage();
                if (string == null) {
                    return 1;
                }
                if (string2 == null) {
                    return -1;
                }
                return string.compareTo(string2);
            }
        };
    }

    void refreshStatusList() {
        if (this.statusListViewer != null && !this.statusListViewer.getControl().isDisposed()) {
            this.statusListViewer.refresh();
            Point point = this.getShell().computeSize(-1, -1);
            this.getShell().setSize(point);
        }
    }

    private IStatus getSingleSelection() {
        IStructuredSelection iStructuredSelection;
        ISelection iSelection = this.statusListViewer.getSelection();
        if (iSelection != null && iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
            return (IStatus)iStructuredSelection.getFirstElement();
        }
        return null;
    }

    void handleSelectionChange() {
        IStatus iStatus = this.getSingleSelection();
        this.setStatus(iStatus);
        this.updateEnablements();
        this.showDetailsArea();
    }

    @Override
    protected boolean shouldShowDetailsButton() {
        return true;
    }

    public void addStatus(IStatus iStatus) {
        this.statuses.add(iStatus);
        this.refresh();
    }
}

