/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.AnimatorFactory;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.util.ILogger;
import org.eclipse.jface.util.SafeRunnableDialog;
import org.eclipse.jface.util.StatusHandler;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;

public class Policy {
    public static final boolean DEFAULT = false;
    public static final String JFACE = "org.eclipse.jface";
    private static ILogger log;
    private static Comparator viewerComparator;
    private static AnimatorFactory animatorFactory;
    public static boolean DEBUG_DIALOG_NO_PARENT;
    public static boolean TRACE_ACTIONS;
    public static boolean TRACE_TOOLBAR;
    private static ErrorSupportProvider errorSupportProvider;
    private static StatusHandler statusHandler;

    static {
        DEBUG_DIALOG_NO_PARENT = false;
        TRACE_ACTIONS = false;
        TRACE_TOOLBAR = false;
    }

    private static ILogger getDummyLog() {
        return new ILogger(){

            @Override
            public void log(IStatus iStatus) {
                System.err.println(iStatus.getMessage());
                if (iStatus.getException() != null) {
                    iStatus.getException().printStackTrace(System.err);
                }
            }
        };
    }

    public static void setLog(ILogger iLogger) {
        log = iLogger;
    }

    public static ILogger getLog() {
        if (log == null) {
            log = Policy.getDummyLog();
        }
        return log;
    }

    public static void setStatusHandler(StatusHandler statusHandler) {
        Policy.statusHandler = statusHandler;
    }

    public static StatusHandler getStatusHandler() {
        if (statusHandler == null) {
            statusHandler = Policy.getDummyStatusHandler();
        }
        return statusHandler;
    }

    private static StatusHandler getDummyStatusHandler() {
        return new StatusHandler(){
            private SafeRunnableDialog dialog;

            @Override
            public void show(final IStatus iStatus, String string) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (dialog == null || dialog.getShell().isDisposed()) {
                            dialog = new SafeRunnableDialog(iStatus);
                            dialog.create();
                            dialog.getShell().addDisposeListener(new DisposeListener(){

                                public void widgetDisposed(DisposeEvent disposeEvent) {
                                    dialog = null;
                                }
                            });
                            dialog.open();
                        } else {
                            dialog.addStatus(iStatus);
                            dialog.refresh();
                        }
                    }
                };
                if (Display.getCurrent() != null) {
                    runnable.run();
                } else {
                    Display.getDefault().asyncExec(runnable);
                }
            }
        };
    }

    private static Comparator getDefaultComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        };
    }

    public static Comparator getComparator() {
        if (viewerComparator == null) {
            viewerComparator = Policy.getDefaultComparator();
        }
        return viewerComparator;
    }

    public static void setComparator(Comparator comparator) {
        Assert.isTrue((viewerComparator == null ? 1 : 0) != 0);
        viewerComparator = comparator;
    }

    public static void setAnimatorFactory(AnimatorFactory animatorFactory) {
        Policy.animatorFactory = animatorFactory;
    }

    public static AnimatorFactory getAnimatorFactory() {
        if (animatorFactory == null) {
            animatorFactory = new AnimatorFactory();
        }
        return animatorFactory;
    }

    public static void setErrorSupportProvider(ErrorSupportProvider errorSupportProvider) {
        Policy.errorSupportProvider = errorSupportProvider;
    }

    public static ErrorSupportProvider getErrorSupportProvider() {
        return errorSupportProvider;
    }

    public static void logException(Exception exception) {
        Policy.getLog().log((IStatus)new Status(4, JFACE, exception.getLocalizedMessage(), (Throwable)exception));
    }
}

